/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.event.RoleEvent;
import noppes.npcs.constants.EnumCompanionTalent;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.BankData;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleTransporter;

public class PacketHandlerPlayer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        final EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        final ByteBuf buffer = event.getPacket().payload();
        player.func_184102_h().func_152344_a(new Runnable(){

            @Override
            public void run() {
                EnumPlayerPacket type = null;
                try {
                    type = EnumPlayerPacket.values()[buffer.readInt()];
                    PacketHandlerPlayer.this.player(buffer, player, type);
                }
                catch (Exception e) {
                    LogWriter.error("Error with EnumPlayerPacket." + (Object)((Object)type), e);
                }
            }
        });
    }

    private void player(ByteBuf buffer, EntityPlayerMP player, EnumPlayerPacket type) throws Exception {
        block21: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            Object data;
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            EntityNPCInterface npc;
                                            block31: {
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                block26: {
                                                                    block25: {
                                                                        block24: {
                                                                            block23: {
                                                                                block22: {
                                                                                    if (type == EnumPlayerPacket.MarkData) {
                                                                                        Entity entity = player.func_184102_h().func_175576_a(Server.readUUID(buffer));
                                                                                        if (entity == null || !(entity instanceof EntityLivingBase)) {
                                                                                            return;
                                                                                        }
                                                                                        MarkData markData = MarkData.get((EntityLivingBase)entity);
                                                                                    }
                                                                                    if (type != EnumPlayerPacket.CompanionTalentExp) break block22;
                                                                                    npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                                                    if (npc == null || npc.advanced.role != 6 || player != npc.getOwner()) {
                                                                                        return;
                                                                                    }
                                                                                    int id = buffer.readInt();
                                                                                    int exp = buffer.readInt();
                                                                                    RoleCompanion role = (RoleCompanion)npc.roleInterface;
                                                                                    if (exp <= 0 || !role.canAddExp(-exp) || id < 0 || id >= EnumCompanionTalent.values().length) {
                                                                                        return;
                                                                                    }
                                                                                    EnumCompanionTalent talent = EnumCompanionTalent.values()[id];
                                                                                    role.addExp(-exp);
                                                                                    role.addTalentExp(talent, exp);
                                                                                    break block21;
                                                                                }
                                                                                if (type != EnumPlayerPacket.CompanionOpenInv) break block23;
                                                                                npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                                                if (npc == null || npc.advanced.role != 6 || player != npc.getOwner()) {
                                                                                    return;
                                                                                }
                                                                                NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.CompanionInv, npc);
                                                                                break block21;
                                                                            }
                                                                            if (type != EnumPlayerPacket.FollowerHire) break block24;
                                                                            npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                                            if (npc == null || npc.advanced.role != 2) {
                                                                                return;
                                                                            }
                                                                            NoppesUtilPlayer.hireFollower(player, npc);
                                                                            break block21;
                                                                        }
                                                                        if (type != EnumPlayerPacket.FollowerExtend) break block25;
                                                                        npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                                        if (npc == null || npc.advanced.role != 2) {
                                                                            return;
                                                                        }
                                                                        NoppesUtilPlayer.extendFollower(player, npc);
                                                                        Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
                                                                        break block21;
                                                                    }
                                                                    if (type != EnumPlayerPacket.FollowerState) break block26;
                                                                    npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                                    if (npc == null || npc.advanced.role != 2) {
                                                                        return;
                                                                    }
                                                                    NoppesUtilPlayer.changeFollowerState(player, npc);
                                                                    Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
                                                                    break block21;
                                                                }
                                                                if (type != EnumPlayerPacket.RoleGet) break block27;
                                                                npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                                if (npc == null || npc.advanced.role == 0) {
                                                                    return;
                                                                }
                                                                Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(new NBTTagCompound()));
                                                                break block21;
                                                            }
                                                            if (type != EnumPlayerPacket.Transport) break block28;
                                                            npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                            if (npc == null || npc.advanced.role != 4) {
                                                                return;
                                                            }
                                                            ((RoleTransporter)npc.roleInterface).transport(player, Server.readString(buffer));
                                                            break block21;
                                                        }
                                                        if (type != EnumPlayerPacket.BankUpgrade) break block29;
                                                        npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                        if (npc == null || npc.advanced.role != 3) {
                                                            return;
                                                        }
                                                        NoppesUtilPlayer.bankUpgrade(player, npc);
                                                        break block21;
                                                    }
                                                    if (type != EnumPlayerPacket.BankUnlock) break block30;
                                                    npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                    if (npc == null || npc.advanced.role != 3) {
                                                        return;
                                                    }
                                                    NoppesUtilPlayer.bankUnlock(player, npc);
                                                    break block21;
                                                }
                                                if (type != EnumPlayerPacket.BankSlotOpen) break block31;
                                                npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                                if (npc == null || npc.advanced.role != 3) {
                                                    return;
                                                }
                                                int slot = buffer.readInt();
                                                int bankId = buffer.readInt();
                                                BankData data2 = PlayerDataController.instance.getBankData((EntityPlayer)player, bankId).getBankOrDefault(bankId);
                                                data2.openBankGui((EntityPlayer)player, npc, bankId, slot);
                                                break block21;
                                            }
                                            if (type != EnumPlayerPacket.Dialog) break block32;
                                            npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                                            if (npc == null) {
                                                return;
                                            }
                                            NoppesUtilPlayer.dialogSelected(buffer.readInt(), buffer.readInt(), player, npc);
                                            break block21;
                                        }
                                        if (type != EnumPlayerPacket.CheckQuestCompletion) break block33;
                                        PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
                                        playerdata.checkQuestCompletion((EntityPlayer)player, -1);
                                        break block21;
                                    }
                                    if (type != EnumPlayerPacket.QuestCompletion) break block34;
                                    NoppesUtilPlayer.questCompletion(player, buffer.readInt());
                                    break block21;
                                }
                                if (type != EnumPlayerPacket.FactionsGet) break block35;
                                data = PlayerData.get((EntityPlayer)player).factionData;
                                Server.sendData(player, EnumPacketClient.GUI_DATA, ((PlayerFactionData)data).getPlayerGuiData());
                                break block21;
                            }
                            if (type != EnumPlayerPacket.MailGet) break block36;
                            data = PlayerData.get((EntityPlayer)player).mailData;
                            Server.sendData(player, EnumPacketClient.GUI_DATA, ((PlayerMailData)data).saveNBTData(new NBTTagCompound()));
                            break block21;
                        }
                        if (type != EnumPlayerPacket.MailDelete) break block37;
                        long time = buffer.readLong();
                        String username = Server.readString(buffer);
                        PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
                        Iterator<PlayerMail> it = data.playermail.iterator();
                        while (it.hasNext()) {
                            PlayerMail mail = it.next();
                            if (mail.time != time || !mail.sender.equals(username)) continue;
                            it.remove();
                        }
                        Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
                        break block21;
                    }
                    if (type != EnumPlayerPacket.MailSend) break block38;
                    String username = PlayerDataController.instance.hasPlayer(Server.readString(buffer));
                    if (username.isEmpty()) {
                        NoppesUtilServer.sendGuiError((EntityPlayer)player, 0);
                        return;
                    }
                    PlayerMail mail = new PlayerMail();
                    String s = player.getDisplayNameString();
                    if (!s.equals(player.func_70005_c_())) {
                        s = s + "(" + player.func_70005_c_() + ")";
                    }
                    mail.readNBT(Server.readNBT(buffer));
                    mail.sender = s;
                    mail.items = ((ContainerMail)player.field_71070_bA).mail.items;
                    if (mail.subject.isEmpty()) {
                        NoppesUtilServer.sendGuiError((EntityPlayer)player, 1);
                        return;
                    }
                    NBTTagCompound comp = new NBTTagCompound();
                    comp.func_74778_a("username", username);
                    NoppesUtilServer.sendGuiClose(player, 1, comp);
                    EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                    if (npc != null && EventHooks.onNPCRole(npc, new RoleEvent.MailmanEvent((EntityPlayer)player, npc.wrappedNPC, mail))) {
                        return;
                    }
                    PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), username, mail);
                    break block21;
                }
                if (type != EnumPlayerPacket.MailboxOpenMail) break block39;
                long time = buffer.readLong();
                String username = Server.readString(buffer);
                player.func_71128_l();
                PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
                for (PlayerMail mail : data.playermail) {
                    if (mail.time != time || !mail.sender.equals(username)) continue;
                    ContainerMail.staticmail = mail;
                    player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 0, 0, 0);
                    break block21;
                }
                break block21;
            }
            if (type != EnumPlayerPacket.MailRead) break block21;
            long time = buffer.readLong();
            String username = Server.readString(buffer);
            PlayerMailData data = PlayerData.get((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                mail.beenRead = true;
                if (!mail.hasQuest()) continue;
                PlayerQuestController.addActiveQuest(mail.getQuest(), (EntityPlayer)player);
            }
        }
    }
}

