/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.BlockFluidBase;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.wrapper.BlockFluidContainerWrapper;
import noppes.npcs.api.wrapper.BlockScriptedDoorWrapper;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.blocks.BlockScripted;
import noppes.npcs.blocks.BlockScriptedDoor;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.util.LRUHashMap;

public class BlockWrapper
implements IBlock {
    private static final Map<String, BlockWrapper> blockCache = new LRUHashMap<String, BlockWrapper>(400);
    protected final IWorld world;
    protected final Block block;
    protected final BlockPos pos;
    protected TileEntity tile;
    private final IData tempdata = new IData(){

        @Override
        public void remove(String key) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return;
            }
            ((TileNpcEntity)BlockWrapper.this.tile).tempData.remove(key);
        }

        @Override
        public void put(String key, Object value) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return;
            }
            ((TileNpcEntity)BlockWrapper.this.tile).tempData.put(key, value);
        }

        @Override
        public boolean has(String key) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return false;
            }
            return ((TileNpcEntity)BlockWrapper.this.tile).tempData.containsKey(key);
        }

        @Override
        public Object get(String key) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return null;
            }
            return ((TileNpcEntity)BlockWrapper.this.tile).tempData.get(key);
        }

        @Override
        public void clear() {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return;
            }
            ((TileNpcEntity)BlockWrapper.this.tile).tempData.clear();
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return;
            }
            NBTTagCompound compound = ((TileNpcEntity)BlockWrapper.this.tile).extraData;
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
            ScriptController.Instance.shouldSave = true;
        }

        @Override
        public Object get(String key) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return null;
            }
            NBTTagCompound compound = ((TileNpcEntity)BlockWrapper.this.tile).extraData;
            if (!compound.func_74764_b(key)) {
                return null;
            }
            NBTBase base = compound.func_74781_a(key);
            if (base instanceof NBTPrimitive) {
                return ((NBTPrimitive)base).func_150286_g();
            }
            return ((NBTTagString)base).func_150285_a_();
        }

        @Override
        public void remove(String key) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return;
            }
            ((TileNpcEntity)BlockWrapper.this.tile).extraData.func_82580_o(key);
        }

        @Override
        public boolean has(String key) {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return false;
            }
            return ((TileNpcEntity)BlockWrapper.this.tile).extraData.func_74764_b(key);
        }

        @Override
        public void clear() {
            if (!(BlockWrapper.this.tile instanceof TileNpcEntity)) {
                return;
            }
            ((TileNpcEntity)BlockWrapper.this.tile).extraData = new NBTTagCompound();
        }
    };

    protected BlockWrapper(World world, Block block, BlockPos pos) {
        this.world = NpcAPI.Instance().getIWorld((WorldServer)world);
        this.block = block;
        this.pos = pos;
        this.tile = world.func_175625_s(pos);
    }

    @Override
    public int getX() {
        return this.pos.func_177958_n();
    }

    @Override
    public int getY() {
        return this.pos.func_177956_o();
    }

    @Override
    public int getZ() {
        return this.pos.func_177952_p();
    }

    @Override
    public int getMetadata() {
        return this.block.func_176201_c(this.world.getMCWorld().func_180495_p(this.pos));
    }

    @Override
    public void setMetadata(int i) {
        this.world.getMCWorld().func_180501_a(this.pos, this.block.func_176203_a(i), 3);
    }

    @Override
    public void remove() {
        this.world.getMCWorld().func_175698_g(this.pos);
    }

    @Override
    public boolean isRemoved() {
        IBlockState state = this.world.getMCWorld().func_180495_p(this.pos);
        if (state == null) {
            return true;
        }
        return state.func_177230_c() != this.block;
    }

    @Override
    public BlockWrapper setBlock(String name) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
        if (block == null) {
            return this;
        }
        this.world.getMCWorld().func_175656_a(this.pos, block.func_176223_P());
        return new BlockWrapper((World)this.world.getMCWorld(), block, this.pos);
    }

    @Override
    public BlockWrapper setBlock(IBlock block) {
        this.world.getMCWorld().func_175656_a(this.pos, block.getMCBlock().func_176223_P());
        return new BlockWrapper((World)this.world.getMCWorld(), block.getMCBlock(), this.pos);
    }

    @Override
    public boolean isContainer() {
        if (this.tile == null || !(this.tile instanceof IInventory)) {
            return false;
        }
        return ((IInventory)this.tile).func_70302_i_() > 0;
    }

    @Override
    public IContainer getContainer() {
        if (!this.isContainer()) {
            throw new CustomNPCsException("This block is not a container", new Object[0]);
        }
        return NpcAPI.Instance().getIContainer((IInventory)this.tile);
    }

    @Override
    public boolean canStoreData() {
        return this.tile instanceof TileNpcEntity;
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public String getName() {
        return Block.field_149771_c.func_177774_c((Object)this.block) + "";
    }

    @Override
    public IWorld getWorld() {
        return this.world;
    }

    @Override
    public Block getMCBlock() {
        return this.block;
    }

    @Override
    public TileEntity getMCTileEntity() {
        return this.tile;
    }

    @Deprecated
    public static IBlock createNew(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == null || block.isAir(state, (IBlockAccess)world, pos)) {
            return null;
        }
        String key = state.toString() + pos.toString();
        BlockWrapper b = blockCache.get(key);
        if (b != null) {
            b.tile = world.func_175625_s(pos);
            return b;
        }
        b = block instanceof BlockScripted ? new BlockScriptedWrapper(world, block, pos) : (block instanceof BlockScriptedDoor ? new BlockScriptedDoorWrapper(world, block, pos) : (block instanceof BlockFluidBase ? new BlockFluidContainerWrapper(world, block, pos) : new BlockWrapper(world, block, pos)));
        blockCache.put(key, b);
        return b;
    }

    public static void clearCache() {
        blockCache.clear();
    }
}

