/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemBookWrapper;

public class ItemStackWrapper
implements IItemStack {
    public ItemStack item;

    protected ItemStackWrapper(ItemStack item) {
        this.item = item;
    }

    @Override
    public int getStackSize() {
        return this.item.func_190916_E();
    }

    @Override
    public void setStackSize(int size) {
        if (size < 0) {
            size = 1;
        } else if (size > 64) {
            size = 64;
        }
        this.item.func_190920_e(size);
    }

    @Override
    public int getItemDamage() {
        return this.item.func_77952_i();
    }

    @Override
    public void setItemDamage(int value) {
        this.item.func_77964_b(value);
    }

    @Override
    public void addEnchantment(String id, int strenght) {
        Enchantment ench = Enchantment.func_180305_b((String)id);
        if (ench == null) {
            throw new CustomNPCsException("Unknown enchant id:" + id, new Object[0]);
        }
        this.item.func_77966_a(ench, strenght);
    }

    @Override
    public boolean isEnchanted() {
        return this.item.func_77948_v();
    }

    @Override
    public boolean hasEnchant(int id) {
        if (!this.isEnchanted()) {
            return false;
        }
        NBTTagList list = this.item.func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            if (compound.func_74765_d("id") != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlock() {
        Block block = Block.func_149634_a((Item)this.item.func_77973_b());
        return block != null && block != Blocks.field_150350_a;
    }

    @Override
    public boolean hasCustomName() {
        return this.item.func_82837_s();
    }

    @Override
    public void setCustomName(String name) {
        this.item.func_151001_c(name);
    }

    @Override
    public String getDisplayName() {
        return this.item.func_82833_r();
    }

    @Override
    public String getItemName() {
        return this.item.func_77973_b().func_77653_i(this.item);
    }

    @Override
    public String getName() {
        return Item.field_150901_e.func_177774_c((Object)this.item.func_77973_b()) + "";
    }

    @Override
    public INbt getNbt() {
        NBTTagCompound compound = this.item.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            this.item.func_77982_d(compound);
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public boolean hasNbt() {
        return this.item.func_77942_o();
    }

    @Override
    public ItemStack getMCItemStack() {
        return this.item;
    }

    public static ItemStack MCItem(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return item.getMCItemStack();
    }

    @Override
    public void damageItem(int damage, IEntityLiving living) {
        this.item.func_77972_a(damage, living == null ? null : (EntityLivingBase)living.getMCEntity());
    }

    @Override
    public boolean isBook() {
        return false;
    }

    @Deprecated
    public static IItemStack createNew(ItemStack item) {
        if (NoppesUtilServer.IsItemStackNull(item)) {
            return null;
        }
        if (item.func_77973_b() == Items.field_151164_bB || item.func_77973_b() == Items.field_151099_bA || item.func_77973_b() instanceof ItemWritableBook || item.func_77973_b() instanceof ItemWrittenBook) {
            return new ItemBookWrapper(item);
        }
        return new ItemStackWrapper(item);
    }

    @Override
    public IItemStack copy() {
        return ItemStackWrapper.createNew(this.item.func_77946_l());
    }

    @Override
    public int getMaxStackSize() {
        return this.item.func_77976_d();
    }

    @Override
    public int getMaxItemDamage() {
        return this.item.func_77958_k();
    }

    @Override
    public INbt getItemNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        this.item.func_77955_b(compound);
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public double getAttackDamage() {
        HashMultimap map = (HashMultimap)this.item.func_111283_C(EntityEquipmentSlot.MAINHAND);
        Iterator iterator = map.entries().iterator();
        double damage = 0.0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!entry.getKey().equals(SharedMonsterAttributes.field_111264_e.func_111108_a())) continue;
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            damage = mod.func_111164_d();
        }
        return damage += (double)EnchantmentHelper.func_152377_a((ItemStack)this.item, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
    }
}

