/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPixelmon;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IPixelmonPlayerData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.PixelmonWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.util.ValueUtil;

public class PlayerWrapper<T extends EntityPlayerMP>
extends EntityLivingBaseWrapper<T>
implements IPlayer {
    private PlayerData data;

    public PlayerWrapper(T player) {
        super(player);
    }

    @Override
    public String getName() {
        return ((EntityPlayerMP)this.entity).func_70005_c_();
    }

    @Override
    public String getDisplayName() {
        return ((EntityPlayerMP)this.entity).getDisplayNameString();
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.activeQuests.containsKey(id);
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        QuestData questdata = new QuestData(quest);
        this.getData().questData.activeQuests.put(id, questdata);
        Server.sendData((EntityPlayerMP)this.entity, EnumPacketClient.MESSAGE, "quest.newquest", quest.title);
        Server.sendData((EntityPlayerMP)this.entity, EnumPacketClient.CHAT, "quest.newquest", ": ", quest.title);
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        this.getData().questData.finishedQuests.put(id, System.currentTimeMillis());
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        this.getData().questData.activeQuests.remove(id);
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        this.getData().questData.activeQuests.remove(id);
        this.getData().questData.finishedQuests.remove(id);
    }

    @Override
    public boolean hasReadDialog(int id) {
        PlayerDialogData data = this.getData().dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public void showDialog(int id, String name) {
        Dialog dialog = DialogController.instance.dialogs.get(id);
        if (dialog == null) {
            throw new CustomNPCsException("Unknown Dialog id: " + id, new Object[0]);
        }
        if (!dialog.availability.isAvailable((EntityPlayer)this.entity)) {
            return;
        }
        EntityDialogNpc npc = new EntityDialogNpc((World)this.getWorld().getMCWorld());
        npc.display.setName(name);
        EntityUtil.Copy((EntityLivingBase)this.entity, (EntityLivingBase)npc);
        DialogOption option = new DialogOption();
        option.dialogId = id;
        option.title = dialog.title;
        npc.dialogs.put(0, option);
        NoppesUtilServer.openDialog((EntityPlayer)this.entity, npc, dialog);
    }

    @Override
    public void addFactionPoints(int faction, int points) {
        this.getData().factionData.increasePoints(faction, points);
    }

    @Override
    public int getFactionPoints(int faction) {
        return this.getData().factionData.getFactionPoints(faction);
    }

    @Override
    public float getRotation() {
        return ((EntityPlayerMP)this.entity).field_70177_z;
    }

    @Override
    public void setRotation(float rotation) {
        ((EntityPlayerMP)this.entity).field_70177_z = rotation;
    }

    @Override
    public void message(String message) {
        ((EntityPlayerMP)this.entity).func_145747_a((ITextComponent)new TextComponentTranslation(NoppesStringUtils.formatText(message, this.entity), new Object[0]));
    }

    @Override
    public int getGamemode() {
        return ((EntityPlayerMP)this.entity).field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setGamemode(int type) {
        ((EntityPlayerMP)this.entity).func_71033_a(WorldSettings.func_77161_a((int)type));
    }

    @Override
    public int inventoryItemCount(IItemStack item) {
        int i = 0;
        for (ItemStack is : ((EntityPlayerMP)this.entity).field_71071_by.field_70462_a) {
            if (is == null || !this.isItemEqual(item.getMCItemStack(), is)) continue;
            i += is.func_190916_E();
        }
        return i;
    }

    private boolean isItemEqual(ItemStack stack, ItemStack other) {
        if (other.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (stack.func_77952_i() < 0) {
            return true;
        }
        return stack.func_77952_i() == other.func_77952_i();
    }

    @Override
    public int inventoryItemCount(String id, int damage) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.inventoryItemCount(NpcAPI.Instance().getIItemStack(new ItemStack(item, 1, damage)));
    }

    @Override
    public IItemStack[] getInventory() {
        IItemStack[] items = new IItemStack[((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.size()];
        for (int i = 0; i < ((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.size(); ++i) {
            items[i] = NpcAPI.Instance().getIItemStack((ItemStack)((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.get(i));
        }
        return items;
    }

    @Override
    public boolean removeItem(IItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < ((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.size(); ++i) {
                ItemStack is = (ItemStack)((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.get(i);
                if (is == null || !this.isItemEqual(item.getMCItemStack(), is)) continue;
                if (amount >= is.func_190916_E()) {
                    ((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                    amount -= is.func_190916_E();
                    continue;
                }
                is.func_77979_a(amount);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean removeItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.removeItem(NpcAPI.Instance().getIItemStack(new ItemStack(item, 1, damage)), amount);
    }

    @Override
    public boolean giveItem(IItemStack item) {
        ItemStack mcItem = item.getMCItemStack();
        if (mcItem.func_190926_b()) {
            return false;
        }
        boolean bo = ((EntityPlayerMP)this.entity).field_71071_by.func_70441_a(mcItem.func_77946_l());
        if (bo) {
            NoppesUtilServer.playSound((EntityLivingBase)this.entity, SoundEvents.field_187638_cR, 0.2f, ((((EntityPlayerMP)this.entity).func_70681_au().nextFloat() - ((EntityPlayerMP)this.entity).func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ((EntityPlayerMP)this.entity).field_71069_bz.func_75142_b();
        }
        return bo;
    }

    @Override
    public boolean giveItem(String id, int damage, int amount) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
        if (item == null) {
            return false;
        }
        ItemStack mcStack = new ItemStack(item);
        IItemStack itemStack = NpcAPI.Instance().getIItemStack(mcStack);
        itemStack.setStackSize(amount);
        itemStack.setItemDamage(damage);
        return this.giveItem(itemStack);
    }

    @Override
    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        ((EntityPlayerMP)this.entity).func_180473_a(new BlockPos(x, y, z), true);
    }

    @Override
    public void resetSpawnpoint() {
        ((EntityPlayerMP)this.entity).func_180473_a(null, false);
    }

    @Override
    public void removeAllItems(IItemStack item) {
        for (int i = 0; i < ((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack is = (ItemStack)((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.get(i);
            if (is == null || !is.func_77969_a(item.getMCItemStack())) continue;
            ((EntityPlayerMP)this.entity).field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean hasAchievement(String achievement) {
        StatBase statbase = StatList.func_151177_a((String)achievement);
        if (statbase == null || !(statbase instanceof Achievement)) {
            return false;
        }
        return ((EntityPlayerMP)this.entity).func_147099_x().func_77443_a((Achievement)statbase);
    }

    @Override
    public int getExpLevel() {
        return ((EntityPlayerMP)this.entity).field_71068_ca;
    }

    @Override
    public void setExpLevel(int level) {
        ((EntityPlayerMP)this.entity).field_71068_ca = level;
        ((EntityPlayerMP)this.entity).func_82242_a(0);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        NoppesUtilPlayer.teleportPlayer((EntityPlayerMP)this.entity, new BlockPos(x, y, z), ((EntityPlayerMP)this.entity).field_71093_bK);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 ? true : super.typeOf(type);
    }

    @Override
    public boolean hasPermission(String permission) {
        return CustomNpcsPermissions.hasPermissionString((EntityPlayerMP)this.entity, permission);
    }

    @Override
    public IPixelmonPlayerData getPixelmonData() {
        return new IPixelmonPlayerData(){

            @Override
            public IPixelmon getPartySlot(int slot) {
                NBTTagCompound compound = PixelmonHelper.getPartySlot(slot, (EntityPlayer)PlayerWrapper.this.entity);
                if (compound == null) {
                    return null;
                }
                EntityTameable pixelmon = PixelmonHelper.pixelmonFromNBT(compound, (EntityPlayer)PlayerWrapper.this.entity);
                return new PixelmonWrapper<EntityTameable>(pixelmon, compound);
            }

            @Override
            public int countPCPixelmon() {
                return PixelmonHelper.countPCPixelmon((EntityPlayerMP)PlayerWrapper.this.entity);
            }
        };
    }

    private PlayerData getData() {
        if (this.data == null) {
            this.data = PlayerData.get((EntityPlayer)this.entity);
        }
        return this.data;
    }

    @Override
    public ITimers getTimers() {
        return this.getData().timers;
    }

    @Override
    public void removeDialog(int id) {
        this.getData().dialogData.dialogsRead.remove(id);
    }

    @Override
    public void addDialog(int id) {
        this.getData().dialogData.dialogsRead.add(id);
    }

    @Override
    public void closeGui() {
        Server.sendData((EntityPlayerMP)this.entity, EnumPacketClient.GUI_CLOSE, -1, new NBTTagCompound());
    }
}

