/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.block.NpcBlockHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.INBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import nikedemos.markovnames.generators.MarkovAncientGreek;
import nikedemos.markovnames.generators.MarkovAztec;
import nikedemos.markovnames.generators.MarkovCustomNPCsClassic;
import nikedemos.markovnames.generators.MarkovGenerator;
import nikedemos.markovnames.generators.MarkovJapanese;
import nikedemos.markovnames.generators.MarkovOldNorse;
import nikedemos.markovnames.generators.MarkovRoman;
import nikedemos.markovnames.generators.MarkovSaami;
import nikedemos.markovnames.generators.MarkovSlavic;
import nikedemos.markovnames.generators.MarkovSpanish;
import nikedemos.markovnames.generators.MarkovWelsh;
import noppes.npcs.AbilityEventHandler;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.LogWriter;
import noppes.npcs.ScriptItemEventHandler;
import noppes.npcs.ScriptPlayerEventHandler;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.ServerTickHandler;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.api.wrapper.WrapperNpcAPI;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.command.CmdNoppes;
import noppes.npcs.command.CmdSchematics;
import noppes.npcs.config.ConfigLoader;
import noppes.npcs.config.ConfigProp;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.GlobalDataController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.packets.Packets;

@Mod(value="customnpcs")
public class CustomNpcs {
    public static final String MODID = "customnpcs";
    public static final String VERSION = "1.13";
    @ConfigProp(info="Whether scripting is enabled or not")
    public static boolean EnableScripting = true;
    @ConfigProp(info="Arguments given to the Nashorn scripting library")
    public static String NashorArguments = "-strict";
    @ConfigProp(info="Disable Chat Bubbles")
    public static boolean EnableChatBubbles = true;
    @ConfigProp(info="Navigation search range for NPCs. Not recommended to increase if you have a slow pc or on a server")
    public static int NpcNavRange = 32;
    @ConfigProp(info="Set to true if you want the dialog command option to be able to use op commands like tp etc")
    public static boolean NpcUseOpCommands = false;
    @ConfigProp
    public static boolean InventoryGuiEnabled = true;
    public static boolean FixUpdateFromPre_1_12 = false;
    @ConfigProp(info="If you are running sponge and you want to disable the permissions set this to true")
    public static boolean DisablePermissions = false;
    @ConfigProp
    public static boolean SceneButtonsEnabled = true;
    @ConfigProp
    public static boolean EnableDefaultEyes = true;
    public static long ticks;
    public static CommonProxy proxy;
    @ConfigProp(info="Enables CustomNpcs startup update message")
    public static boolean EnableUpdateChecker;
    public static CustomNpcs instance;
    public static boolean FreezeNPCs;
    @ConfigProp(info="Only ops can create and edit npcs")
    public static boolean OpsOnly;
    @ConfigProp(info="Default interact line. Leave empty to not have one")
    public static String DefaultInteractLine;
    @ConfigProp(info="Number of chunk loading npcs that can be active at the same time")
    public static int ChuckLoaders;
    public static File Dir;
    @ConfigProp(info="Enables leaves decay")
    public static boolean LeavesDecayEnabled;
    @ConfigProp(info="Enables Vine Growth")
    public static boolean VineGrowthEnabled;
    @ConfigProp(info="Enables Ice Melting")
    public static boolean IceMeltsEnabled;
    @ConfigProp(info="Normal players can use soulstone on animals")
    public static boolean SoulStoneAnimals;
    @ConfigProp(info="Normal players can use soulstone on all npcs")
    public static boolean SoulStoneNPCs;
    @ConfigProp(info="Type 0 = Normal, Type 1 = Solid")
    public static int HeadWearType;
    @ConfigProp(info="When set to Minecraft it will use minecrafts font, when Default it will use OpenSans. Can only use fonts installed on your PC")
    public static String FontType;
    @ConfigProp(info="Font size for custom fonts (doesn't work with minecrafts font)")
    public static int FontSize;
    @ConfigProp
    public static boolean NpcSpeachTriggersChatEvent;
    public static ConfigLoader Config;
    public static boolean VerboseDebug;
    public static MinecraftServer Server;
    public static final MarkovGenerator[] MARKOV_GENERATOR;

    public CustomNpcs() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::postLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        Packets.register();
    }

    private void postLoad(FMLLoadCompleteEvent event) {
        proxy.postload();
        CustomItems.registerDispenser();
        CustomNpcs.MARKOV_GENERATOR[0] = new MarkovRoman(3);
        CustomNpcs.MARKOV_GENERATOR[1] = new MarkovJapanese(4);
        CustomNpcs.MARKOV_GENERATOR[2] = new MarkovSlavic(3);
        CustomNpcs.MARKOV_GENERATOR[3] = new MarkovWelsh(3);
        CustomNpcs.MARKOV_GENERATOR[4] = new MarkovSaami(3);
        CustomNpcs.MARKOV_GENERATOR[5] = new MarkovOldNorse(4);
        CustomNpcs.MARKOV_GENERATOR[6] = new MarkovAncientGreek(3);
        CustomNpcs.MARKOV_GENERATOR[7] = new MarkovAztec(3);
        CustomNpcs.MARKOV_GENERATOR[8] = new MarkovCustomNPCsClassic(3);
        CustomNpcs.MARKOV_GENERATOR[9] = new MarkovSpanish(3);
    }

    private void setup(FMLCommonSetupEvent event) {
        File dir = new File(FMLPaths.CONFIGDIR.get().toFile(), "..");
        Dir = new File(dir, MODID);
        Dir.mkdir();
        Config = new ConfigLoader(this.getClass(), new File(dir, "config"), "CustomNpcs");
        Config.loadConfig();
        if (NpcNavRange < 16) {
            NpcNavRange = 16;
        }
        CapabilityManager.INSTANCE.register(PlayerData.class, new Capability.IStorage(){

            public INBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, INBTBase nbt) {
            }
        }, PlayerData::new);
        CapabilityManager.INSTANCE.register(WrapperEntityData.class, new Capability.IStorage(){

            public INBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, INBTBase nbt) {
            }
        }, () -> null);
        CapabilityManager.INSTANCE.register(MarkData.class, new Capability.IStorage(){

            public INBTBase writeNBT(Capability capability, Object instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, Object instance, EnumFacing side, INBTBase nbt) {
            }
        }, MarkData::new);
        CapabilityManager.INSTANCE.register(ItemStackWrapper.class, (Capability.IStorage)new Capability.IStorage<ItemStackWrapper>(){

            public INBTBase writeNBT(Capability capability, ItemStackWrapper instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, ItemStackWrapper instance, EnumFacing side, INBTBase nbt) {
            }
        }, () -> null);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventsHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ServerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CustomEntities());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NpcAPI.Instance().events().register((Object)new AbilityEventHandler());
        proxy.load();
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)SharedMonsterAttributes.field_111267_a), (Object)Double.MAX_VALUE, (int)1);
        PixelmonHelper.load();
        ScriptController controller = new ScriptController();
        if (EnableScripting && controller.languages.size() > 0) {
            MinecraftForge.EVENT_BUS.register((Object)controller);
            MinecraftForge.EVENT_BUS.register((Object)new ScriptPlayerEventHandler().registerForgeEvents());
            MinecraftForge.EVENT_BUS.register((Object)new ScriptItemEventHandler());
        }
        new RecipeController();
        new CustomNpcsPermissions();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, () -> ClientProxy::openGui);
    }

    @SubscribeEvent
    public void setAboutToStart(FMLServerAboutToStartEvent event) {
        Availability.scoreboardValues.clear();
        Server = event.getServer();
        FactionController.instance.load();
        new PlayerDataController();
        new TransportController();
        new GlobalDataController();
        new SpawnController();
        new LinkedNpcController();
        new MassBlockController();
        ScriptController.Instance.loadCategories();
        ScriptController.Instance.loadStoredData();
        ScriptController.Instance.loadPlayerScripts();
        ScriptController.Instance.loadForgeScripts();
        ScriptController.HasStart = false;
        WrapperNpcAPI.clearCache();
        Set names = IRegistry.field_212618_g.func_148742_b();
        for (ResourceLocation name : names) {
            Block block = (Block)IRegistry.field_212618_g.func_212608_b(name);
            if (block instanceof BlockLeaves) {
                NpcBlockHelper.setTickEnabled(block, LeavesDecayEnabled);
            }
            if (block instanceof BlockVine) {
                NpcBlockHelper.setTickEnabled(block, VineGrowthEnabled);
            }
            if (!(block instanceof BlockIce)) continue;
            NpcBlockHelper.setTickEnabled(block, IceMeltsEnabled);
        }
        CmdSchematics.names.clear();
        CmdSchematics.names.addAll(SchematicController.Instance.list());
    }

    @SubscribeEvent
    public void started(FMLServerStartedEvent event) {
        RecipeController.instance.load();
        new BankController();
        DialogController.instance.load();
        QuestController.instance.load();
        ScriptController.HasStart = true;
        ServerCloneController.Instance = new ServerCloneController();
    }

    @SubscribeEvent
    public void stopped(FMLServerStoppedEvent event) {
        ServerCloneController.Instance = null;
        Server = null;
        ItemScripted.Resources.clear();
    }

    @SubscribeEvent
    public void serverstart(FMLServerStartingEvent event) {
        EntityNPCInterface.ChatEventPlayer = new FakePlayer(event.getServer().func_71218_a(DimensionType.OVERWORLD), (GameProfile)EntityNPCInterface.ChatEventProfile);
        EntityNPCInterface.CommandPlayer = new FakePlayer(event.getServer().func_71218_a(DimensionType.OVERWORLD), (GameProfile)EntityNPCInterface.CommandProfile);
        EntityNPCInterface.GenericPlayer = new FakePlayer(event.getServer().func_71218_a(DimensionType.OVERWORLD), (GameProfile)EntityNPCInterface.GenericProfile);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent e) {
        LiteralArgumentBuilder command = Commands.func_197057_a((String)"noppes");
        CmdNoppes.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
        e.getCommandDispatcher().register(command);
    }

    public static File getWorldSaveDirectory() {
        return CustomNpcs.getWorldSaveDirectory(null);
    }

    public static File getWorldSaveDirectory(String s) {
        try {
            File dir = new File(".");
            if (Server != null) {
                if (!Server.func_71262_S()) {
                    dir = new File(Minecraft.func_71410_x().field_71412_D, "saves");
                }
                dir = new File(new File(dir, Server.func_71270_I()), MODID);
            }
            if (s != null) {
                dir = new File(dir, s);
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
        catch (Exception e) {
            LogWriter.error("Error getting worldsave", e);
            return null;
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        EnableUpdateChecker = true;
        FreezeNPCs = false;
        OpsOnly = false;
        DefaultInteractLine = "Hello @p";
        ChuckLoaders = 20;
        LeavesDecayEnabled = true;
        VineGrowthEnabled = true;
        IceMeltsEnabled = true;
        SoulStoneAnimals = true;
        SoulStoneNPCs = false;
        HeadWearType = 1;
        FontType = "Default";
        FontSize = 18;
        NpcSpeachTriggersChatEvent = false;
        VerboseDebug = false;
        MARKOV_GENERATOR = new MarkovGenerator[10];
    }
}

