/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import noppes.npcs.ModelEyeData;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;
import noppes.npcs.constants.EnumParts;

public class ModelDataShared {
    protected ModelPartConfig arm1 = new ModelPartConfig();
    protected ModelPartConfig arm2 = new ModelPartConfig();
    protected ModelPartConfig body = new ModelPartConfig();
    protected ModelPartConfig leg1 = new ModelPartConfig();
    protected ModelPartConfig leg2 = new ModelPartConfig();
    protected ModelPartConfig head = new ModelPartConfig();
    protected ModelPartData legParts = new ModelPartData("legs");
    public ModelEyeData eyes = new ModelEyeData();
    public Class<? extends EntityLivingBase> entityClass;
    protected EntityLivingBase entity;
    public NBTTagCompound extra = new NBTTagCompound();
    protected HashMap<EnumParts, ModelPartData> parts = new HashMap();

    public NBTTagCompound write() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.entityClass != null) {
            compound.func_74778_a("EntityClass", this.entityClass.getCanonicalName());
        }
        compound.func_74782_a("ArmsConfig", (INBTBase)this.arm1.write());
        compound.func_74782_a("BodyConfig", (INBTBase)this.body.write());
        compound.func_74782_a("LegsConfig", (INBTBase)this.leg1.write());
        compound.func_74782_a("HeadConfig", (INBTBase)this.head.write());
        compound.func_74782_a("LegParts", (INBTBase)this.legParts.write());
        compound.func_74782_a("Eyes", (INBTBase)this.eyes.write());
        compound.func_74782_a("ExtraData", (INBTBase)this.extra);
        NBTTagList list = new NBTTagList();
        for (EnumParts e : this.parts.keySet()) {
            NBTTagCompound item = this.parts.get((Object)e).write();
            item.func_74778_a("PartName", e.name);
            list.add((INBTBase)item);
        }
        compound.func_74782_a("Parts", (INBTBase)list);
        return compound;
    }

    public void read(NBTTagCompound compound) {
        this.setEntityName(compound.func_74779_i("EntityClass"));
        this.arm1.read(compound.func_74775_l("ArmsConfig"));
        this.body.read(compound.func_74775_l("BodyConfig"));
        this.leg1.read(compound.func_74775_l("LegsConfig"));
        this.head.read(compound.func_74775_l("HeadConfig"));
        this.legParts.read(compound.func_74775_l("LegParts"));
        this.eyes.read(compound.func_74775_l("Eyes"));
        this.extra = compound.func_74775_l("ExtraData");
        HashMap<EnumParts, ModelPartData> parts = new HashMap<EnumParts, ModelPartData>();
        NBTTagList list = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < list.size(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            String name = item.func_74779_i("PartName");
            ModelPartData part = new ModelPartData(name);
            part.read(item);
            EnumParts e = EnumParts.FromName(name);
            if (e == null) continue;
            parts.put(e, part);
        }
        this.parts = parts;
        this.updateTransate();
    }

    private void updateTransate() {
        for (EnumParts part : EnumParts.values()) {
            float y;
            float x;
            ModelPartConfig body;
            ModelPartConfig config = this.getPartConfig(part);
            if (config == null) continue;
            if (part == EnumParts.HEAD) {
                config.setTranslate(0.0f, this.getBodyY(), 0.0f);
                continue;
            }
            if (part == EnumParts.ARM_LEFT) {
                body = this.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scaleX) * 0.25f + (1.0f - config.scaleX) * 0.075f;
                y = this.getBodyY() + (1.0f - config.scaleY) * -0.1f;
                config.setTranslate(-x, y, 0.0f);
                if (config.notShared) continue;
                ModelPartConfig arm = this.getPartConfig(EnumParts.ARM_RIGHT);
                arm.copyValues(config);
                continue;
            }
            if (part == EnumParts.ARM_RIGHT) {
                body = this.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scaleX) * 0.25f + (1.0f - config.scaleX) * 0.075f;
                y = this.getBodyY() + (1.0f - config.scaleY) * -0.1f;
                config.setTranslate(x, y, 0.0f);
                continue;
            }
            if (part == EnumParts.LEG_LEFT) {
                config.setTranslate(config.scaleX * 0.125f - 0.113f, this.getLegsY(), 0.0f);
                if (config.notShared) continue;
                ModelPartConfig leg = this.getPartConfig(EnumParts.LEG_RIGHT);
                leg.copyValues(config);
                continue;
            }
            if (part == EnumParts.LEG_RIGHT) {
                config.setTranslate((1.0f - config.scaleX) * 0.125f, this.getLegsY(), 0.0f);
                continue;
            }
            if (part != EnumParts.BODY) continue;
            config.setTranslate(0.0f, this.getBodyY(), 0.0f);
        }
    }

    public void setEntityName(String string) {
        this.entityClass = null;
        this.entity = null;
        for (ResourceLocation resource : IRegistry.field_212629_r.func_148742_b()) {
            EntityType ent = (EntityType)IRegistry.field_212629_r.func_212608_b(resource);
            Class c = ent.func_201760_c();
            if (!c.getCanonicalName().equals(string) || !EntityLivingBase.class.isAssignableFrom(c)) continue;
            this.entityClass = c.asSubclass(EntityLivingBase.class);
            break;
        }
    }

    public void setEntityClass(Class<? extends EntityLivingBase> entityClass) {
        this.entityClass = entityClass;
        this.entity = null;
        this.extra = new NBTTagCompound();
    }

    public Class<? extends EntityLivingBase> getEntityClass() {
        return this.entityClass;
    }

    public float offsetY() {
        if (this.entity == null) {
            return -this.getBodyY();
        }
        return this.entity.field_70131_O - 1.8f;
    }

    public void clearEntity() {
        this.entity = null;
    }

    public ModelPartData getPartData(EnumParts type) {
        if (type == EnumParts.LEGS) {
            return this.legParts;
        }
        if (type == EnumParts.EYES) {
            return this.eyes;
        }
        return this.parts.get((Object)type);
    }

    public ModelPartConfig getPartConfig(EnumParts type) {
        if (type == EnumParts.BODY) {
            return this.body;
        }
        if (type == EnumParts.ARM_LEFT) {
            return this.arm1;
        }
        if (type == EnumParts.ARM_RIGHT) {
            return this.arm2;
        }
        if (type == EnumParts.LEG_LEFT) {
            return this.leg1;
        }
        if (type == EnumParts.LEG_RIGHT) {
            return this.leg2;
        }
        return this.head;
    }

    public void removePart(EnumParts type) {
        this.parts.remove((Object)type);
    }

    public ModelPartData getOrCreatePart(EnumParts type) {
        if (type == null) {
            return null;
        }
        if (type == EnumParts.EYES) {
            return this.eyes;
        }
        ModelPartData part = this.getPartData(type);
        if (part == null) {
            part = new ModelPartData(type.name);
            this.parts.put(type, part);
        }
        return part;
    }

    public float getBodyY() {
        return (1.0f - this.body.scaleY) * 0.75f + this.getLegsY();
    }

    public float getLegsY() {
        ModelPartConfig legs = this.leg1;
        if (this.leg2.notShared && this.leg2.scaleY > this.leg1.scaleY) {
            legs = this.leg2;
        }
        return (1.0f - legs.scaleY) * 0.75f;
    }
}

