/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.NetworkHooks;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketDialog;
import noppes.npcs.packets.client.PacketDialogDummy;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.packets.client.PacketGuiError;
import noppes.npcs.packets.client.PacketGuiScrollData;
import noppes.npcs.packets.client.PacketNpcEdit;
import noppes.npcs.packets.client.PacketParticle;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class NoppesUtilServer {
    private static HashMap<UUID, Quest> editingQuests = new HashMap();
    private static HashMap<UUID, Quest> editingQuestsClient = new HashMap();

    public static void setEditingNpc(EntityPlayer player, EntityNPCInterface npc) {
        PlayerData data = PlayerData.get(player);
        data.editingNpc = npc;
        if (npc != null) {
            Packets.send((EntityPlayerMP)player, new PacketNpcEdit(npc.func_145782_y()));
        }
    }

    public static EntityNPCInterface getEditingNpc(EntityPlayer player) {
        PlayerData data = PlayerData.get(player);
        return data.editingNpc;
    }

    public static void setEditingQuest(EntityPlayer player, Quest quest) {
        if (player.field_70170_p.field_72995_K) {
            editingQuestsClient.put(player.func_110124_au(), quest);
        } else {
            editingQuests.put(player.func_110124_au(), quest);
        }
    }

    public static Quest getEditingQuest(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return editingQuestsClient.get(player.func_110124_au());
        }
        return editingQuests.get(player.func_110124_au());
    }

    public static void openDialog(EntityPlayer player, EntityNPCInterface npc, Dialog dia) {
        Dialog dialog = dia.copy(player);
        PlayerData playerdata = PlayerData.get(player);
        if (EventHooks.onNPCDialog(npc, player, dialog)) {
            playerdata.dialogId = -1;
            return;
        }
        playerdata.dialogId = dialog.id;
        if (npc instanceof EntityDialogNpc || dia.id < 0) {
            dialog.hideNPC = true;
            Packets.send((EntityPlayerMP)player, new PacketDialogDummy(npc.func_200200_C_().func_150261_e(), dialog.write(new NBTTagCompound())));
        } else {
            Packets.send((EntityPlayerMP)player, new PacketDialog(npc.func_145782_y(), dialog.id));
        }
        dia.factionOptions.addPoints(player);
        if (dialog.hasQuest()) {
            PlayerQuestController.addActiveQuest(dialog.getQuest(), player);
        }
        if (!dialog.command.isEmpty()) {
            NoppesUtilServer.runCommand((Entity)npc, npc.func_200200_C_().func_150261_e(), dialog.command, player);
        }
        if (dialog.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.func_184102_h(), player.func_200200_C_().func_150261_e(), dialog.mail);
        }
        PlayerDialogData data = playerdata.dialogData;
        if (!data.dialogsRead.contains(dialog.id) && dialog.id >= 0) {
            data.dialogsRead.add(dialog.id);
            playerdata.updateClient = true;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
    }

    public static String runCommand(Entity executer, String name, String command, EntityPlayer player) {
        return NoppesUtilServer.runCommand(executer.func_130014_f_(), executer.func_180425_c(), name, command, player, executer);
    }

    public static String runCommand(final World world, BlockPos pos, String name, String command, EntityPlayer player, Entity executer) {
        if (!world.func_73046_m().func_82356_Z()) {
            LogWriter.warn("Cant run commands if CommandBlocks are disabled");
            return "Cant run commands if CommandBlocks are disabled";
        }
        if (player != null) {
            command = command.replace("@dp", player.func_200200_C_().func_150254_d());
        }
        command = command.replace("@npc", name);
        final TextComponentString output = new TextComponentString("");
        RConConsoleSource icommandsender = new RConConsoleSource(world.func_73046_m()){

            public void func_145747_a(ITextComponent component) {
                output.func_150257_a(component);
            }

            public boolean func_195041_r_() {
                WorldServer lvt_1_1_ = world.func_73046_m().func_71218_a(DimensionType.OVERWORLD);
                return lvt_1_1_.func_82736_K().func_82766_b("commandBlockOutput");
            }
        };
        int permLvl = CustomNpcs.NpcUseOpCommands ? 4 : 2;
        Vec3d point = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        CommandSource commandSource = new CommandSource((ICommandSource)icommandsender, point, Vec2f.field_189974_a, (WorldServer)world, permLvl, "@CustomNPCs-" + name, (ITextComponent)new TextComponentString("@CustomNPCs-" + name), world.func_73046_m(), executer){};
        Commands icommandmanager = world.func_73046_m().func_195571_aL();
        icommandmanager.func_197059_a(commandSource, command);
        if (output.func_150261_e().isEmpty()) {
            return null;
        }
        return output.func_150261_e();
    }

    public static void consumeItemStack(int i, EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (player.field_71075_bZ.field_75098_d || item == null || item.func_190926_b()) {
            return;
        }
        item.func_190918_g(1);
        if (item.func_190916_E() <= 0) {
            player.func_184611_a(EnumHand.MAIN_HAND, null);
        }
    }

    public static DataOutputStream getDataOutputStream(ByteArrayOutputStream stream) throws IOException {
        return new DataOutputStream(new GZIPOutputStream(stream));
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        SPacketGuiOpen.sendOpenGui(player, gui, npc, BlockPos.field_177992_a);
    }

    public static boolean openContainerGui(EntityPlayerMP player, EnumGuiType gui, EntityNPCInterface npc, BlockPos pos) {
        return NoppesUtilServer.openContainerGui(player, gui, npc, (PacketBuffer buf) -> buf.func_179255_a(pos));
    }

    public static boolean openContainerGui(EntityPlayerMP player, final EnumGuiType gui, EntityNPCInterface npc, Consumer<PacketBuffer> extraDataWriter) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        extraDataWriter.accept(buffer);
        final Container container = CustomNpcs.proxy.getContainer(gui, (EntityPlayer)player, npc, buffer);
        if (container == null) {
            return false;
        }
        NetworkHooks.openGui((EntityPlayerMP)player, (IInteractionObject)new IInteractionObject(){

            public Container func_174876_a(InventoryPlayer inventoryPlayer, EntityPlayer entityPlayer) {
                return container;
            }

            public String func_174875_k() {
                return gui.resource.toString();
            }

            public ITextComponent func_200200_C_() {
                return new TextComponentString(gui.name());
            }

            public boolean func_145818_k_() {
                return false;
            }

            @Nullable
            public ITextComponent func_200201_e() {
                return null;
            }
        }, extraDataWriter);
        return true;
    }

    public static void spawnParticle(Entity entity, String particle, int dimension) {
        Packets.sendNearby(entity, new PacketParticle(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70131_O, entity.field_70130_N, particle));
    }

    public static void sendScrollData(EntityPlayerMP player, Map<String, Integer> map) {
        Packets.send(player, new PacketGuiScrollData(map));
    }

    public static void sendGuiError(EntityPlayer player, int i) {
        Packets.send((EntityPlayerMP)player, new PacketGuiError(i, new NBTTagCompound()));
    }

    public static void sendGuiClose(EntityPlayerMP player, int i, NBTTagCompound comp) {
        Packets.send(player, new PacketGuiClose(comp));
    }

    public static boolean isOp(EntityPlayer player) {
        return player.func_184102_h().func_184103_al().func_152596_g(player.func_146103_bH());
    }

    public static void GivePlayerItem(Entity entity, EntityPlayer player, ItemStack item) {
        if (entity.field_70170_p.field_72995_K || item == null || item.func_190926_b()) {
            return;
        }
        item = item.func_77946_l();
        float f = 0.7f;
        double d = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d1 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        double d2 = (double)(entity.field_70170_p.field_73012_v.nextFloat() * f) + (double)(1.0f - f);
        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t + d, entity.field_70163_u + d1, entity.field_70161_v + d2, item);
        entityitem.func_174867_a(2);
        entity.field_70170_p.func_72838_d((Entity)entityitem);
        int i = item.func_190916_E();
        if (player.field_71071_by.func_70441_a(item)) {
            entity.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)entityitem, i);
            PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
            playerdata.checkQuestCompletion(player, 0);
            if (item.func_190916_E() <= 0) {
                entityitem.func_70106_y();
            }
        }
    }

    public static BlockPos GetClosePos(BlockPos origin, World world) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 2; y >= -2; --y) {
                    BlockPos pos = origin.func_177982_a(x, y, z);
                    IBlockState state = world.func_180495_p(pos.func_177984_a());
                    if (!state.func_185915_l() || !world.func_175623_d(pos.func_177984_a()) || !world.func_175623_d(pos.func_177981_b(2))) continue;
                    return pos.func_177984_a();
                }
            }
        }
        return world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, origin);
    }

    public static void NotifyOPs(String message, Object ... obs) {
        TextComponentTranslation chatcomponenttranslation = new TextComponentTranslation(message, obs);
        chatcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.GRAY);
        chatcomponenttranslation.func_150256_b().func_150217_b(Boolean.valueOf(true));
        for (EntityPlayer entityplayer : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            if (!entityplayer.func_195039_a() || !NoppesUtilServer.isOp(entityplayer)) continue;
            entityplayer.func_145747_a((ITextComponent)chatcomponenttranslation);
        }
        if (CustomNpcs.Server.func_71218_a(DimensionType.OVERWORLD).func_82736_K().func_82766_b("logAdminCommands")) {
            LogWriter.info(chatcomponenttranslation.func_150261_e());
        }
    }

    public static void playSound(EntityLivingBase entity, SoundEvent sound, float volume, float pitch) {
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch);
    }

    public static void playSound(World world, BlockPos pos, SoundEvent sound, SoundCategory cat, float volume, float pitch) {
        world.func_184133_a(null, pos, sound, cat, volume, pitch);
    }

    public static EntityPlayer getPlayer(MinecraftServer minecraftserver, UUID id) {
        List list = minecraftserver.func_184103_al().func_181057_v();
        for (EntityPlayer player : list) {
            if (!id.equals(player.func_110124_au())) continue;
            return player;
        }
        return null;
    }

    public static Entity GetDamageSourcee(DamageSource damagesource) {
        Entity entity = damagesource.func_76346_g();
        if (entity == null) {
            entity = damagesource.func_76364_f();
        }
        if (entity instanceof EntityArrow && ((EntityArrow)entity).func_212360_k() instanceof EntityLivingBase) {
            entity = ((EntityArrow)entity).func_212360_k();
        } else if (entity instanceof EntityThrowable) {
            entity = ((EntityThrowable)entity).func_85052_h();
        }
        return entity;
    }

    public static boolean IsItemStackNull(ItemStack is) {
        return is == null || is.func_190926_b() || is == ItemStack.field_190927_a || is.func_77973_b() == null;
    }

    public static ItemStack ChangeItemStack(ItemStack is, Item item) {
        NBTTagCompound comp = is.func_77955_b(new NBTTagCompound());
        ResourceLocation resourcelocation = IRegistry.field_212630_s.func_177774_c((Object)item);
        comp.func_74778_a("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        return ItemStack.func_199557_a((NBTTagCompound)comp);
    }
}

