/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiCloneOpen;
import noppes.npcs.packets.client.PacketGuiOpen;
import noppes.npcs.packets.client.PacketMarkData;
import noppes.npcs.packets.client.PacketMerchantList;
import noppes.npcs.quests.QuestKill;

public class ServerEventsHandler {
    public static EntityVillager Merchant;

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.EntityInteract event) {
        ItemStack item = event.getEntityPlayer().func_184614_ca();
        if (item == null) {
            return;
        }
        boolean isRemote = event.getEntityPlayer().field_70170_p.field_72995_K;
        boolean npcInteracted = event.getTarget() instanceof EntityNPCInterface;
        if (!isRemote && CustomNpcs.OpsOnly && !event.getEntityPlayer().func_184102_h().func_184103_al().func_152596_g(event.getEntityPlayer().func_146103_bH())) {
            return;
        }
        if (!isRemote && item.func_77973_b() == CustomItems.soulstoneEmpty && event.getTarget() instanceof EntityLivingBase) {
            ((ItemSoulstoneEmpty)item.func_77973_b()).store((EntityLivingBase)event.getTarget(), item, event.getEntityPlayer());
        }
        if (item.func_77973_b() == CustomItems.wand && npcInteracted && !isRemote) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.getEntityPlayer(), EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.getTarget());
        } else if (item.func_77973_b() == CustomItems.cloner && !isRemote && !(event.getTarget() instanceof EntityPlayer)) {
            NBTTagCompound compound = new NBTTagCompound();
            if (!event.getTarget().func_184198_c(compound)) {
                return;
            }
            PlayerData data = PlayerData.get(event.getEntityPlayer());
            ServerCloneController.Instance.cleanTags(compound);
            Packets.send((EntityPlayerMP)event.getEntityPlayer(), new PacketGuiCloneOpen(compound));
            data.cloned = compound;
            event.setCanceled(true);
        } else if (item.func_77973_b() == CustomItems.scripter && !isRemote && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            NoppesUtilServer.setEditingNpc(event.getEntityPlayer(), (EntityNPCInterface)event.getTarget());
            event.setCanceled(true);
            Packets.send((EntityPlayerMP)event.getEntityPlayer(), new PacketGuiOpen(EnumGuiType.Script, BlockPos.field_177992_a));
        } else if (item.func_77973_b() == CustomItems.mount) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.TOOL_MOUNTER)) {
                return;
            }
            PlayerData data = PlayerData.get(event.getEntityPlayer());
            event.setCanceled(true);
            data.mounted = event.getTarget();
            if (isRemote) {
                CustomNpcs.proxy.openGui(event.getEntityPlayer(), EnumGuiType.MobSpawnerMounter);
            }
        } else if (item.func_77973_b() == CustomItems.wand && event.getTarget() instanceof EntityVillager) {
            if (!CustomNpcsPermissions.hasPermission(event.getEntityPlayer(), CustomNpcsPermissions.EDIT_VILLAGER)) {
                return;
            }
            event.setCanceled(true);
            Merchant = (EntityVillager)event.getTarget();
            if (!isRemote) {
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                NoppesUtilServer.openContainerGui(player, EnumGuiType.MerchantAdd, null, BlockPos.field_177992_a);
                MerchantRecipeList merchantrecipelist = Merchant.func_70934_b((EntityPlayer)player);
                if (merchantrecipelist != null) {
                    Packets.send(player, new PacketMerchantList(merchantrecipelist));
                }
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (source != null) {
            if (source instanceof EntityNPCInterface && event.getEntityLiving() != null) {
                EntityNPCInterface npc = (EntityNPCInterface)source;
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(Line.formatTarget(line, event.getEntityLiving()));
                }
                EventHooks.onNPCKills(npc, event.getEntityLiving());
            }
            EntityPlayer player = null;
            if (source instanceof EntityPlayer) {
                player = (EntityPlayer)source;
            } else if (source instanceof EntityNPCInterface && ((EntityNPCInterface)source).getOwner() instanceof EntityPlayer) {
                player = (EntityPlayer)((EntityNPCInterface)source).getOwner();
            }
            if (player != null) {
                this.doQuest(player, event.getEntityLiving(), true);
                if (event.getEntityLiving() instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)event.getEntityLiving());
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            PlayerData data = PlayerData.get((EntityPlayer)event.getEntityLiving());
            data.save(false);
        }
    }

    private void doFactionPoints(EntityPlayer player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(EntityPlayer player, EntityLivingBase entity, boolean all) {
        PlayerData pdata = PlayerData.get(player);
        PlayerQuestData playerdata = pdata.questData;
        String entityName = entity.func_70022_Q();
        if (entity instanceof EntityPlayer) {
            entityName = "Player";
        }
        for (QuestData data : playerdata.activeQuests.values()) {
            if (data.quest.type != 2 && data.quest.type != 4) continue;
            if (data.quest.type == 4 && all) {
                List list = player.field_70170_p.func_72872_a(EntityPlayer.class, entity.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0));
                for (EntityPlayer pl : list) {
                    if (pl == player) continue;
                    this.doQuest(pl, entity, false);
                }
            }
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            if (quest.targets.containsKey(entity.func_200200_C_())) {
                name = entity.func_200200_C_().func_150261_e();
            } else if (!quest.targets.containsKey(name)) continue;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (killed.containsKey(name) && killed.get(name) >= quest.targets.get(name)) continue;
            int amount = 0;
            if (killed.containsKey(name)) {
                amount = killed.get(name);
            }
            killed.put(name, amount + 1);
            quest.setKilled(data, killed);
            pdata.updateClient = true;
        }
        playerdata.checkQuestCompletion(player, 2);
        playerdata.checkQuestCompletion(player, 4);
    }

    @SubscribeEvent
    public void pickUp(EntityItemPickupEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerQuestData playerdata = PlayerData.get((EntityPlayer)event.getEntityPlayer()).questData;
        playerdata.checkQuestCompletion(event.getEntityPlayer(), 0);
    }

    @SubscribeEvent
    public void commandGive(CommandEvent event) {
        CommandSource source = (CommandSource)event.getParseResults().getContext().getSource();
        if (!(source.func_197023_e() instanceof WorldServer) || !source.func_197037_c().equalsIgnoreCase("give")) {
            return;
        }
        try {
            CommandContext context = event.getParseResults().getContext().build(event.getParseResults().getReader().getString());
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"targets");
            for (EntityPlayerMP player : players) {
                player.func_184102_h().field_175589_i.add(ListenableFutureTask.create(Executors.callable(() -> {
                    PlayerQuestData playerdata = PlayerData.get((EntityPlayer)player).questData;
                    playerdata.checkQuestCompletion((EntityPlayer)player, 0);
                })));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void world(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        PlayerData data = PlayerData.get((EntityPlayer)event.getEntity());
        data.updateCompanion(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void attachEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            PlayerData.register(event);
        }
        if (event.getObject() instanceof EntityLivingBase) {
            MarkData.register(event);
        }
        if (((Entity)event.getObject()).field_70170_p != null && !((Entity)event.getObject()).field_70170_p.field_72995_K && ((Entity)event.getObject()).field_70170_p instanceof WorldServer) {
            WrapperEntityData.register(event);
        }
    }

    @SubscribeEvent
    public void attachItem(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStackWrapper.register(event);
    }

    @SubscribeEvent
    public void savePlayer(PlayerEvent.SaveToFile event) {
        PlayerData.get(event.getEntityPlayer()).save(false);
    }

    @SubscribeEvent
    public void saveChunk(ChunkDataEvent.Save event) {
        if (!(event.getChunk() instanceof Chunk)) {
            return;
        }
        for (ClassInheritanceMultiMap map : ((Chunk)event.getChunk()).func_177429_s()) {
            for (Entity e : map) {
                if (!(e instanceof EntityLivingBase)) continue;
                MarkData.get((EntityLivingBase)e).save();
            }
        }
    }

    @SubscribeEvent
    public void playerTracking(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof EntityLivingBase) || event.getTarget().field_70170_p.field_72995_K) {
            return;
        }
        MarkData data = MarkData.get((EntityLivingBase)event.getTarget());
        if (data.marks.isEmpty()) {
            return;
        }
        Packets.send((EntityPlayerMP)event.getEntityPlayer(), new PacketMarkData(event.getTarget().func_145782_y(), data.getNBT()));
    }
}

