/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.fml.network.NetworkHooks;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IPos;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.entity.data.IPixelmonPlayerData;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ContainerCustomChestWrapper;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.EntityLivingBaseWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerCustomChest;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.packets.client.PacketPlaySound;
import noppes.npcs.packets.server.SPacketDimensionTeleport;
import noppes.npcs.util.ValueUtil;

public class PlayerWrapper<T extends EntityPlayerMP>
extends EntityLivingBaseWrapper<T>
implements IPlayer {
    private IContainer inventory;
    private Object pixelmonPartyStorage;
    private Object pixelmonPCStorage;
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            NBTTagCompound compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
        }

        @Override
        public Object get(String key) {
            NBTTagCompound compound = this.getStoredCompound();
            if (!compound.func_74764_b(key)) {
                return null;
            }
            INBTBase base = compound.func_74781_a(key);
            if (base instanceof NBTPrimitive) {
                return ((NBTPrimitive)base).func_150286_g();
            }
            return ((NBTTagString)base).func_150285_a_();
        }

        @Override
        public void remove(String key) {
            NBTTagCompound compound = this.getStoredCompound();
            compound.func_82580_o(key);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().func_74764_b(key);
        }

        @Override
        public void clear() {
            PlayerData data = PlayerData.get((EntityPlayer)PlayerWrapper.this.entity);
            data.scriptStoreddata = new NBTTagCompound();
        }

        private NBTTagCompound getStoredCompound() {
            PlayerData data = PlayerData.get((EntityPlayer)PlayerWrapper.this.entity);
            return data.scriptStoreddata;
        }

        @Override
        public String[] getKeys() {
            NBTTagCompound compound = this.getStoredCompound();
            return compound.func_150296_c().toArray(new String[compound.func_150296_c().size()]);
        }
    };
    private PlayerData data;

    public PlayerWrapper(T player) {
        super(player);
    }

    @Override
    public String getName() {
        return ((EntityPlayerMP)this.entity).func_200200_C_().func_150261_e();
    }

    @Override
    public String getDisplayName() {
        return ((EntityPlayerMP)this.entity).func_145748_c_().func_150261_e();
    }

    @Override
    public int getHunger() {
        return ((EntityPlayerMP)this.entity).func_71024_bL().func_75116_a();
    }

    @Override
    public void setHunger(int level) {
        ((EntityPlayerMP)this.entity).func_71024_bL().func_75114_a(level);
    }

    @Override
    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.finishedQuests.containsKey(id);
    }

    @Override
    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = this.getData().questData;
        return data.activeQuests.containsKey(id);
    }

    @Override
    public IQuest[] getActiveQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.activeQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    @Override
    public IQuest[] getFinishedQuests() {
        PlayerQuestData data = this.getData().questData;
        ArrayList<IQuest> quests = new ArrayList<IQuest>();
        for (int id : data.finishedQuests.keySet()) {
            IQuest quest = QuestController.instance.quests.get(id);
            if (quest == null) continue;
            quests.add(quest);
        }
        return quests.toArray(new IQuest[quests.size()]);
    }

    @Override
    public void startQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        QuestData questdata = new QuestData(quest);
        PlayerData data = this.getData();
        data.questData.activeQuests.put(id, questdata);
        Packets.send((EntityPlayerMP)this.entity, new PacketAchievement((ITextComponent)new TextComponentTranslation("quest.newquest", new Object[0]), (ITextComponent)new TextComponentTranslation(quest.title, new Object[0]), 2));
        ITextComponent text = new TextComponentTranslation("quest.newquest", new Object[0]).func_150258_a(":").func_150257_a((ITextComponent)new TextComponentTranslation(quest.title, new Object[0]));
        Packets.send((EntityPlayerMP)this.entity, new PacketChat(text));
        data.updateClient = true;
    }

    @Override
    public void sendNotification(String title, String msg, int type) {
        if (type < 0 || type > 3) {
            throw new CustomNPCsException("Wrong type value given " + type, new Object[0]);
        }
        Packets.send((EntityPlayerMP)this.entity, new PacketAchievement((ITextComponent)new TextComponentTranslation(title, new Object[0]), (ITextComponent)new TextComponentTranslation(msg, new Object[0]), type));
    }

    @Override
    public void finishQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.finishedQuests.put(id, System.currentTimeMillis());
        data.updateClient = true;
    }

    @Override
    public void stopQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.activeQuests.remove(id);
        data.updateClient = true;
    }

    @Override
    public void removeQuest(int id) {
        Quest quest = QuestController.instance.quests.get(id);
        if (quest == null) {
            return;
        }
        PlayerData data = this.getData();
        data.questData.activeQuests.remove(id);
        data.questData.finishedQuests.remove(id);
        data.updateClient = true;
    }

    @Override
    public boolean hasReadDialog(int id) {
        PlayerDialogData data = this.getData().dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public void showDialog(int id, String name) {
        Dialog dialog = DialogController.instance.dialogs.get(id);
        if (dialog == null) {
            throw new CustomNPCsException("Unknown Dialog id: " + id, new Object[0]);
        }
        if (!dialog.availability.isAvailable((EntityPlayer)this.entity)) {
            return;
        }
        EntityDialogNpc npc = new EntityDialogNpc((World)this.getWorld().getMCWorld());
        npc.display.setName(name);
        EntityUtil.Copy((EntityLivingBase)this.entity, (EntityLivingBase)npc);
        DialogOption option = new DialogOption();
        option.dialogId = id;
        option.title = dialog.title;
        npc.dialogs.put(0, option);
        NoppesUtilServer.openDialog((EntityPlayer)this.entity, npc, dialog);
    }

    @Override
    public void addFactionPoints(int faction, int points) {
        PlayerData data = this.getData();
        data.factionData.increasePoints((EntityPlayer)this.entity, faction, points);
        data.updateClient = true;
    }

    @Override
    public int getFactionPoints(int faction) {
        return this.getData().factionData.getFactionPoints((EntityPlayer)this.entity, faction);
    }

    @Override
    public float getRotation() {
        return ((EntityPlayerMP)this.entity).field_70177_z;
    }

    @Override
    public void setRotation(float rotation) {
        ((EntityPlayerMP)this.entity).field_70177_z = rotation;
    }

    @Override
    public void message(String message) {
        ((EntityPlayerMP)this.entity).func_145747_a((ITextComponent)new TextComponentTranslation(NoppesStringUtils.formatText(message, this.entity), new Object[0]));
    }

    @Override
    public int getGamemode() {
        return ((EntityPlayerMP)this.entity).field_71134_c.func_73081_b().func_77148_a();
    }

    @Override
    public void setGamemode(int type) {
        ((EntityPlayerMP)this.entity).func_71033_a(WorldSettings.func_77161_a((int)type));
    }

    @Override
    public int inventoryItemCount(IItemStack item) {
        int count = 0;
        for (int i = 0; i < ((EntityPlayerMP)this.entity).field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = ((EntityPlayerMP)this.entity).field_71071_by.func_70301_a(i);
            if (is == null || !this.isItemEqual(item.getMCItemStack(), is)) continue;
            count += is.func_190916_E();
        }
        return count;
    }

    private boolean isItemEqual(ItemStack stack, ItemStack other) {
        if (other.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() == other.func_77973_b();
    }

    @Override
    public int inventoryItemCount(String id) {
        Item item = (Item)IRegistry.field_212630_s.func_212608_b(new ResourceLocation(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.inventoryItemCount(NpcAPI.Instance().getIItemStack(new ItemStack((IItemProvider)item, 1)));
    }

    @Override
    public IContainer getInventory() {
        if (this.inventory == null) {
            this.inventory = new ContainerWrapper((IInventory)((EntityPlayerMP)this.entity).field_71071_by);
        }
        return this.inventory;
    }

    @Override
    public boolean removeItem(IItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (amount > count) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < ((EntityPlayerMP)this.entity).field_71071_by.func_70302_i_(); ++i) {
                ItemStack is = ((EntityPlayerMP)this.entity).field_71071_by.func_70301_a(i);
                if (is == null || !this.isItemEqual(item.getMCItemStack(), is)) continue;
                if (amount >= is.func_190916_E()) {
                    ((EntityPlayerMP)this.entity).field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    amount -= is.func_190916_E();
                    continue;
                }
                is.func_77979_a(amount);
                break;
            }
        }
        this.updatePlayerInventory();
        return true;
    }

    @Override
    public boolean removeItem(String id, int amount) {
        Item item = (Item)IRegistry.field_212630_s.func_212608_b(new ResourceLocation(id));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + id, new Object[0]);
        }
        return this.removeItem(NpcAPI.Instance().getIItemStack(new ItemStack((IItemProvider)item, 1)), amount);
    }

    @Override
    public boolean giveItem(IItemStack item) {
        ItemStack mcItem = item.getMCItemStack();
        if (mcItem.func_190926_b()) {
            return false;
        }
        boolean bo = ((EntityPlayerMP)this.entity).field_71071_by.func_70441_a(mcItem.func_77946_l());
        if (bo) {
            NoppesUtilServer.playSound((EntityLivingBase)this.entity, SoundEvents.field_187638_cR, 0.2f, ((((EntityPlayerMP)this.entity).func_70681_au().nextFloat() - ((EntityPlayerMP)this.entity).func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.updatePlayerInventory();
        }
        return bo;
    }

    @Override
    public boolean giveItem(String id, int amount) {
        Item item = (Item)IRegistry.field_212630_s.func_212608_b(new ResourceLocation(id));
        if (item == null) {
            return false;
        }
        ItemStack mcStack = new ItemStack((IItemProvider)item);
        IItemStack itemStack = NpcAPI.Instance().getIItemStack(mcStack);
        itemStack.setStackSize(amount);
        return this.giveItem(itemStack);
    }

    @Override
    public void updatePlayerInventory() {
        ((EntityPlayerMP)this.entity).field_71069_bz.func_75142_b();
        PlayerQuestData playerdata = this.getData().questData;
        playerdata.checkQuestCompletion((EntityPlayer)this.entity, 0);
    }

    @Override
    public IBlock getSpawnPoint() {
        BlockPos pos = ((EntityPlayerMP)this.entity).func_180470_cg();
        if (pos == null) {
            return this.getWorld().getSpawnPoint();
        }
        return NpcAPI.Instance().getIBlock(((EntityPlayerMP)this.entity).field_70170_p, pos);
    }

    @Override
    public void setSpawnPoint(IBlock block) {
        ((EntityPlayerMP)this.entity).func_180473_a(new BlockPos(block.getX(), block.getY(), block.getZ()), true);
    }

    @Override
    public void setSpawnpoint(int x, int y, int z) {
        x = ValueUtil.CorrectInt(x, -30000000, 30000000);
        z = ValueUtil.CorrectInt(z, -30000000, 30000000);
        y = ValueUtil.CorrectInt(y, 0, 256);
        ((EntityPlayerMP)this.entity).func_180473_a(new BlockPos(x, y, z), true);
    }

    @Override
    public void resetSpawnpoint() {
        ((EntityPlayerMP)this.entity).func_180473_a(null, false);
    }

    @Override
    public void removeAllItems(IItemStack item) {
        for (int i = 0; i < ((EntityPlayerMP)this.entity).field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = ((EntityPlayerMP)this.entity).field_71071_by.func_70301_a(i);
            if (is == null || !is.func_77969_a(item.getMCItemStack())) continue;
            ((EntityPlayerMP)this.entity).field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public boolean hasAdvancement(String achievement) {
        Advancement advancement = ((EntityPlayerMP)this.entity).func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation(achievement));
        if (advancement == null) {
            throw new CustomNPCsException("Advancement doesnt exist", new Object[0]);
        }
        AdvancementProgress progress = ((EntityPlayerMP)this.entity).func_184102_h().func_184103_al().func_192054_h((EntityPlayerMP)this.entity).func_192747_a(advancement);
        return progress.func_192105_a();
    }

    @Override
    public int getExpLevel() {
        return ((EntityPlayerMP)this.entity).field_71068_ca;
    }

    @Override
    public void setExpLevel(int level) {
        ((EntityPlayerMP)this.entity).field_71068_ca = level;
        ((EntityPlayerMP)this.entity).func_82242_a(0);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        SPacketDimensionTeleport.teleportPlayer((EntityPlayerMP)this.entity, x, y, z, ((EntityPlayerMP)this.entity).field_71093_bK);
    }

    @Override
    public void setPos(IPos pos) {
        SPacketDimensionTeleport.teleportPlayer((EntityPlayerMP)this.entity, pos.getX(), pos.getY(), pos.getZ(), ((EntityPlayerMP)this.entity).field_71093_bK);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 1 ? true : super.typeOf(type);
    }

    @Override
    public boolean hasPermission(String permission) {
        return CustomNpcsPermissions.hasPermissionString((EntityPlayer)this.entity, permission);
    }

    @Override
    public IPixelmonPlayerData getPixelmonData() {
        if (!PixelmonHelper.Enabled) {
            throw new CustomNPCsException("Pixelmon isnt installed", new Object[0]);
        }
        return new IPixelmonPlayerData(){

            @Override
            public Object getParty() {
                if (PlayerWrapper.this.pixelmonPartyStorage == null) {
                    PlayerWrapper.this.pixelmonPartyStorage = PixelmonHelper.getParty((EntityPlayerMP)PlayerWrapper.this.entity);
                }
                return PlayerWrapper.this.pixelmonPartyStorage;
            }

            @Override
            public Object getPC() {
                if (PlayerWrapper.this.pixelmonPCStorage == null) {
                    PlayerWrapper.this.pixelmonPCStorage = PixelmonHelper.getPc((EntityPlayerMP)PlayerWrapper.this.entity);
                }
                return PlayerWrapper.this.pixelmonPCStorage;
            }
        };
    }

    private PlayerData getData() {
        if (this.data == null) {
            this.data = PlayerData.get((EntityPlayer)this.entity);
        }
        return this.data;
    }

    @Override
    public ITimers getTimers() {
        return this.getData().timers;
    }

    @Override
    public void removeDialog(int id) {
        PlayerData data = this.getData();
        data.dialogData.dialogsRead.remove(id);
        data.updateClient = true;
    }

    @Override
    public void addDialog(int id) {
        PlayerData data = this.getData();
        data.dialogData.dialogsRead.add(id);
        data.updateClient = true;
    }

    @Override
    public void closeGui() {
        ((EntityPlayerMP)this.entity).func_71128_l();
        Packets.send((EntityPlayerMP)this.entity, new PacketGuiClose(new NBTTagCompound()));
    }

    @Override
    public int factionStatus(int factionId) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            throw new CustomNPCsException("Unknown faction: " + factionId, new Object[0]);
        }
        return faction.playerStatus(this);
    }

    @Override
    public void kick(String message) {
        ((EntityPlayerMP)this.entity).field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation(message, new Object[0]));
    }

    @Override
    public boolean canQuestBeAccepted(int questId) {
        return PlayerQuestController.canQuestBeAccepted((EntityPlayer)this.entity, questId);
    }

    @Override
    public void showCustomGui(ICustomGui gui) {
        CustomGuiController.openGui(this, (CustomGuiWrapper)gui);
    }

    @Override
    public ICustomGui getCustomGui() {
        if (((EntityPlayerMP)this.entity).field_71070_bA instanceof ContainerCustomGui) {
            return ((ContainerCustomGui)((EntityPlayerMP)this.entity).field_71070_bA).customGui;
        }
        return null;
    }

    @Override
    public void clearData() {
        PlayerData data = this.getData();
        data.setNBT(new NBTTagCompound());
        data.save(true);
    }

    @Override
    public IContainer showChestGui(final int rows) {
        ScriptContainer current = ScriptContainer.Current;
        ((EntityPlayerMP)this.entity).func_71053_j();
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)this.entity), (IInteractionObject)new IInteractionObject(){

            public ITextComponent func_200200_C_() {
                return new TextComponentString(EnumGuiType.CustomChest.name());
            }

            public boolean func_145818_k_() {
                return false;
            }

            @Nullable
            public ITextComponent func_200201_e() {
                return null;
            }

            public Container func_174876_a(InventoryPlayer inventoryPlayer, EntityPlayer entityPlayer) {
                return new ContainerCustomChest((EntityPlayer)PlayerWrapper.this.entity, rows);
            }

            public String func_174875_k() {
                return EnumGuiType.CustomChest.resource.toString();
            }
        }, buf -> buf.writeInt(rows));
        ContainerCustomChestWrapper container = (ContainerCustomChestWrapper)NpcAPI.Instance().getIContainer(((EntityPlayerMP)this.entity).field_71070_bA);
        container.script = current;
        return container;
    }

    @Override
    public IContainer getOpenContainer() {
        return NpcAPI.Instance().getIContainer(((EntityPlayerMP)this.entity).field_71070_bA);
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        BlockPos pos = ((EntityPlayerMP)this.entity).func_180425_c();
        Packets.send((EntityPlayerMP)this.entity, new PacketPlaySound(sound, pos, volume, pitch));
    }

    @Override
    public void sendMail(IPlayerMail mail) {
        PlayerData data = this.getData();
        data.mailData.playermail.add(((PlayerMail)mail).copy());
        data.save(false);
    }
}

