/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockScripted
extends BlockInterface {
    public static final VoxelShape AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.001f, (double)0.001f, (double)0.001f, (double)0.998f, (double)0.998f, (double)0.998f));

    public BlockScripted() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150348_b).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 10.0f));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileScripted();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        return AABB;
    }

    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader world, BlockPos pos) {
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (tile != null && tile.isPassible) {
            return VoxelShapes.func_197880_a();
        }
        return AABB;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter)) {
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptBlock, null, pos);
            return true;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        return !EventHooks.onScriptBlockInteract(tile, player, side.func_176745_a(), hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            PlayerData data = PlayerData.get((EntityPlayer)entity);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui((EntityPlayer)entity, EnumGuiType.ScriptBlock, null, pos);
        }
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockRainFill(tile);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        fallDistance = EventHooks.onScriptBlockFallenUpon(tile, entity, fallDistance);
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    public boolean func_200124_e(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_196270_a(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockClicked(tile, player);
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!world.field_72995_K) {
            TileScripted tile = (TileScripted)world.func_175625_s(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        TileScripted tile;
        if (!world.field_72995_K && EventHooks.onScriptBlockHarvest(tile = (TileScripted)world.func_175625_s(pos), player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return null;
    }

    public void onBlockExploded(IBlockState state, World world, BlockPos pos, Explosion explosion) {
        TileScripted tile;
        if (!world.field_72995_K && EventHooks.onScriptBlockExploded(tile = (TileScripted)world.func_175625_s(pos))) {
            return;
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos pos2) {
        if (world.field_72995_K) {
            return;
        }
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        EventHooks.onScriptBlockNeighborChanged(tile, pos2);
        int power = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            int p = world.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
            if (p <= power) continue;
            power = p;
        }
        if (tile.prevPower != power && tile.powering <= 0) {
            tile.newPower = power;
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockReader worldIn, BlockPos pos, EnumFacing side) {
        return this.func_176211_b(state, worldIn, pos, side);
    }

    public int func_176211_b(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing side) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).activePowering;
    }

    public boolean isLadder(IBlockState state, IWorldReader world, BlockPos pos, EntityLivingBase entity) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).isLadder;
    }

    public boolean canCreatureSpawn(IBlockState state, IWorldReaderBase world, BlockPos pos, EntitySpawnPlacementRegistry.SpawnPlacementType type, @Nullable EntityType<? extends EntityLiving> entityType) {
        return true;
    }

    public int getLightValue(IBlockState state, IWorldReader world, BlockPos pos) {
        TileScripted tile = (TileScripted)world.func_175625_s(pos);
        if (tile == null) {
            return 0;
        }
        return tile.lightValue;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).isPassible;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public float func_176195_g(IBlockState state, IBlockReader world, BlockPos pos) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).blockHardness;
    }

    public float getExplosionResistance(IBlockState state, IWorldReader world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((TileScripted)world.func_175625_s((BlockPos)pos)).blockResistance;
    }
}

