/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.blocks.BlockNpcDoorInterface;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.server.SPacketGuiOpen;

public class BlockScriptedDoor
extends BlockNpcDoorInterface {
    public BlockScriptedDoor() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150454_av).func_200948_a(5.0f, 10.0f));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)CustomBlocks.scripted_door_item);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileScriptedDoor();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return true;
        }
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter || currentItem.func_77973_b() == CustomBlocks.scripted_door_item)) {
            PlayerData data = PlayerData.get(player);
            data.scriptBlockPos = pos;
            SPacketGuiOpen.sendOpenGui(player, EnumGuiType.ScriptDoor, null, blockpos1);
            return true;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        if (EventHooks.onScriptBlockInteract(tile, player, side.func_176745_a(), hitX, hitY, hitZ)) {
            return false;
        }
        this.func_176512_a(world, blockpos1, ((Boolean)iblockstate1.func_177229_b((IProperty)BlockDoor.field_176519_b)).equals(false));
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos pos2) {
        if (state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.UPPER) {
            BlockPos blockpos1 = pos.func_177977_b();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.func_189540_a(iblockstate1, worldIn, blockpos1, neighborBlock, blockpos1);
            }
        } else {
            BlockPos blockpos2 = pos.func_177984_a();
            IBlockState iblockstate2 = worldIn.func_180495_p(blockpos2);
            if (iblockstate2.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else {
                boolean flag;
                TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
                if (!worldIn.field_72995_K) {
                    EventHooks.onScriptBlockNeighborChanged(tile, pos2);
                }
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos2);
                if ((flag || neighborBlock.func_176223_P().func_185897_m()) && neighborBlock != this && flag != (Boolean)iblockstate2.func_177229_b((IProperty)field_176522_N)) {
                    worldIn.func_180501_a(blockpos2, (IBlockState)iblockstate2.func_206870_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                        this.func_176512_a(worldIn, pos, flag);
                    }
                }
                int power = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int p = worldIn.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
                    if (p <= power) continue;
                    power = p;
                }
                tile.newPower = power;
            }
        }
    }

    public void func_176512_a(World worldIn, BlockPos pos, boolean open) {
        TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
        if (EventHooks.onScriptBlockDoorToggle(tile)) {
            return;
        }
        super.func_176512_a(worldIn, pos, open);
    }

    public void func_196270_a(IBlockState state, World world, BlockPos pos, EntityPlayer playerIn) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return;
        }
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        EventHooks.onScriptBlockClicked(tile, playerIn);
    }

    @Override
    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (!world.field_72995_K && iblockstate1.func_177230_c() == this) {
            TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        TileScriptedDoor tile;
        if (!world.field_72995_K && EventHooks.onScriptBlockHarvest(tile = (TileScriptedDoor)world.func_175625_s(pos), player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (player.field_71075_bZ.field_75098_d && iblockstate1.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.LOWER && iblockstate1.func_177230_c() == this) {
            world.func_175698_g(blockpos1);
        }
    }

    public float func_176195_g(IBlockState state, IBlockReader world, BlockPos pos) {
        return ((TileScriptedDoor)world.func_175625_s((BlockPos)pos)).blockHardness;
    }

    public float getExplosionResistance(IBlockState state, IWorldReader world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((TileScriptedDoor)world.func_175625_s((BlockPos)pos)).blockResistance;
    }
}

