/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.resources.AbstractResourcePack;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import noppes.npcs.CustomNpcs;
import org.apache.commons.lang3.StringUtils;

public class AssetsBrowser {
    public boolean isRoot;
    private int depth;
    private String folder;
    public HashSet<String> folders = new HashSet();
    public HashSet<String> files = new HashSet();
    private String[] extensions;

    public AssetsBrowser(String folder, String[] extensions) {
        this.extensions = extensions;
        this.setFolder(folder);
    }

    public void setFolder(String folder) {
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        this.isRoot = folder.length() <= 1;
        this.folder = "/assets" + folder;
        this.depth = StringUtils.countMatches((CharSequence)this.folder, (CharSequence)"/");
        this.getFiles();
    }

    public AssetsBrowser(String[] extensions) {
        this.extensions = extensions;
    }

    private void getFiles() {
        this.folders.clear();
        this.files.clear();
        SimpleReloadableResourceManager simplemanager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)simplemanager, (int)1);
        HashSet set = new HashSet();
        for (String name : map.keySet()) {
            FallbackResourceManager manager = (FallbackResourceManager)map.get(name);
            List list = manager.field_199023_a;
            for (IResourcePack pack : list) {
                this.processResourcePack(pack);
            }
        }
        for (String file : set) {
            this.progressFile(new File(file));
        }
        for (ModFileInfo mod : ModList.get().getModFiles()) {
            File file = mod.getFile().getFilePath().toFile();
            if (!file.exists()) continue;
            this.progressFile(file);
        }
        ResourcePackList repos = Minecraft.func_71410_x().func_195548_H();
        repos.func_198983_a();
        Collection list = repos.func_198980_d();
        for (ResourcePackInfoClient entry : list) {
            this.processResourcePack(entry.func_195796_e());
        }
        this.checkFolder(new File(CustomNpcs.Dir, "assets"), CustomNpcs.Dir.getAbsolutePath().length());
        this.checkFolder(new File(CustomNpcs.Dir, "assets"), CustomNpcs.Dir.getAbsolutePath().length());
    }

    private void processResourcePack(IResourcePack pack) {
        if (pack instanceof LegacyResourcePackWrapper) {
            pack = (IResourcePack)ObfuscationReflectionHelper.getPrivateValue(LegacyResourcePackWrapper.class, (Object)((LegacyResourcePackWrapper)pack), (int)0);
        }
        if (pack instanceof AbstractResourcePack) {
            AbstractResourcePack p = (AbstractResourcePack)pack;
            File file = p.field_195771_a;
            if (file != null) {
                if (file.isDirectory()) {
                    this.checkFolder(new File(file, "assets"), file.getAbsolutePath().length());
                } else {
                    this.progressFile(file);
                }
            }
        }
    }

    private void progressFile(File file) {
        try {
            if (!file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipentry = entries.nextElement();
                    String entryName = zipentry.getName();
                    this.checkFile(entryName);
                }
                zip.close();
            } else if (file.isDirectory()) {
                int length = file.getAbsolutePath().length();
                this.checkFolder(file, length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkFolder(File file, int length) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            String name = f.getAbsolutePath().substring(length);
            if (!(name = name.replace("\\", "/")).startsWith("/")) {
                name = "/" + name;
            }
            if (f.isDirectory() && (this.folder.startsWith(name) || name.startsWith(this.folder))) {
                this.checkFile(name + "/");
                this.checkFolder(f, length);
                continue;
            }
            this.checkFile(name);
        }
    }

    private void checkFile(String name) {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!name.startsWith(this.folder)) {
            return;
        }
        String[] split = name.split("/");
        int count = split.length;
        if (count == this.depth + 1) {
            if (this.validExtension(name)) {
                this.files.add(split[this.depth]);
            }
        } else if (this.depth + 1 < count) {
            this.folders.add(split[this.depth]);
        }
    }

    private boolean validExtension(String entryName) {
        int index = entryName.lastIndexOf(".");
        if (index < 0) {
            return false;
        }
        String extension = entryName.substring(index + 1);
        for (String ex : this.extensions) {
            if (!ex.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public String getAsset(String asset) {
        String[] split = this.folder.split("/");
        if (split.length < 3) {
            return null;
        }
        String texture = split[2] + ":";
        texture = texture + this.folder.substring(texture.length() + 8) + asset;
        return texture;
    }

    public static String getRoot(String asset) {
        String location;
        String mod = "minecraft";
        int index = asset.indexOf(":");
        if (index > 0) {
            mod = asset.substring(0, index);
            asset = asset.substring(index + 1);
        }
        if (asset.startsWith("/")) {
            asset = asset.substring(1);
        }
        if ((index = (location = "/" + mod + "/" + asset).lastIndexOf("/")) > 0) {
            location = location.substring(0, index);
        }
        return location;
    }
}

