/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabFactions;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabQuests;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.model.ModelBase;
import net.minecraft.client.renderer.entity.model.ModelBiped;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.FMLPlayMessages;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartData;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.VersionChecker;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.PresetController;
import noppes.npcs.client.fx.EntityEnderFX;
import noppes.npcs.client.gui.GuiBlockBuilder;
import noppes.npcs.client.gui.GuiBlockCopy;
import noppes.npcs.client.gui.GuiBorderBlock;
import noppes.npcs.client.gui.GuiMerchantAdd;
import noppes.npcs.client.gui.GuiNbtBook;
import noppes.npcs.client.gui.GuiNpcDimension;
import noppes.npcs.client.gui.GuiNpcMobSpawner;
import noppes.npcs.client.gui.GuiNpcMobSpawnerMounter;
import noppes.npcs.client.gui.GuiNpcPather;
import noppes.npcs.client.gui.GuiNpcRedstoneBlock;
import noppes.npcs.client.gui.GuiNpcRemoteEditor;
import noppes.npcs.client.gui.GuiNpcWaypoint;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.global.GuiNPCManageBanks;
import noppes.npcs.client.gui.global.GuiNPCManageDialogs;
import noppes.npcs.client.gui.global.GuiNPCManageFactions;
import noppes.npcs.client.gui.global.GuiNPCManageLinkedNpc;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiNPCManageTransporters;
import noppes.npcs.client.gui.global.GuiNpcManageRecipes;
import noppes.npcs.client.gui.global.GuiNpcQuestReward;
import noppes.npcs.client.gui.mainmenu.GuiNPCGlobalMainMenu;
import noppes.npcs.client.gui.mainmenu.GuiNPCInv;
import noppes.npcs.client.gui.mainmenu.GuiNpcAI;
import noppes.npcs.client.gui.mainmenu.GuiNpcAdvanced;
import noppes.npcs.client.gui.mainmenu.GuiNpcDisplay;
import noppes.npcs.client.gui.mainmenu.GuiNpcStats;
import noppes.npcs.client.gui.player.GuiCustomChest;
import noppes.npcs.client.gui.player.GuiMailbox;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.player.GuiNPCBankChest;
import noppes.npcs.client.gui.player.GuiNPCTrader;
import noppes.npcs.client.gui.player.GuiNpcCarpentryBench;
import noppes.npcs.client.gui.player.GuiNpcFollower;
import noppes.npcs.client.gui.player.GuiNpcFollowerHire;
import noppes.npcs.client.gui.player.GuiTransportSelection;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionInv;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionTalents;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeItem;
import noppes.npcs.client.gui.roles.GuiNpcBankSetup;
import noppes.npcs.client.gui.roles.GuiNpcFollowerSetup;
import noppes.npcs.client.gui.roles.GuiNpcItemGiver;
import noppes.npcs.client.gui.roles.GuiNpcTraderSetup;
import noppes.npcs.client.gui.roles.GuiNpcTransporter;
import noppes.npcs.client.gui.script.GuiScript;
import noppes.npcs.client.gui.script.GuiScriptBlock;
import noppes.npcs.client.gui.script.GuiScriptDoor;
import noppes.npcs.client.gui.script.GuiScriptGlobal;
import noppes.npcs.client.gui.script.GuiScriptItem;
import noppes.npcs.client.model.ModelBipedAlt;
import noppes.npcs.client.model.ModelClassicPlayer;
import noppes.npcs.client.model.ModelNPCGolem;
import noppes.npcs.client.model.ModelNpcCrystal;
import noppes.npcs.client.model.ModelNpcDragon;
import noppes.npcs.client.model.ModelNpcSlime;
import noppes.npcs.client.model.ModelPlayerAlt;
import noppes.npcs.client.renderer.RenderCustomNpc;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.client.renderer.RenderNPCPony;
import noppes.npcs.client.renderer.RenderNpcCrystal;
import noppes.npcs.client.renderer.RenderNpcDragon;
import noppes.npcs.client.renderer.RenderNpcSlime;
import noppes.npcs.client.renderer.RenderProjectile;
import noppes.npcs.config.TrueTypeFont;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerCarpentryBench;
import noppes.npcs.containers.ContainerCustomChest;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.containers.ContainerManageBanks;
import noppes.npcs.containers.ContainerManageRecipes;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.containers.ContainerNPCCompanion;
import noppes.npcs.containers.ContainerNPCFollower;
import noppes.npcs.containers.ContainerNPCFollowerHire;
import noppes.npcs.containers.ContainerNPCFollowerSetup;
import noppes.npcs.containers.ContainerNPCInv;
import noppes.npcs.containers.ContainerNPCTrader;
import noppes.npcs.containers.ContainerNPCTraderSetup;
import noppes.npcs.containers.ContainerNpcItemGiver;
import noppes.npcs.containers.ContainerNpcQuestReward;
import noppes.npcs.containers.ContainerNpcQuestTypeItem;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcAlex;
import noppes.npcs.entity.EntityNpcClassicPlayer;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;

public class ClientProxy
extends CommonProxy {
    public static PlayerData playerData = new PlayerData();
    public static KeyBinding QuestLog;
    public static KeyBinding Scene1;
    public static KeyBinding SceneReset;
    public static KeyBinding Scene2;
    public static KeyBinding Scene3;
    public static FontContainer Font;

    @Override
    public void load() {
        Font = new FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
        this.createFolders();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_199006_a((IResourceManagerReloadListener)new CustomNpcResourceListener());
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcPony.class, manager -> new RenderNPCPony(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcCrystal.class, manager -> new RenderNpcCrystal(manager, new ModelNpcCrystal(0.5f)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcDragon.class, manager -> new RenderNpcDragon(manager, new ModelNpcDragon(0.0f), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcSlime.class, manager -> new RenderNpcSlime(manager, new ModelNpcSlime(16), new ModelNpcSlime(0), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectile.class, manager -> new RenderProjectile(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityCustomNpc.class, manager -> new RenderCustomNpc(manager, (ModelBiped)new ModelPlayerAlt(0.0f, false)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNPC64x32.class, manager -> new RenderCustomNpc(manager, new ModelBipedAlt(0.0f)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNPCGolem.class, manager -> new RenderNPCInterface(manager, (ModelBase)new ModelNPCGolem(0.0f), 0.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcAlex.class, manager -> new RenderCustomNpc(manager, (ModelBiped)new ModelPlayerAlt(0.0f, true)));
        RenderingRegistry.registerEntityRenderingHandler(EntityNpcClassicPlayer.class, manager -> new RenderCustomNpc(manager, (ModelBiped)new ModelClassicPlayer(0.0f)));
        new MusicController();
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        Minecraft mc = Minecraft.func_71410_x();
        QuestLog = new KeyBinding("Quest Log", 76, "key.categories.gameplay");
        if (CustomNpcs.SceneButtonsEnabled) {
            Scene1 = new KeyBinding("Scene1 start/pause", 321, "key.categories.gameplay");
            Scene2 = new KeyBinding("Scene2 start/pause", 322, "key.categories.gameplay");
            Scene3 = new KeyBinding("Scene3 start/pause", 323, "key.categories.gameplay");
            SceneReset = new KeyBinding("Scene reset", 320, "key.categories.gameplay");
            ClientRegistry.registerKeyBinding((KeyBinding)Scene1);
            ClientRegistry.registerKeyBinding((KeyBinding)Scene2);
            ClientRegistry.registerKeyBinding((KeyBinding)Scene3);
            ClientRegistry.registerKeyBinding((KeyBinding)SceneReset);
        }
        ClientRegistry.registerKeyBinding((KeyBinding)QuestLog);
        new PresetController(CustomNpcs.Dir);
        if (CustomNpcs.EnableUpdateChecker) {
            VersionChecker checker = new VersionChecker();
            checker.start();
        }
        PixelmonHelper.loadClient();
    }

    @Override
    public PlayerData getPlayerData(EntityPlayer player) {
        if (player.func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
            if (ClientProxy.playerData.player != player) {
                ClientProxy.playerData.player = player;
            }
            return playerData;
        }
        return null;
    }

    @Override
    public void postload() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        if (CustomNpcs.InventoryGuiEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
            if (TabRegistry.getTabList().isEmpty()) {
                TabRegistry.registerTab(new InventoryTabVanilla());
            }
            TabRegistry.registerTab(new InventoryTabFactions());
            TabRegistry.registerTab(new InventoryTabQuests());
        }
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> 9127187, new IItemProvider[]{CustomItems.mount, CustomItems.cloner, CustomItems.moving, CustomItems.scripter, CustomItems.wand, CustomItems.teleporter});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            IItemStack item = NpcAPI.Instance().getIItemStack(stack);
            if (stack.func_77973_b() == CustomItems.scripted_item) {
                return ((IItemScripted)item).getColor();
            }
            return -1;
        }, new IItemProvider[]{CustomItems.scripted_item});
    }

    private void createFolders() {
        File json;
        File check;
        File file = new File(CustomNpcs.Dir, "assets/customnpcs");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(check = new File(file, "sounds")).exists()) {
            check.mkdir();
        }
        if (!(json = new File(file, "sounds.json")).exists()) {
            try {
                json.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(json));
                writer.write("{\n\n}");
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!(check = new File(file, "textures")).exists()) {
            check.mkdir();
        }
    }

    public static GuiScreen openGui(FMLPlayMessages.OpenContainer openContainer) {
        EnumGuiType gui = EnumGuiType.getEnum(openContainer.getId());
        if (gui == null) {
            return null;
        }
        return ClientProxy.getGui(gui, NoppesUtil.getLastNpc(), openContainer.getAdditionalData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GuiScreen getGui(EnumGuiType gui, EntityNPCInterface npc, PacketBuffer buf) {
        Container container = CustomNpcs.proxy.getContainer(gui, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, npc, buf == null ? null : new PacketBuffer(buf.copy()));
        try {
            if (gui == EnumGuiType.CustomChest) {
                GuiCustomChest guiCustomChest = new GuiCustomChest((ContainerCustomChest)container);
                return guiCustomChest;
            }
            if (gui == EnumGuiType.MainMenuDisplay) {
                if (npc != null) {
                    GuiNpcDisplay guiNpcDisplay = new GuiNpcDisplay(npc);
                    return guiNpcDisplay;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Unable to find npc"));
            } else {
                if (gui == EnumGuiType.MainMenuStats) {
                    GuiNpcStats guiNpcStats = new GuiNpcStats(npc);
                    return guiNpcStats;
                }
                if (gui == EnumGuiType.MainMenuInv) {
                    GuiNPCInv guiNPCInv = new GuiNPCInv(npc, (ContainerNPCInv)container);
                    return guiNPCInv;
                }
                if (gui == EnumGuiType.MainMenuAdvanced) {
                    GuiNpcAdvanced guiNpcAdvanced = new GuiNpcAdvanced(npc);
                    return guiNpcAdvanced;
                }
                if (gui == EnumGuiType.QuestReward) {
                    GuiNpcQuestReward guiNpcQuestReward = new GuiNpcQuestReward(npc, (ContainerNpcQuestReward)container);
                    return guiNpcQuestReward;
                }
                if (gui == EnumGuiType.QuestItem) {
                    GuiNpcQuestTypeItem guiNpcQuestTypeItem = new GuiNpcQuestTypeItem(npc, (ContainerNpcQuestTypeItem)container);
                    return guiNpcQuestTypeItem;
                }
                if (gui == EnumGuiType.MovingPath) {
                    GuiNpcPather guiNpcPather = new GuiNpcPather(npc);
                    return guiNpcPather;
                }
                if (gui == EnumGuiType.ManageFactions) {
                    GuiNPCManageFactions guiNPCManageFactions = new GuiNPCManageFactions(npc);
                    return guiNPCManageFactions;
                }
                if (gui == EnumGuiType.ManageLinked) {
                    GuiNPCManageLinkedNpc guiNPCManageLinkedNpc = new GuiNPCManageLinkedNpc(npc);
                    return guiNPCManageLinkedNpc;
                }
                if (gui == EnumGuiType.BuilderBlock) {
                    GuiBlockBuilder guiBlockBuilder = new GuiBlockBuilder(buf.func_179259_c());
                    return guiBlockBuilder;
                }
                if (gui == EnumGuiType.ManageTransport) {
                    GuiNPCManageTransporters guiNPCManageTransporters = new GuiNPCManageTransporters(npc);
                    return guiNPCManageTransporters;
                }
                if (gui == EnumGuiType.ManageRecipes) {
                    GuiNpcManageRecipes guiNpcManageRecipes = new GuiNpcManageRecipes(npc, (ContainerManageRecipes)container);
                    return guiNpcManageRecipes;
                }
                if (gui == EnumGuiType.ManageDialogs) {
                    GuiNPCManageDialogs guiNPCManageDialogs = new GuiNPCManageDialogs(npc);
                    return guiNPCManageDialogs;
                }
                if (gui == EnumGuiType.ManageQuests) {
                    GuiNPCManageQuest guiNPCManageQuest = new GuiNPCManageQuest(npc);
                    return guiNPCManageQuest;
                }
                if (gui == EnumGuiType.ManageBanks) {
                    GuiNPCManageBanks guiNPCManageBanks = new GuiNPCManageBanks(npc, (ContainerManageBanks)container);
                    return guiNPCManageBanks;
                }
                if (gui == EnumGuiType.Companion) {
                    GuiNpcCompanionStats guiNpcCompanionStats = new GuiNpcCompanionStats(npc);
                    return guiNpcCompanionStats;
                }
                if (gui == EnumGuiType.CompanionTalent) {
                    GuiNpcCompanionTalents guiNpcCompanionTalents = new GuiNpcCompanionTalents(npc);
                    return guiNpcCompanionTalents;
                }
                if (gui == EnumGuiType.CompanionInv) {
                    GuiNpcCompanionInv guiNpcCompanionInv = new GuiNpcCompanionInv(npc, (ContainerNPCCompanion)container);
                    return guiNpcCompanionInv;
                }
                if (gui == EnumGuiType.CustomGui) {
                    GuiCustom guiCustom = new GuiCustom((ContainerCustomGui)container);
                    return guiCustom;
                }
                if (gui == EnumGuiType.MainMenuGlobal) {
                    GuiNPCGlobalMainMenu guiNPCGlobalMainMenu = new GuiNPCGlobalMainMenu(npc);
                    return guiNPCGlobalMainMenu;
                }
                if (gui == EnumGuiType.MainMenuAI) {
                    GuiNpcAI guiNpcAI = new GuiNpcAI(npc);
                    return guiNpcAI;
                }
                if (gui == EnumGuiType.PlayerAnvil) {
                    GuiNpcCarpentryBench guiNpcCarpentryBench = new GuiNpcCarpentryBench((ContainerCarpentryBench)container);
                    return guiNpcCarpentryBench;
                }
                if (gui == EnumGuiType.PlayerFollowerHire) {
                    GuiNpcFollowerHire guiNpcFollowerHire = new GuiNpcFollowerHire(npc, (ContainerNPCFollowerHire)container);
                    return guiNpcFollowerHire;
                }
                if (gui == EnumGuiType.PlayerFollower) {
                    GuiNpcFollower guiNpcFollower = new GuiNpcFollower(npc, (ContainerNPCFollower)container);
                    return guiNpcFollower;
                }
                if (gui == EnumGuiType.PlayerTrader) {
                    GuiNPCTrader guiNPCTrader = new GuiNPCTrader(npc, (ContainerNPCTrader)container);
                    return guiNPCTrader;
                }
                if (gui == EnumGuiType.PlayerBankSmall || gui == EnumGuiType.PlayerBankUnlock || gui == EnumGuiType.PlayerBankUprade || gui == EnumGuiType.PlayerBankLarge) {
                    GuiNPCBankChest guiNPCBankChest = new GuiNPCBankChest(npc, (ContainerNPCBankInterface)container);
                    return guiNPCBankChest;
                }
                if (gui == EnumGuiType.PlayerTransporter) {
                    GuiTransportSelection guiTransportSelection = new GuiTransportSelection(npc);
                    return guiTransportSelection;
                }
                if (gui == EnumGuiType.Script) {
                    GuiScript guiScript = new GuiScript(npc);
                    return guiScript;
                }
                if (gui == EnumGuiType.ScriptBlock) {
                    GuiScriptBlock guiScriptBlock = new GuiScriptBlock(buf.func_179259_c());
                    return guiScriptBlock;
                }
                if (gui == EnumGuiType.ScriptItem) {
                    GuiScriptItem guiScriptItem = new GuiScriptItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    return guiScriptItem;
                }
                if (gui == EnumGuiType.ScriptDoor) {
                    GuiScriptDoor guiScriptDoor = new GuiScriptDoor(buf.func_179259_c());
                    return guiScriptDoor;
                }
                if (gui == EnumGuiType.ScriptPlayers) {
                    GuiScriptGlobal guiScriptGlobal = new GuiScriptGlobal();
                    return guiScriptGlobal;
                }
                if (gui == EnumGuiType.SetupFollower) {
                    GuiNpcFollowerSetup guiNpcFollowerSetup = new GuiNpcFollowerSetup(npc, (ContainerNPCFollowerSetup)container);
                    return guiNpcFollowerSetup;
                }
                if (gui == EnumGuiType.SetupItemGiver) {
                    GuiNpcItemGiver guiNpcItemGiver = new GuiNpcItemGiver(npc, (ContainerNpcItemGiver)container);
                    return guiNpcItemGiver;
                }
                if (gui == EnumGuiType.SetupTrader) {
                    GuiNpcTraderSetup guiNpcTraderSetup = new GuiNpcTraderSetup(npc, (ContainerNPCTraderSetup)container);
                    return guiNpcTraderSetup;
                }
                if (gui == EnumGuiType.SetupTransporter) {
                    GuiNpcTransporter guiNpcTransporter = new GuiNpcTransporter(npc);
                    return guiNpcTransporter;
                }
                if (gui == EnumGuiType.SetupBank) {
                    GuiNpcBankSetup guiNpcBankSetup = new GuiNpcBankSetup(npc);
                    return guiNpcBankSetup;
                }
                if (gui == EnumGuiType.NpcRemote && Minecraft.func_71410_x().field_71462_r == null) {
                    GuiNpcRemoteEditor guiNpcRemoteEditor = new GuiNpcRemoteEditor();
                    return guiNpcRemoteEditor;
                }
                if (gui == EnumGuiType.PlayerMailman) {
                    GuiMailmanWrite guiMailmanWrite = new GuiMailmanWrite((ContainerMail)container, buf.readBoolean(), buf.readBoolean());
                    return guiMailmanWrite;
                }
                if (gui == EnumGuiType.PlayerMailbox) {
                    GuiMailbox guiMailbox = new GuiMailbox();
                    return guiMailbox;
                }
                if (gui == EnumGuiType.MerchantAdd) {
                    GuiMerchantAdd guiMerchantAdd = new GuiMerchantAdd();
                    return guiMerchantAdd;
                }
                if (gui == EnumGuiType.NpcDimensions) {
                    GuiNpcDimension guiNpcDimension = new GuiNpcDimension();
                    return guiNpcDimension;
                }
                if (gui == EnumGuiType.Border) {
                    GuiBorderBlock guiBorderBlock = new GuiBorderBlock(buf.func_179259_c());
                    return guiBorderBlock;
                }
                if (gui == EnumGuiType.RedstoneBlock) {
                    GuiNpcRedstoneBlock guiNpcRedstoneBlock = new GuiNpcRedstoneBlock(buf.func_179259_c());
                    return guiNpcRedstoneBlock;
                }
                if (gui == EnumGuiType.MobSpawner) {
                    GuiNpcMobSpawner guiNpcMobSpawner = new GuiNpcMobSpawner(buf.func_179259_c());
                    return guiNpcMobSpawner;
                }
                if (gui == EnumGuiType.CopyBlock) {
                    GuiBlockCopy guiBlockCopy = new GuiBlockCopy(buf.func_179259_c());
                    return guiBlockCopy;
                }
                if (gui == EnumGuiType.MobSpawnerMounter) {
                    GuiNpcMobSpawnerMounter guiNpcMobSpawnerMounter = new GuiNpcMobSpawnerMounter(buf.func_179259_c());
                    return guiNpcMobSpawnerMounter;
                }
                if (gui == EnumGuiType.Waypoint) {
                    GuiNpcWaypoint guiNpcWaypoint = new GuiNpcWaypoint(buf.func_179259_c());
                    return guiNpcWaypoint;
                }
                if (gui == EnumGuiType.Companion) {
                    GuiNpcCompanionStats guiNpcCompanionStats = new GuiNpcCompanionStats(npc);
                    return guiNpcCompanionStats;
                }
                if (gui == EnumGuiType.CompanionTalent) {
                    GuiNpcCompanionTalents guiNpcCompanionTalents = new GuiNpcCompanionTalents(npc);
                    return guiNpcCompanionTalents;
                }
                if (gui == EnumGuiType.CompanionInv) {
                    GuiNpcCompanionInv guiNpcCompanionInv = new GuiNpcCompanionInv(npc, (ContainerNPCCompanion)container);
                    return guiNpcCompanionInv;
                }
                if (gui == EnumGuiType.NbtBook) {
                    GuiNbtBook guiNbtBook = new GuiNbtBook(buf.func_179259_c());
                    return guiNbtBook;
                }
            }
            GuiScreen guiScreen = null;
            return guiScreen;
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    @Override
    public void openGui(EntityPlayer player, EnumGuiType gui) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g != player) {
            return;
        }
        minecraft.func_147108_a(ClientProxy.getGui(gui, null, null));
    }

    @Override
    public void openGui(EntityNPCInterface npc, EnumGuiType gui) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_147108_a(ClientProxy.getGui(gui, npc, null));
    }

    @Override
    public void openGui(EntityPlayer player, Object guiscreen) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!player.field_70170_p.field_72995_K || !(guiscreen instanceof GuiScreen)) {
            return;
        }
        if (guiscreen != null) {
            minecraft.func_147108_a((GuiScreen)guiscreen);
        }
    }

    @Override
    public void spawnParticle(EntityLivingBase player, String string, Object ... ob) {
        if (string.equals("Block")) {
            BlockPos pos = (BlockPos)ob[0];
            IBlockState state = (IBlockState)ob[1];
            Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, state);
        } else if (string.equals("ModelData")) {
            ModelData data = (ModelData)ob[0];
            ModelPartData particles = (ModelPartData)ob[1];
            EntityCustomNpc npc = (EntityCustomNpc)player;
            Minecraft minecraft = Minecraft.func_71410_x();
            double height = npc.func_70033_W() + (double)data.getBodyY();
            Random rand = npc.func_70681_au();
            for (int i = 0; i < 2; ++i) {
                EntityEnderFX fx = new EntityEnderFX(npc, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, rand.nextDouble() * (double)player.field_70131_O - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.field_70130_N, (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                minecraft.field_71452_i.func_78873_a((Particle)fx);
            }
        }
    }

    @Override
    public boolean hasClient() {
        return true;
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void bindTexture(ResourceLocation location) {
        try {
            if (location == null) {
                return;
            }
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            ITextureObject ob = manager.func_110581_b(location);
            if (ob == null) {
                ob = new SimpleTexture(location);
                manager.func_110579_a(location, ob);
            }
            GlStateManager.func_179144_i((int)ob.func_110552_b());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void spawnParticle(BasicParticleType particle, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        double xx = mc.func_175606_aa().field_70165_t - x;
        double yy = mc.func_175606_aa().field_70163_u - y;
        double zz = mc.func_175606_aa().field_70161_v - z;
        if (xx * xx + yy * yy + zz * zz > 256.0) {
            return;
        }
        Particle fx = mc.field_71452_i.func_199280_a((IParticleData)particle, x, y, z, motionX, motionY, motionZ);
        if (fx == null) {
            return;
        }
        if (particle == Particles.field_197631_x) {
            ObfuscationReflectionHelper.setPrivateValue(ParticleFlame.class, (Object)((ParticleFlame)fx), (Object)Float.valueOf(scale), (int)0);
        } else if (particle == Particles.field_197601_L) {
            ObfuscationReflectionHelper.setPrivateValue(ParticleSmokeNormal.class, (Object)((ParticleSmokeNormal)fx), (Object)Float.valueOf(scale), (int)0);
        }
    }

    @Override
    public IResource getResource(ResourceLocation resource) {
        try {
            return Minecraft.func_71410_x().func_195551_G().func_199002_a(resource);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static class FontContainer {
        private TrueTypeFont textFont = null;
        public boolean useCustomFont = true;

        private FontContainer() {
        }

        public FontContainer(String fontType, int fontSize) {
            this.textFont = new TrueTypeFont(new Font(fontType, 0, fontSize), 1.0f);
            this.useCustomFont = !fontType.equalsIgnoreCase("minecraft");
            try {
                if (!this.useCustomFont || fontType.isEmpty() || fontType.equalsIgnoreCase("default")) {
                    this.textFont = new TrueTypeFont(new ResourceLocation("customnpcs", "opensans.ttf"), fontSize, 1.0f);
                }
            }
            catch (Exception e) {
                LogWriter.info("Failed loading font so using Arial");
            }
        }

        public int height(String text) {
            if (this.useCustomFont) {
                return this.textFont.height(text);
            }
            return Minecraft.func_71410_x().field_71466_p.field_78288_b;
        }

        public int width(String text) {
            if (this.useCustomFont) {
                return this.textFont.width(text);
            }
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        }

        public FontContainer copy() {
            FontContainer font = new FontContainer();
            font.textFont = this.textFont;
            font.useCustomFont = this.useCustomFont;
            return font;
        }

        public void drawString(String text, int x, int y, int color) {
            if (this.useCustomFont) {
                this.textFont.draw(text, x, y, color);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)x, (float)y, color);
            }
        }

        public String getName() {
            if (!this.useCustomFont) {
                return "Minecraft";
            }
            return this.textFont.getFontName();
        }

        public void clear() {
            if (this.textFont != null) {
                this.textFont.dispose();
            }
        }
    }
}

