/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import noppes.npcs.client.controllers.ClientCloneController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCloneList;
import noppes.npcs.packets.server.SPacketCloneRemove;
import noppes.npcs.packets.server.SPacketToolMobSpawner;

public class GuiNpcMobSpawner
extends GuiNPCInterface
implements IGuiData {
    private GuiCustomScroll scroll;
    private BlockPos pos;
    private List<String> list;
    private static int showingClones = 0;
    private static String search = "";
    private int activeTab = 1;

    public GuiNpcMobSpawner(BlockPos pos) {
        this.xSize = 256;
        this.pos = pos;
        this.setBackground("menubg.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(165, 188);
        } else {
            this.scroll.clear();
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 26;
        this.addScroll(this.scroll);
        this.addTextField(new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 4, this.guiTop + 4, 165, 20, search));
        GuiMenuTopButton button = new GuiMenuTopButton(this, 3, this.guiLeft + 4, this.guiTop - 17, "spawner.clones");
        this.addTopButton(button);
        button.active = showingClones == 0;
        button = new GuiMenuTopButton(this, 4, button, "spawner.entities");
        this.addTopButton(button);
        button.active = showingClones == 1;
        button = new GuiMenuTopButton(this, 5, button, "gui.server");
        this.addTopButton(button);
        button.active = showingClones == 2;
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 170, this.guiTop + 6, 82, 20, "item.customnpcs.monsterPlacer.name"));
        this.addButton(new GuiNpcButton(this, 2, this.guiLeft + 170, this.guiTop + 100, 82, 20, "spawner.mobspawner"));
        if (showingClones == 0 || showingClones == 2) {
            this.addSideButton(new GuiMenuSideButton(this, 21, this.guiLeft - 69, this.guiTop + 2, 70, 22, "Tab 1"));
            this.addSideButton(new GuiMenuSideButton(this, 22, this.guiLeft - 69, this.guiTop + 23, 70, 22, "Tab 2"));
            this.addSideButton(new GuiMenuSideButton(this, 23, this.guiLeft - 69, this.guiTop + 44, 70, 22, "Tab 3"));
            this.addSideButton(new GuiMenuSideButton(this, 24, this.guiLeft - 69, this.guiTop + 65, 70, 22, "Tab 4"));
            this.addSideButton(new GuiMenuSideButton(this, 25, this.guiLeft - 69, this.guiTop + 86, 70, 22, "Tab 5"));
            this.addSideButton(new GuiMenuSideButton(this, 26, this.guiLeft - 69, this.guiTop + 107, 70, 22, "Tab 6"));
            this.addSideButton(new GuiMenuSideButton(this, 27, this.guiLeft - 69, this.guiTop + 128, 70, 22, "Tab 7"));
            this.addSideButton(new GuiMenuSideButton(this, 28, this.guiLeft - 69, this.guiTop + 149, 70, 22, "Tab 8"));
            this.addSideButton(new GuiMenuSideButton(this, 29, this.guiLeft - 69, this.guiTop + 170, 70, 22, "Tab 9"));
            this.addButton(new GuiNpcButton(this, 6, this.guiLeft + 170, this.guiTop + 30, 82, 20, "gui.remove"));
            this.getSideButton((int)(20 + this.activeTab)).active = true;
            this.showClones();
        } else {
            this.showEntities();
        }
    }

    private void showEntities() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Class> classes = new ArrayList<Class>();
        for (ResourceLocation resource : IRegistry.field_212629_r.func_148742_b()) {
            EntityType ent = (EntityType)IRegistry.field_212629_r.func_212608_b(resource);
            Class c = ent.func_201760_c();
            String name = ent.func_210760_d();
            try {
                if (classes.contains(c) || !EntityLiving.class.isAssignableFrom(c) || c.getConstructor(World.class) == null || Modifier.isAbstract(c.getModifiers())) continue;
                list.add(name.toString());
                classes.add(c);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.list = list;
        this.scroll.setList(this.getSearchList());
    }

    private void showClones() {
        if (showingClones == 2) {
            Packets.sendServer(new SPacketCloneList(this.activeTab));
            return;
        }
        ArrayList list = new ArrayList();
        this.list = ClientCloneController.Instance.getClones(this.activeTab);
        this.scroll.setList(this.getSearchList());
    }

    @Override
    public boolean charTyped(char c, int i) {
        super.charTyped(c, i);
        if (search.equals(this.getTextField(1).func_146179_b())) {
            return true;
        }
        search = this.getTextField(1).func_146179_b().toLowerCase();
        this.scroll.setList(this.getSearchList());
        return true;
    }

    private List<String> getSearchList() {
        if (search.isEmpty()) {
            return new ArrayList<String>(this.list);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.list) {
            if (!name.toLowerCase().contains(search)) continue;
            list.add(name);
        }
        return list;
    }

    private NBTTagCompound getCompound() {
        String sel = this.scroll.getSelected();
        if (sel == null) {
            return null;
        }
        if (showingClones == 0) {
            return ClientCloneController.Instance.getCloneData(this.player.func_195051_bN(), sel, this.activeTab);
        }
        EntityType type = (EntityType)IRegistry.field_212629_r.func_212608_b(new ResourceLocation(sel));
        Entity entity = type.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        if (entity == null) {
            return null;
        }
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_184198_c(compound);
        return compound;
    }

    @Override
    public void buttonEvent(GuiButton guibutton) {
        NBTTagCompound compound;
        String sel;
        int id = guibutton.field_146127_k;
        if (id == 0) {
            this.func_195122_V_();
        }
        if (id == 1) {
            if (showingClones == 2) {
                sel = this.scroll.getSelected();
                if (sel == null) {
                    return;
                }
                Packets.sendServer(new SPacketToolMobSpawner(true, this.pos, sel, this.activeTab));
                this.func_195122_V_();
            } else {
                compound = this.getCompound();
                if (compound == null) {
                    return;
                }
                Packets.sendServer(new SPacketToolMobSpawner(false, this.pos, compound));
                this.func_195122_V_();
            }
        }
        if (id == 2) {
            if (showingClones == 2) {
                sel = this.scroll.getSelected();
                if (sel == null) {
                    return;
                }
                Packets.sendServer(new SPacketToolMobSpawner(true, this.pos, sel, this.activeTab));
                this.func_195122_V_();
            } else {
                compound = this.getCompound();
                if (compound == null) {
                    return;
                }
                Packets.sendServer(new SPacketToolMobSpawner(false, this.pos, compound));
                this.func_195122_V_();
            }
        }
        if (id == 3) {
            showingClones = 0;
            this.func_73866_w_();
        }
        if (id == 4) {
            showingClones = 1;
            this.func_73866_w_();
        }
        if (id == 5) {
            showingClones = 2;
            this.func_73866_w_();
        }
        if (id == 6 && this.scroll.getSelected() != null) {
            if (showingClones == 2) {
                Packets.sendServer(new SPacketCloneRemove(this.scroll.getSelected(), this.activeTab));
                return;
            }
            ClientCloneController.Instance.removeClone(this.scroll.getSelected(), this.activeTab);
            this.scroll.selected = -1;
            this.func_73866_w_();
        }
        if (id > 20) {
            this.activeTab = id - 20;
            this.func_73866_w_();
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        NBTTagList nbtlist = compound.func_150295_c("List", 8);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtlist.size(); ++i) {
            list.add(nbtlist.func_150307_f(i));
        }
        this.list = list;
        this.scroll.setList(this.getSearchList());
    }
}

