/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NBTTags;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.constants.EnumMenuType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketMenuGet;
import noppes.npcs.packets.server.SPacketMenuSave;

public class GuiNpcPather
extends GuiNPCInterface
implements IGuiData {
    private GuiCustomScroll scroll;
    private HashMap<String, Integer> data = new HashMap();
    private DataAI ai;

    public GuiNpcPather(EntityNPCInterface npc) {
        this.drawDefaultBackground = false;
        this.xSize = 176;
        this.title = "Npc Pather";
        this.setBackground("smallbg.png");
        this.ai = npc.ais;
        Packets.sendServer(new SPacketMenuGet(EnumMenuType.MOVING_PATH));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.scroll = new GuiCustomScroll(this, 0);
        this.scroll.setSize(160, 164);
        ArrayList<String> list = new ArrayList<String>();
        for (int[] arr : this.ai.getMovingPath()) {
            list.add("x:" + arr[0] + " y:" + arr[1] + " z:" + arr[2]);
        }
        this.scroll.setUnsortedList(list);
        this.scroll.guiLeft = this.guiLeft + 7;
        this.scroll.guiTop = this.guiTop + 12;
        this.addScroll(this.scroll);
        this.addButton(new GuiNpcButton(this, 0, this.guiLeft + 6, this.guiTop + 178, 52, 20, "gui.down"));
        this.addButton(new GuiNpcButton(this, 1, this.guiLeft + 62, this.guiTop + 178, 52, 20, "gui.up"));
        this.addButton(new GuiNpcButton(this, 2, this.guiLeft + 118, this.guiTop + 178, 52, 20, "selectWorld.deleteButton"));
    }

    @Override
    public void buttonEvent(GuiButton guibutton) {
        int[] b;
        int[] a;
        int selected;
        List<int[]> list;
        if (this.scroll.selected < 0) {
            return;
        }
        int id = guibutton.field_146127_k;
        if (id == 0) {
            list = this.ai.getMovingPath();
            selected = this.scroll.selected;
            if (list.size() <= selected + 1) {
                return;
            }
            a = list.get(selected);
            b = list.get(selected + 1);
            list.set(selected, b);
            list.set(selected + 1, a);
            this.ai.setMovingPath(list);
            this.func_73866_w_();
            this.scroll.selected = selected + 1;
        }
        if (id == 1) {
            if (this.scroll.selected - 1 < 0) {
                return;
            }
            list = this.ai.getMovingPath();
            selected = this.scroll.selected;
            a = list.get(selected);
            b = list.get(selected - 1);
            list.set(selected, b);
            list.set(selected - 1, a);
            this.ai.setMovingPath(list);
            this.func_73866_w_();
            this.scroll.selected = selected - 1;
        }
        if (id == 2) {
            list = this.ai.getMovingPath();
            if (list.size() <= 1) {
                return;
            }
            list.remove(this.scroll.selected);
            this.ai.setMovingPath(list);
            this.func_73866_w_();
        }
    }

    @Override
    public boolean mouseClicked(double i, double j, int k) {
        this.scroll.mouseClicked(i, j, k);
        return super.mouseClicked(i, j, k);
    }

    @Override
    public void save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("MovingPathNew", (INBTBase)NBTTags.nbtIntegerArraySet(this.ai.getMovingPath()));
        Packets.sendServer(new SPacketMenuSave(EnumMenuType.MOVING_PATH, compound));
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.ai.readToNBT(compound);
        this.func_73866_w_();
    }
}

