/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.client.gui.custom.components.CustomGuiButton;
import noppes.npcs.client.gui.custom.components.CustomGuiLabel;
import noppes.npcs.client.gui.custom.components.CustomGuiScrollComponent;
import noppes.npcs.client.gui.custom.components.CustomGuiTextField;
import noppes.npcs.client.gui.custom.components.CustomGuiTexturedRect;
import noppes.npcs.client.gui.custom.interfaces.IDataHolder;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketCustomGuiButton;
import noppes.npcs.packets.server.SPacketCustomGuiClose;
import noppes.npcs.packets.server.SPacketCustomGuiScrollClick;
import noppes.npcs.packets.server.SPacketCustomGuiSlotChange;

public class GuiCustom
extends GuiContainer
implements ICustomScrollListener,
IGuiData {
    CustomGuiWrapper gui;
    int field_146999_f;
    int field_147000_g;
    public static int guiLeft;
    public static int guiTop;
    ResourceLocation background;
    public String[] hoverText;
    Map<Integer, IGuiComponent> components = new HashMap<Integer, IGuiComponent>();
    List<IDataHolder> dataHolders = new ArrayList<IDataHolder>();

    public GuiCustom(ContainerCustomGui container) {
        super((Container)container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.gui != null) {
            guiLeft = (this.field_146294_l - this.field_146999_f) / 2;
            guiTop = (this.field_146295_m - this.field_147000_g) / 2;
            this.components.clear();
            this.dataHolders.clear();
            for (ICustomGuiComponent c : this.gui.getComponents()) {
                this.addComponent(c);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (IDataHolder component : this.dataHolders) {
            if (!(component instanceof GuiTextField)) continue;
            ((GuiTextField)component).func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.hoverText = null;
        this.func_146276_q_();
        if (this.background != null) {
            this.drawBackgroundTexture();
        }
        for (IGuiComponent component : this.components.values()) {
            component.onRender(mouseX, mouseY, partialTicks);
        }
        if (this.hoverText != null) {
            this.func_146283_a(Arrays.asList(this.hoverText), mouseX, mouseY);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    void drawBackgroundTexture() {
        this.field_146297_k.func_110434_K().func_110577_a(this.background);
        this.func_73729_b(guiLeft, guiTop, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void addComponent(ICustomGuiComponent component) {
        CustomGuiComponentWrapper c = (CustomGuiComponentWrapper)component;
        switch (c.getType()) {
            case 0: {
                CustomGuiButton button = CustomGuiButton.fromComponent((CustomGuiButtonWrapper)component);
                button.setParent(this);
                this.components.put(button.getID(), button);
                break;
            }
            case 1: {
                CustomGuiLabel lbl = CustomGuiLabel.fromComponent((CustomGuiLabelWrapper)component);
                lbl.setParent(this);
                this.components.put(lbl.getID(), lbl);
                break;
            }
            case 3: {
                CustomGuiTextField textField = CustomGuiTextField.fromComponent((CustomGuiTextFieldWrapper)component);
                textField.setParent(this);
                this.components.put(textField.field_175208_g, textField);
                this.addDataHolder(textField);
                break;
            }
            case 2: {
                CustomGuiTexturedRect rect = CustomGuiTexturedRect.fromComponent((CustomGuiTexturedRectWrapper)component);
                rect.setParent(this);
                this.components.put(rect.getID(), rect);
                break;
            }
            case 4: {
                CustomGuiScrollComponent scroll = new CustomGuiScrollComponent(this.field_146297_k, (GuiScreen)this, component.getID(), ((CustomGuiScrollWrapper)component).isMultiSelect());
                scroll.fromComponent((CustomGuiScrollWrapper)component);
                scroll.setParent(this);
                this.components.put(scroll.getID(), scroll);
                this.addDataHolder(scroll);
            }
        }
    }

    public void buttonClick(CustomGuiButton button) {
        Packets.sendServer(new SPacketCustomGuiButton(button.field_146127_k, this.updateGui().toNBT()));
    }

    public void slotChange(Slot slot) {
        Packets.sendServer(new SPacketCustomGuiSlotChange(slot.field_75222_d, this.updateGui().toNBT()));
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        Packets.sendServer(new SPacketCustomGuiScrollClick(scroll.id, scroll.selected, false, this.getScrollSelection((CustomGuiScrollComponent)scroll), this.updateGui().toNBT()));
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
        Packets.sendServer(new SPacketCustomGuiScrollClick(scroll.id, scroll.selected, true, this.getScrollSelection((CustomGuiScrollComponent)scroll), this.updateGui().toNBT()));
    }

    public void func_146281_b() {
        if (this.gui != null) {
            Packets.sendServer(new SPacketCustomGuiClose(this.updateGui().toNBT()));
        }
        super.func_146281_b();
    }

    CustomGuiWrapper updateGui() {
        for (IDataHolder component : this.dataHolders) {
            this.gui.updateComponent(component.toComponent());
        }
        return this.gui;
    }

    NBTTagCompound getScrollSelection(CustomGuiScrollComponent scroll) {
        NBTTagList list = new NBTTagList();
        if (scroll.multiSelect) {
            for (String s : scroll.getSelectedList()) {
                list.add((INBTBase)new NBTTagString(s));
            }
        } else {
            list.add((INBTBase)new NBTTagString(scroll.getSelected()));
        }
        NBTTagCompound selection = new NBTTagCompound();
        selection.func_74782_a("selection", (INBTBase)list);
        return selection;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        for (IGuiComponent comp : this.components.values()) {
            if (!(comp instanceof IGuiEventListener)) continue;
            ((IGuiEventListener)comp).charTyped(typedChar, keyCode);
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (IGuiComponent comp : this.components.values()) {
            if (!(comp instanceof IGuiEventListener)) continue;
            ((IGuiEventListener)comp).keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)key, (int)p_keyPressed_2_))) {
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        for (IGuiComponent comp : this.components.values()) {
            if (!(comp instanceof IGuiEventListener)) continue;
            ((IGuiEventListener)comp).mouseClicked(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean func_73868_f() {
        if (this.gui != null) {
            return this.gui.getDoesPauseGame();
        }
        return true;
    }

    public void addDataHolder(IDataHolder component) {
        this.dataHolders.add(component);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        Minecraft mc = Minecraft.func_71410_x();
        CustomGuiWrapper gui = (CustomGuiWrapper)new CustomGuiWrapper().fromNBT(compound);
        ((ContainerCustomGui)this.field_147002_h).setGui(gui, (EntityPlayer)mc.field_71439_g);
        this.gui = gui;
        this.field_146999_f = gui.getWidth();
        this.field_147000_g = gui.getHeight();
        if (!gui.getBackgroundTexture().isEmpty()) {
            this.background = new ResourceLocation(gui.getBackgroundTexture());
        }
        this.func_73866_w_();
    }
}

