/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.entity.NPCRendererHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcAlex;
import noppes.npcs.entity.EntityNpcClassicPlayer;

public class GuiCreationEntities
extends GuiCreationScreenInterface
implements ICustomScrollListener {
    public HashMap<String, Class<? extends EntityLivingBase>> data = new HashMap();
    private List<String> list;
    private GuiCustomScroll scroll;
    private boolean resetToSelected = true;

    public GuiCreationEntities(EntityNPCInterface npc) {
        super(npc);
        for (ResourceLocation resource : IRegistry.field_212629_r.func_148742_b()) {
            EntityType ent = (EntityType)IRegistry.field_212629_r.func_212608_b(resource);
            String name = ent.func_210760_d();
            Class c = ent.func_201760_c();
            try {
                String s;
                if (!EntityLiving.class.isAssignableFrom(c) || c.getConstructor(World.class) == null || Modifier.isAbstract(c.getModifiers()) || !(Minecraft.func_71410_x().func_175598_ae().func_78715_a(c) instanceof RenderLivingBase) || (s = name).toLowerCase().contains("customnpc")) continue;
                this.data.put(name, c.asSubclass(EntityLivingBase.class));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.data.put("NPC 64x32", EntityNPC64x32.class);
        this.data.put("NPC Alex Arms", EntityNpcAlex.class);
        this.data.put("NPC Classic Player", EntityNpcClassicPlayer.class);
        this.list = new ArrayList<String>(this.data.keySet());
        this.list.add("NPC");
        Collections.sort(this.list, String.CASE_INSENSITIVE_ORDER);
        this.active = 1;
        this.xOffset = 60;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButton(new GuiNpcButton(this, 10, this.guiLeft, this.guiTop + 46, 120, 20, "Reset To NPC"));
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setUnsortedList(this.list);
        }
        this.scroll.guiLeft = this.guiLeft;
        this.scroll.guiTop = this.guiTop + 68;
        this.scroll.setSize(100, this.ySize - 96);
        String selected = "NPC";
        if (this.entity != null) {
            for (Map.Entry<String, Class<? extends EntityLivingBase>> en : this.data.entrySet()) {
                if (!en.getValue().toString().equals(this.entity.getClass().toString())) continue;
                selected = en.getKey();
            }
        }
        this.scroll.setSelected(selected);
        if (this.resetToSelected) {
            this.scroll.scrollTo(this.scroll.getSelected());
            this.resetToSelected = false;
        }
        this.addScroll(this.scroll);
    }

    @Override
    public void buttonEvent(GuiButton btn) {
        if (btn.field_146127_k == 10) {
            this.playerdata.setEntityClass(null);
            this.resetToSelected = true;
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        this.playerdata.setEntityClass(this.data.get(scroll.getSelected()));
        EntityLivingBase entity = this.playerdata.getEntity(this.npc);
        if (entity != null) {
            RenderLivingBase render = (RenderLivingBase)this.field_146297_k.func_175598_ae().func_78715_a(entity.getClass());
            if (!NPCRendererHelper.getTexture(render, (Entity)entity).equals("minecraft:missingno")) {
                this.npc.display.setSkinTexture(NPCRendererHelper.getTexture(render, (Entity)entity));
            }
        } else {
            this.npc.display.setSkinTexture("customnpcs:textures/entity/humanmale/steve.png");
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }
}

