/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.net.URI;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiHoverText;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.GuiWrapper;
import noppes.npcs.client.gui.util.IGui;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.EntityNPCInterface;

public abstract class GuiNPCInterface
extends GuiScreen
implements IGuiInterface {
    public EntityPlayerSP player;
    public boolean drawDefaultBackground = true;
    public EntityNPCInterface npc;
    public String title;
    public ResourceLocation background = null;
    public boolean closeOnEsc = true;
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;
    public int mouseX;
    public int mouseY;
    public float bgScale = 1.0f;
    public GuiWrapper wrapper = new GuiWrapper(this);

    public GuiNPCInterface(EntityNPCInterface npc) {
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.npc = npc;
        this.title = "";
        this.xSize = 200;
        this.ySize = 222;
        this.drawDefaultBackground = false;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146296_j = this.field_146297_k.func_175599_af();
        this.field_146289_q = this.field_146297_k.field_71466_p;
    }

    public GuiNPCInterface() {
        this(null);
    }

    public void setBackground(String texture) {
        this.background = new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.field_195124_j.clear();
        this.wrapper.init(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.field_146297_k.field_195559_v.func_197967_a(true);
    }

    public void func_73876_c() {
        this.wrapper.tick();
    }

    @Override
    public void buttonEvent(GuiButton guibutton) {
    }

    public boolean mouseScrolled(double scrolled) {
        if (this.wrapper.mouseScrolled(scrolled)) {
            return true;
        }
        return super.mouseScrolled(scrolled);
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (this.wrapper.mouseClicked(i, j, k)) {
            return true;
        }
        return super.mouseClicked(i, j, k);
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (this.wrapper.mouseDragged(x, y, button, dx, dy)) {
            return true;
        }
        return super.mouseDragged(x, y, button, dx, dy);
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.wrapper.mouseReleased(x, y, button)) {
            return true;
        }
        return super.mouseReleased(x, y, button);
    }

    public void elementClicked() {
        if (this.wrapper.subgui != null) {
            this.wrapper.subgui.elementClicked();
        }
    }

    public boolean charTyped(char c, int i) {
        return this.wrapper.charTyped(c, i);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.wrapper.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean isInventoryKey(int i) {
        return this.field_146297_k.field_71474_y.field_151445_Q.getKey().func_197937_c() == i;
    }

    public boolean func_195120_Y_() {
        return this.closeOnEsc;
    }

    public void func_146281_b() {
        this.field_146297_k.field_195559_v.func_197967_a(false);
        GuiNpcTextField.unfocus();
    }

    public void func_195122_V_() {
        this.displayGuiScreen(null);
        this.field_146297_k.field_71417_B.func_198034_i();
        this.save();
    }

    @Override
    public void closeGui() {
        this.func_195122_V_();
    }

    public void addExtra(GuiHoverText gui) {
        this.wrapper.addExtra(gui);
    }

    public void addButton(GuiNpcButton button) {
        this.wrapper.npcbuttons.put(button.field_146127_k, button);
        super.func_189646_b((GuiButton)button);
    }

    public void addTopButton(GuiMenuTopButton button) {
        this.wrapper.topbuttons.put(button.field_146127_k, button);
        super.func_189646_b((GuiButton)button);
    }

    public void addSideButton(GuiMenuSideButton button) {
        this.wrapper.sidebuttons.put(button.field_146127_k, button);
        super.func_189646_b((GuiButton)button);
    }

    public GuiNpcButton getButton(int i) {
        return this.wrapper.npcbuttons.get(i);
    }

    public GuiMenuSideButton getSideButton(int i) {
        return this.wrapper.sidebuttons.get(i);
    }

    public GuiMenuTopButton getTopButton(int i) {
        return this.wrapper.topbuttons.get(i);
    }

    public void addTextField(GuiNpcTextField tf) {
        this.wrapper.textfields.put(tf.field_175208_g, tf);
    }

    public GuiNpcTextField getTextField(int i) {
        return this.wrapper.textfields.get(i);
    }

    public void add(IGui gui) {
        this.wrapper.components.add(gui);
    }

    public IGui get(int id) {
        for (IGui comp : this.wrapper.components) {
            if (comp.getID() != id) continue;
            return comp;
        }
        return null;
    }

    public void addLabel(GuiNpcLabel label) {
        this.wrapper.labels.put(label.id, label);
    }

    public GuiNpcLabel getLabel(int i) {
        return this.wrapper.labels.get(i);
    }

    public void addSlider(GuiNpcSlider slider) {
        this.wrapper.sliders.put(slider.field_146127_k, slider);
        this.field_146292_n.add(slider);
        this.field_195124_j.add(slider);
    }

    public GuiNpcSlider getSlider(int i) {
        return this.wrapper.sliders.get(i);
    }

    public void addScroll(GuiCustomScroll scroll) {
        scroll.func_146280_a(this.field_146297_k, 350, 250);
        this.wrapper.scrolls.put(scroll.id, scroll);
    }

    public GuiCustomScroll getScroll(int id) {
        return this.wrapper.scrolls.get(id);
    }

    @Override
    public void save() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int x = mouseX;
        int y = mouseY;
        if (this.wrapper.subgui != null) {
            y = 0;
            x = 0;
        }
        if (this.drawDefaultBackground && this.wrapper.subgui == null) {
            this.func_146276_q_();
        }
        if (this.background != null && this.field_146297_k.func_110434_K() != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            GlStateManager.func_179152_a((float)this.bgScale, (float)this.bgScale, (float)this.bgScale);
            this.field_146297_k.func_110434_K().func_110577_a(this.background);
            if (this.xSize > 256) {
                this.func_73729_b(0, 0, 0, 0, 250, this.ySize);
                this.func_73729_b(250, 0, 256 - (this.xSize - 250), 0, this.xSize - 250, this.ySize);
            } else {
                this.func_73729_b(0, 0, 0, 0, this.xSize, this.ySize);
            }
            GlStateManager.func_179121_F();
        }
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        for (GuiNpcLabel label : new ArrayList<GuiNpcLabel>(this.wrapper.labels.values())) {
            label.drawLabel(this, this.field_146289_q);
        }
        for (GuiNpcTextField tf : new ArrayList<GuiNpcTextField>(this.wrapper.textfields.values())) {
            tf.func_195608_a(x, y, partialTicks);
        }
        for (IGui comp : new ArrayList<IGui>(this.wrapper.components)) {
            comp.render(x, y);
        }
        for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.wrapper.scrolls.values())) {
            scroll.func_73863_a(x, y, partialTicks);
        }
        for (GuiScreen gui : new ArrayList<GuiScreen>(this.wrapper.extra.values())) {
            gui.func_73863_a(x, y, partialTicks);
        }
        super.func_73863_a(x, y, partialTicks);
        if (this.wrapper.subgui != null) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)60.0f);
            this.wrapper.subgui.func_73863_a(mouseX, mouseY, partialTicks);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-60.0f);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void doubleClicked() {
    }

    public void func_146276_q_() {
        super.func_146276_q_();
    }

    public void displayGuiScreen(GuiScreen gui) {
        this.field_146297_k.func_147108_a(gui);
    }

    public void setSubGui(SubGuiInterface gui) {
        this.wrapper.subgui = gui;
        this.wrapper.subgui.npc = this.npc;
        this.wrapper.subgui.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.wrapper.subgui.parent = this;
        this.func_73866_w_();
    }

    public void closeSubGui(SubGuiInterface gui) {
        this.wrapper.subgui = null;
    }

    @Override
    public boolean hasSubGui() {
        return this.wrapper.subgui != null;
    }

    public SubGuiInterface getSubGui() {
        if (this.hasSubGui() && this.wrapper.subgui.hasSubGui()) {
            return this.wrapper.subgui.getSubGui();
        }
        return this.wrapper.subgui;
    }

    public void drawNpc(int x, int y) {
        this.drawNpc((EntityLivingBase)this.npc, x, y, 1.0f, 0);
    }

    public void drawNpc(EntityLivingBase entity, int x, int y, float zoomed, int rotation) {
        EntityNPCInterface npc = null;
        if (entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)entity;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.guiLeft + x), (float)(this.guiTop + y), (float)50.0f);
        float scale = 1.0f;
        if ((double)entity.field_70131_O > 2.4) {
            scale = 2.0f / entity.field_70131_O;
        }
        GlStateManager.func_179152_a((float)(-30.0f * scale * zoomed), (float)(30.0f * scale * zoomed), (float)(30.0f * scale * zoomed));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f7 = entity.field_70759_as;
        float f5 = (float)(this.guiLeft + x) - (float)this.mouseX;
        float f6 = (float)(this.guiTop + y) - 50.0f * scale * zoomed - (float)this.mouseY;
        int orientation = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = rotation;
        }
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(f6 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70761_aq = rotation;
        entity.field_70177_z = (float)Math.atan(f5 / 80.0f) * 40.0f + (float)rotation;
        entity.field_70125_A = -((float)Math.atan(f6 / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        this.field_146297_k.func_175598_ae().func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        entity.field_70760_ar = entity.field_70761_aq = f2;
        entity.field_70126_B = entity.field_70177_z = f3;
        entity.field_70127_C = entity.field_70125_A = f4;
        entity.field_70758_at = entity.field_70759_as = f7;
        if (npc != null) {
            npc.ais.orientation = orientation;
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void openLink(String link) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(link));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

