/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketMenuClose;
import noppes.npcs.packets.server.SPacketNpcDelete;

public class GuiNpcMenu
implements GuiYesNoCallback {
    private IGuiInterface parent;
    private GuiMenuTopButton[] topButtons = new GuiMenuTopButton[0];
    private int activeMenu;
    private EntityNPCInterface npc;

    public GuiNpcMenu(IGuiInterface parent, int activeMenu, EntityNPCInterface npc) {
        this.parent = parent;
        this.activeMenu = activeMenu;
        this.npc = npc;
    }

    public void initGui(int guiLeft, int guiTop, int width) {
        final Minecraft mc = Minecraft.func_71410_x();
        mc.field_195559_v.func_197967_a(true);
        GuiMenuTopButton display = new GuiMenuTopButton(this.parent, 1, guiLeft + 4, guiTop - 17, "menu.display"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 1;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuDisplay);
            }
        };
        GuiMenuTopButton stats = new GuiMenuTopButton(this.parent, 2, display.field_146128_h + display.func_146117_b(), guiTop - 17, "menu.stats"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 2;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuStats);
            }
        };
        GuiMenuTopButton ai = new GuiMenuTopButton(this.parent, 3, stats.field_146128_h + stats.func_146117_b(), guiTop - 17, "menu.ai"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 3;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuAI);
            }
        };
        GuiMenuTopButton inv = new GuiMenuTopButton(this.parent, 4, ai.field_146128_h + ai.func_146117_b(), guiTop - 17, "menu.inventory"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 4;
                NoppesUtil.requestOpenGUI(EnumGuiType.MainMenuInv);
            }
        };
        GuiMenuTopButton advanced = new GuiMenuTopButton(this.parent, 5, inv.field_146128_h + inv.func_146117_b(), guiTop - 17, "menu.advanced"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 5;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuAdvanced);
            }
        };
        GuiMenuTopButton global = new GuiMenuTopButton(this.parent, 6, advanced.field_146128_h + advanced.func_146117_b(), guiTop - 17, "menu.global"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.save();
                GuiNpcMenu.this.activeMenu = 6;
                CustomNpcs.proxy.openGui(GuiNpcMenu.this.npc, EnumGuiType.MainMenuGlobal);
            }
        };
        GuiMenuTopButton close = new GuiMenuTopButton(this.parent, 0, guiLeft + width - 22, guiTop - 17, "X"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiNpcMenu.this.close();
            }
        };
        GuiMenuTopButton delete = new GuiMenuTopButton(this.parent, 66, guiLeft + width - 72, guiTop - 17, "selectWorld.deleteButton"){

            @Override
            public void func_194829_a(double x, double y) {
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)GuiNpcMenu.this, "", I18n.func_135052_a((String)"gui.deleteMessage", (Object[])new Object[0]), 0);
                mc.func_147108_a((GuiScreen)guiyesno);
            }
        };
        delete.field_146128_h = close.field_146128_h - delete.func_146117_b();
        for (GuiMenuTopButton button : this.topButtons = new GuiMenuTopButton[]{display, stats, ai, inv, advanced, global, close, delete}) {
            button.active = button.field_146127_k == this.activeMenu;
        }
    }

    private void save() {
        GuiNpcTextField.unfocus();
        this.parent.save();
    }

    private void close() {
        this.parent.closeGui();
        if (this.npc != null) {
            this.npc.reset();
            Packets.sendServer(new SPacketMenuClose());
        }
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (k == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            for (GuiMenuTopButton button : this.topButtons) {
                if (!button.mouseClicked(i, j, k)) continue;
                return true;
            }
        }
        return false;
    }

    public void drawElements(FontRenderer fontRenderer, int i, int j, Minecraft mc, float f) {
        for (GuiMenuTopButton button : this.topButtons) {
            button.func_194828_a(i, j, f);
        }
    }

    public void confirmResult(boolean flag, int i) {
        Minecraft mc = Minecraft.func_71410_x();
        if (flag) {
            Packets.sendServer(new SPacketNpcDelete());
            mc.func_147108_a(null);
            mc.field_71417_B.func_198034_i();
        } else {
            NoppesUtil.openGUI((EntityPlayer)mc.field_71439_g, this.parent);
        }
    }
}

