/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import noppes.npcs.client.gui.util.ITextfieldListener;

public class GuiNpcTextField
extends GuiTextField {
    public boolean enabled = true;
    public boolean inMenu = true;
    public boolean numbersOnly = false;
    private ITextfieldListener listener;
    public int min = 0;
    public int max = Integer.MAX_VALUE;
    public int def = 0;
    private static GuiNpcTextField activeTextfield = null;
    public boolean canEdit = true;
    private final int[] allowedSpecialChars = new int[]{14, 211, 203, 205};

    public GuiNpcTextField(int id, GuiScreen parent, FontRenderer fontRenderer, int i, int j, int k, int l, String s) {
        super(id, fontRenderer, i, j, k, l);
        this.func_146203_f(500);
        this.func_146180_a(s == null ? "" : s);
        if (parent instanceof ITextfieldListener) {
            this.listener = (ITextfieldListener)parent;
        }
    }

    public static boolean isActive() {
        return activeTextfield != null;
    }

    public GuiNpcTextField(int id, GuiScreen parent, int i, int j, int k, int l, String s) {
        this(id, parent, Minecraft.func_71410_x().field_71466_p, i, j, k, l, s);
    }

    private boolean charAllowed(char c, int i) {
        if (!this.numbersOnly || Character.isDigit(c) || c == '-' && this.func_146179_b().length() == 0) {
            return true;
        }
        for (int j : this.allowedSpecialChars) {
            if (j != i) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char c, int i) {
        if (!this.charAllowed(c, i) || !this.canEdit) {
            return false;
        }
        return super.charTyped(c, i);
    }

    public boolean isEmpty() {
        return this.func_146179_b().trim().length() == 0;
    }

    public int getInt() {
        return Integer.parseInt(this.func_146179_b());
    }

    public boolean isInteger() {
        try {
            Integer.parseInt(this.func_146179_b());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void func_146195_b(boolean focus) {
        if (focus && !this.field_146213_o) {
            GuiNpcTextField.unfocus();
            activeTextfield = this;
        }
        super.func_146195_b(focus);
    }

    public void unFocused() {
        if (this.numbersOnly) {
            if (this.isEmpty() || !this.isInteger()) {
                this.func_146180_a(this.def + "");
            } else if (this.getInt() < this.min) {
                this.func_146180_a(this.min + "");
            } else if (this.getInt() > this.max) {
                this.func_146180_a(this.max + "");
            }
        }
        this.field_146213_o = false;
        if (this.listener != null) {
            this.listener.unFocused(this);
        }
        if (this == activeTextfield) {
            activeTextfield = null;
        }
    }

    public void func_195608_a(int x, int y, float partialTick) {
        if (this.enabled) {
            super.func_195608_a(x, y, partialTick);
        }
    }

    public void setMinMaxDefault(int i, int j, int k) {
        this.min = i;
        this.max = j;
        this.def = k;
    }

    public static void unfocus() {
        GuiNpcTextField prev = activeTextfield;
        activeTextfield = null;
        if (prev != null) {
            prev.unFocused();
        }
    }

    public GuiNpcTextField setNumbersOnly() {
        this.numbersOnly = true;
        return this;
    }
}

