/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiHoverText;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGui;
import noppes.npcs.client.gui.util.IKeyListener;
import noppes.npcs.client.gui.util.IMouseListener;
import noppes.npcs.client.gui.util.SubGuiInterface;

public class GuiWrapper {
    public Map<Integer, GuiNpcButton> npcbuttons = new ConcurrentHashMap<Integer, GuiNpcButton>();
    public Map<Integer, GuiMenuTopButton> topbuttons = new ConcurrentHashMap<Integer, GuiMenuTopButton>();
    public Map<Integer, GuiMenuSideButton> sidebuttons = new ConcurrentHashMap<Integer, GuiMenuSideButton>();
    public Map<Integer, GuiNpcTextField> textfields = new ConcurrentHashMap<Integer, GuiNpcTextField>();
    public Map<Integer, GuiNpcLabel> labels = new ConcurrentHashMap<Integer, GuiNpcLabel>();
    public Map<Integer, GuiCustomScroll> scrolls = new ConcurrentHashMap<Integer, GuiCustomScroll>();
    public Map<Integer, GuiNpcSlider> sliders = new ConcurrentHashMap<Integer, GuiNpcSlider>();
    public Map<Integer, GuiScreen> extra = new ConcurrentHashMap<Integer, GuiScreen>();
    public List<IGui> components = new ArrayList<IGui>();
    public GuiScreen gui;
    public SubGuiInterface subgui;

    public GuiWrapper(GuiScreen gui) {
        this.gui = gui;
    }

    public void init(Minecraft mc, int width, int height) {
        GuiNpcTextField.unfocus();
        if (this.subgui != null) {
            this.subgui.func_146280_a(mc, width, height);
        }
        this.npcbuttons = new ConcurrentHashMap<Integer, GuiNpcButton>();
        this.topbuttons = new ConcurrentHashMap<Integer, GuiMenuTopButton>();
        this.sidebuttons = new ConcurrentHashMap<Integer, GuiMenuSideButton>();
        this.textfields = new ConcurrentHashMap<Integer, GuiNpcTextField>();
        this.labels = new ConcurrentHashMap<Integer, GuiNpcLabel>();
        this.scrolls = new ConcurrentHashMap<Integer, GuiCustomScroll>();
        this.sliders = new ConcurrentHashMap<Integer, GuiNpcSlider>();
        this.extra = new ConcurrentHashMap<Integer, GuiScreen>();
        this.components = new ArrayList<IGui>();
    }

    public void tick() {
        if (this.subgui != null) {
            this.subgui.func_73876_c();
        } else {
            for (GuiNpcTextField tf : new ArrayList<GuiNpcTextField>(this.textfields.values())) {
                if (!tf.enabled) continue;
                tf.func_146178_a();
            }
            for (IGui comp : new ArrayList<IGui>(this.components)) {
                comp.tick();
            }
        }
    }

    public void addExtra(GuiHoverText gui) {
        gui.func_146280_a(Minecraft.func_71410_x(), 350, 250);
        this.extra.put(gui.id, gui);
    }

    public boolean mouseScrolled(double scrolled) {
        if (this.subgui != null) {
            return this.subgui.mouseScrolled(scrolled);
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IMouseListener) || !comp.isActive() || !((IMouseListener)((Object)comp)).mouseScrolled(scrolled)) continue;
            return true;
        }
        for (GuiCustomScroll scroll : this.scrolls.values()) {
            if (!scroll.visible || !scroll.mouseScrolled(scrolled)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (this.subgui != null) {
            return this.subgui.mouseClicked(i, j, k);
        }
        for (GuiNpcTextField tf : new ArrayList<GuiNpcTextField>(this.textfields.values())) {
            if (!tf.enabled || !tf.mouseClicked(i, j, k)) continue;
            return true;
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IMouseListener) || !((IMouseListener)((Object)comp)).mouseClicked(i, j, k)) continue;
            return true;
        }
        if (k == 0) {
            for (GuiCustomScroll scroll : new ArrayList<GuiCustomScroll>(this.scrolls.values())) {
                if (!scroll.mouseClicked(i, j, k)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (this.subgui != null) {
            return this.subgui.mouseDragged(x, y, button, dx, dy);
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.subgui != null) {
            return this.subgui.mouseReleased(x, y, button);
        }
        return false;
    }

    public boolean charTyped(char c, int i) {
        if (this.subgui != null) {
            return this.subgui.charTyped(c, i);
        }
        for (GuiNpcTextField tf : new ArrayList<GuiNpcTextField>(this.textfields.values())) {
            tf.charTyped(c, i);
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IKeyListener)) continue;
            ((IKeyListener)((Object)comp)).charTyped(c, i);
        }
        return true;
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.subgui != null) {
            return this.subgui.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        boolean active = GuiNpcTextField.isActive();
        for (IGui gui : this.components) {
            if (!gui.isActive()) continue;
            active = true;
            break;
        }
        if (this.gui.func_195120_Y_() && (key == 256 || !active && Minecraft.func_71410_x().field_71474_y.field_151445_Q.getKey().func_197937_c() == key)) {
            this.gui.func_195122_V_();
            return true;
        }
        for (GuiNpcTextField tf : this.textfields.values()) {
            tf.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        for (IGui comp : new ArrayList<IGui>(this.components)) {
            if (!(comp instanceof IKeyListener)) continue;
            ((IKeyListener)((Object)comp)).keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
        }
        return false;
    }
}

