/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.SplashProgress;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class CTextureUtil {
    private static final IntBuffer DATA_BUFFER = GLAllocation.func_74524_c((int)0x1000000).asIntBuffer();
    private static final float[] COLOR_GAMMAS = new float[256];

    public static void deleteTexture(int textureId) {
        GlStateManager.func_179150_h((int)textureId);
    }

    public static int uploadTextureImage(int textureId, BufferedImage texture) {
        return CTextureUtil.uploadTextureImageAllocate(textureId, texture, false, false);
    }

    public static int uploadTextureImageAllocate(int textureId, BufferedImage texture, boolean blur, boolean clamp) {
        CTextureUtil.allocateTexture(textureId, texture.getWidth(), texture.getHeight());
        return CTextureUtil.uploadTextureImageSub(textureId, texture, 0, 0, blur, clamp);
    }

    public static void allocateTexture(int textureId, int width, int height) {
        CTextureUtil.allocateTextureImpl(textureId, 0, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allocateTextureImpl(int glTextureId, int mipmapLevels, int width, int height) {
        Class<SplashProgress> clazz = SplashProgress.class;
        synchronized (SplashProgress.class) {
            CTextureUtil.deleteTexture(glTextureId);
            CTextureUtil.bindTexture(glTextureId);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (mipmapLevels >= 0) {
                GlStateManager.func_187421_b((int)3553, (int)33085, (int)mipmapLevels);
                GlStateManager.func_187421_b((int)3553, (int)33082, (int)0);
                GlStateManager.func_187421_b((int)3553, (int)33083, (int)mipmapLevels);
                GlStateManager.func_187403_b((int)3553, (int)34049, (float)0.0f);
            }
            for (int i = 0; i <= mipmapLevels; ++i) {
                GlStateManager.func_187419_a((int)3553, (int)i, (int)6408, (int)(width >> i), (int)(height >> i), (int)0, (int)32993, (int)33639, (IntBuffer)null);
            }
            return;
        }
    }

    public static int uploadTextureImageSub(int textureId, BufferedImage p_110995_1_, int p_110995_2_, int p_110995_3_, boolean p_110995_4_, boolean p_110995_5_) {
        CTextureUtil.bindTexture(textureId);
        CTextureUtil.uploadTextureImageSubImpl(p_110995_1_, p_110995_2_, p_110995_3_, p_110995_4_, p_110995_5_);
        return textureId;
    }

    private static void uploadTextureImageSubImpl(BufferedImage p_110993_0_, int p_110993_1_, int p_110993_2_, boolean p_110993_3_, boolean p_110993_4_) {
        int i = p_110993_0_.getWidth();
        int j = p_110993_0_.getHeight();
        int k = 0x400000 / i;
        int[] aint = new int[k * i];
        CTextureUtil.setTextureBlurred(p_110993_3_);
        CTextureUtil.setTextureClamped(p_110993_4_);
        for (int l = 0; l < i * j; l += i * k) {
            int i1 = l / i;
            int j1 = Math.min(k, j - i1);
            int k1 = i * j1;
            p_110993_0_.getRGB(0, i1, i, j1, aint, 0, i);
            CTextureUtil.copyToBuffer(aint, k1);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)p_110993_1_, (int)(p_110993_2_ + i1), (int)i, (int)j1, (int)32993, (int)33639, (IntBuffer)DATA_BUFFER);
        }
    }

    private static void setTextureClamped(boolean p_110997_0_) {
        if (p_110997_0_) {
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10496);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10496);
        } else {
            GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
            GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        }
    }

    private static void setTextureBlurred(boolean p_147951_0_) {
        CTextureUtil.setTextureBlurMipmap(p_147951_0_, false);
    }

    private static void setTextureBlurMipmap(boolean p_147954_0_, boolean p_147954_1_) {
        if (p_147954_0_) {
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)(p_147954_1_ ? 9987 : 9729));
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        } else {
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)(p_147954_1_ ? 9986 : 9728));
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    }

    private static void copyToBuffer(int[] p_110990_0_, int p_110990_1_) {
        CTextureUtil.copyToBufferPos(p_110990_0_, 0, p_110990_1_);
    }

    private static void copyToBufferPos(int[] p_110994_0_, int p_110994_1_, int p_110994_2_) {
        int[] aint = p_110994_0_;
        DATA_BUFFER.clear();
        DATA_BUFFER.put(aint, p_110994_1_, p_110994_2_);
        DATA_BUFFER.position(0).limit(p_110994_2_);
    }

    static void bindTexture(int p_94277_0_) {
        GlStateManager.func_179144_i((int)p_94277_0_);
    }

    public static int[] updateAnaglyph(int[] p_110985_0_) {
        int[] aint = new int[p_110985_0_.length];
        for (int i = 0; i < p_110985_0_.length; ++i) {
            aint[i] = CTextureUtil.anaglyphColor(p_110985_0_[i]);
        }
        return aint;
    }

    public static int anaglyphColor(int p_177054_0_) {
        int i = p_177054_0_ >> 24 & 0xFF;
        int j = p_177054_0_ >> 16 & 0xFF;
        int k = p_177054_0_ >> 8 & 0xFF;
        int l = p_177054_0_ & 0xFF;
        int i1 = (j * 30 + k * 59 + l * 11) / 100;
        int j1 = (j * 30 + k * 70) / 100;
        int k1 = (j * 30 + l * 70) / 100;
        return i << 24 | i1 << 16 | j1 << 8 | k1;
    }

    static {
        for (int i1 = 0; i1 < COLOR_GAMMAS.length; ++i1) {
            CTextureUtil.COLOR_GAMMAS[i1] = (float)Math.pow((float)i1 / 255.0f, 2.2);
        }
    }
}

