/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ImageDownloadAlt
extends SimpleTexture {
    private static final Logger logger = LogManager.getLogger();
    private static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    private final File cacheFile;
    private final String imageUrl;
    private final IImageBuffer imageBuffer;
    private NativeImage image;
    private Thread imageThread;
    private boolean textureUploaded;

    public ImageDownloadAlt(File file, String url, ResourceLocation resource, IImageBuffer buffer) {
        super(resource);
        this.cacheFile = file;
        this.imageUrl = url;
        this.imageBuffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(NativeImage image) {
        this.image = image;
        if (this.imageBuffer != null) {
            this.imageBuffer.func_152634_a();
        }
        ImageDownloadAlt imageDownloadAlt = this;
        synchronized (imageDownloadAlt) {
            this.uploadImage(image);
            this.textureUploaded = true;
        }
    }

    private void uploadImage(NativeImage image) {
        TextureUtil.func_110991_a((int)this.func_110552_b(), (int)image.func_195702_a(), (int)image.func_195714_b());
        image.func_195697_a(0, 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(IResourceManager resourceManager) throws IOException {
        if (!this.textureUploaded) {
            ImageDownloadAlt imageDownloadAlt = this;
            synchronized (imageDownloadAlt) {
                super.func_195413_a(resourceManager);
                this.textureUploaded = true;
            }
        }
        if (this.imageThread == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                logger.debug("Loading http texture from local cache ({})", new Object[]{this.cacheFile});
                try {
                    this.image = NativeImage.func_195713_a((InputStream)new FileInputStream(this.cacheFile));
                    if (this.imageBuffer != null) {
                        this.setImage(this.imageBuffer.func_195786_a(this.image));
                    }
                }
                catch (IOException ioexception) {
                    logger.error("Couldn't load skin " + this.cacheFile, (Throwable)ioexception);
                    this.loadTextureFromServer();
                }
            } else {
                this.loadTextureFromServer();
            }
        }
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Texture Downloader #" + threadDownloadCounter.incrementAndGet()){
            private static final String __OBFID = "CL_00001050";

            @Override
            public void run() {
                HttpURLConnection connection = null;
                logger.debug("Downloading http texture from {} to {}", new Object[]{ImageDownloadAlt.this.imageUrl, ImageDownloadAlt.this.cacheFile});
                try {
                    InputStream inputstream;
                    connection = (HttpURLConnection)new URL(ImageDownloadAlt.this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                    connection.setDoInput(true);
                    connection.setDoOutput(false);
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1; rv:19.0) Gecko/20100101 Firefox/19.0");
                    connection.connect();
                    if (connection.getResponseCode() / 100 != 2) {
                        return;
                    }
                    if (ImageDownloadAlt.this.cacheFile != null) {
                        FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)ImageDownloadAlt.this.cacheFile);
                        inputstream = new FileInputStream(ImageDownloadAlt.this.cacheFile);
                    } else {
                        inputstream = connection.getInputStream();
                    }
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        NativeImage nativeimage = null;
                        try {
                            nativeimage = NativeImage.func_195713_a((InputStream)inputstream);
                            if (ImageDownloadAlt.this.imageBuffer != null) {
                                nativeimage = ImageDownloadAlt.this.imageBuffer.func_195786_a(nativeimage);
                            }
                            NativeImage nativeimage_f = nativeimage;
                            Minecraft.func_71410_x().func_152344_a(() -> ImageDownloadAlt.this.setImage(nativeimage_f));
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (nativeimage != null) {
                                nativeimage.close();
                            }
                            IOUtils.closeQuietly((InputStream)inputstream);
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    logger.error("Couldn't download http texture", (Throwable)exception);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }
}

