/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityDialogNpc;

public class CmdDialog {
    public static LiteralArgumentBuilder<CommandSource> register() {
        LiteralArgumentBuilder command = Commands.func_197057_a((String)"dialog");
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").requires(source -> source.func_197034_c(4))).executes(context -> {
            new DialogController().load();
            SyncController.syncAllDialogs();
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"read").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"dialog", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Dialog dialog = DialogController.instance.dialogs.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"dialog"));
            if (dialog == null) {
                throw new CommandException((ITextComponent)new TextComponentString("Unknown DialogID"));
            }
            for (EntityPlayerMP player : players) {
                PlayerData data = PlayerData.get((EntityPlayer)player);
                if (data.dialogData.dialogsRead.contains(dialog.id)) continue;
                data.dialogData.dialogsRead.add(dialog.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unread").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"dialog", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Dialog dialog = DialogController.instance.dialogs.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"dialog"));
            if (dialog == null) {
                throw new CommandException((ITextComponent)new TextComponentString("Unknown DialogID"));
            }
            for (EntityPlayerMP player : players) {
                PlayerData data = PlayerData.get((EntityPlayer)player);
                if (!data.dialogData.dialogsRead.contains(dialog.id)) continue;
                data.dialogData.dialogsRead.remove(dialog.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"show").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"dialog", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Dialog dialog = DialogController.instance.dialogs.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"dialog"));
            if (dialog == null) {
                throw new CommandException((ITextComponent)new TextComponentString("Unknown DialogID"));
            }
            EntityDialogNpc npc = new EntityDialogNpc((World)((CommandSource)context.getSource()).func_197023_e());
            DialogOption option = new DialogOption();
            option.dialogId = dialog.id;
            option.title = dialog.title;
            npc.dialogs.put(0, option);
            npc.display.setName(StringArgumentType.getString((CommandContext)context, (String)"name"));
            for (EntityPlayerMP player : players) {
                EntityUtil.Copy((EntityLivingBase)player, (EntityLivingBase)npc);
                NoppesUtilServer.openDialog((EntityPlayer)player, npc, dialog);
            }
            return 1;
        })))));
        return command;
    }
}

