/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.EventHooks;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.WorldEvent;
import noppes.npcs.controllers.ScriptController;

public class CmdScript {
    public static LiteralArgumentBuilder<CommandSource> register() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"script").requires(source -> source.func_197034_c(4))).then(Commands.func_197057_a((String)"reload").executes(context -> {
            ScriptController.Instance.loadCategories();
            if (ScriptController.Instance.loadPlayerScripts()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString("Reload player scripts succesfully"), false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString("Failed reloading player scripts"), false);
            }
            if (ScriptController.Instance.loadForgeScripts()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString("Reload forge scripts succesfully"), false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString("Failed reloading forge scripts"), false);
            }
            if (ScriptController.Instance.loadStoredData()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString("Reload stored data succesfully"), false);
            } else {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TextComponentString("Failed reloading stored data"), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"run").executes(context -> {
            IWorld world = NpcAPI.Instance().getIWorld(((CommandSource)context.getSource()).func_197023_e());
            Vec3d bpos = ((CommandSource)context.getSource()).func_197036_d();
            IPos pos = NpcAPI.Instance().getIPos(bpos.field_72450_a, bpos.field_72448_b, bpos.field_72449_c);
            WorldEvent.ScriptCommandEvent event = new WorldEvent.ScriptCommandEvent(world, pos, new String[0]);
            EventHooks.onWorldScriptEvent(event);
            return 1;
        })).then(Commands.func_197056_a((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            IWorld world = NpcAPI.Instance().getIWorld(((CommandSource)context.getSource()).func_197023_e());
            Vec3d bpos = ((CommandSource)context.getSource()).func_197036_d();
            IPos pos = NpcAPI.Instance().getIPos(bpos.field_72450_a, bpos.field_72448_b, bpos.field_72449_c);
            WorldEvent.ScriptCommandEvent event = new WorldEvent.ScriptCommandEvent(world, pos, StringArgumentType.getString((CommandContext)context, (String)"args").split(" "));
            EventHooks.onWorldScriptEvent(event);
            return 1;
        })));
        return command;
    }
}

