/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSync;

public class SyncController {
    public static void syncPlayer(EntityPlayerMP player) {
        NBTTagList list = new NBTTagList();
        for (Faction faction : FactionController.instance.factions.values()) {
            list.add((INBTBase)faction.writeNBT(new NBTTagCompound()));
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Data", (INBTBase)list);
        Packets.send(player, new PacketSync(1, compound, true));
        for (QuestCategory questCategory : QuestController.instance.categories.values()) {
            Packets.send(player, new PacketSync(3, questCategory.writeNBT(new NBTTagCompound()), false));
        }
        Packets.send(player, new PacketSync(3, new NBTTagCompound(), true));
        for (DialogCategory dialogCategory : DialogController.instance.categories.values()) {
            Packets.send(player, new PacketSync(5, dialogCategory.writeNBT(new NBTTagCompound()), false));
        }
        Packets.send(player, new PacketSync(5, new NBTTagCompound(), true));
        list = new NBTTagList();
        for (RecipeCarpentry recipeCarpentry : RecipeController.instance.globalRecipes.values()) {
            list.add((INBTBase)recipeCarpentry.writeNBT());
            if (list.size() <= 10) continue;
            compound = new NBTTagCompound();
            compound.func_74782_a("Data", (INBTBase)list);
            Packets.send(player, new PacketSync(6, compound, false));
            list = new NBTTagList();
        }
        compound = new NBTTagCompound();
        compound.func_74782_a("Data", (INBTBase)list);
        Packets.send(player, new PacketSync(6, compound, true));
        list = new NBTTagList();
        for (RecipeCarpentry recipeCarpentry : RecipeController.instance.anvilRecipes.values()) {
            list.add((INBTBase)recipeCarpentry.writeNBT());
            if (list.size() <= 10) continue;
            compound = new NBTTagCompound();
            compound.func_74782_a("Data", (INBTBase)list);
            Packets.send(player, new PacketSync(7, compound, false));
            list = new NBTTagList();
        }
        compound = new NBTTagCompound();
        compound.func_74782_a("Data", (INBTBase)list);
        Packets.send(player, new PacketSync(7, compound, true));
        PlayerData playerData = PlayerData.get((EntityPlayer)player);
        Packets.send(player, new PacketSync(8, playerData.getNBT(), true));
        SyncController.syncScriptItems(player);
    }

    public static void syncAllDialogs() {
        for (DialogCategory category : DialogController.instance.categories.values()) {
            Packets.sendAll(new PacketSync(5, category.writeNBT(new NBTTagCompound()), false));
        }
        Packets.sendAll(new PacketSync(5, new NBTTagCompound(), true));
    }

    public static void syncAllQuests() {
        for (QuestCategory category : QuestController.instance.categories.values()) {
            Packets.sendAll(new PacketSync(3, category.writeNBT(new NBTTagCompound()), false));
        }
        Packets.sendAll(new PacketSync(3, new NBTTagCompound(), true));
    }

    public static void syncScriptItems(EntityPlayerMP player) {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74782_a("List", NBTTags.nbtIntegerStringMap(ItemScripted.Resources));
        Packets.send(player, new PacketSync(9, comp, true));
    }

    public static void syncScriptItemsEverybody() {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74782_a("List", NBTTags.nbtIntegerStringMap(ItemScripted.Resources));
        for (EntityPlayerMP player : CustomNpcs.Server.func_184103_al().func_181057_v()) {
            Packets.send(player, new PacketSync(9, comp, true));
        }
    }
}

