/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;

public class BlockData {
    public BlockPos pos;
    public IBlockState state;
    public NBTTagCompound tile;
    private ItemStack stack;

    public BlockData(BlockPos pos, IBlockState state, NBTTagCompound tile) {
        this.pos = pos;
        this.state = state;
        this.tile = tile;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("BuildX", this.pos.func_177958_n());
        compound.func_74768_a("BuildY", this.pos.func_177956_o());
        compound.func_74768_a("BuildZ", this.pos.func_177952_p());
        compound.func_74778_a("Block", IRegistry.field_212618_g.func_177774_c((Object)this.state.func_177230_c()).toString());
        if (this.tile != null) {
            compound.func_74782_a("Tile", (INBTBase)this.tile);
        }
        return compound;
    }

    public static BlockData getData(NBTTagCompound compound) {
        BlockPos pos = new BlockPos(compound.func_74762_e("BuildX"), compound.func_74762_e("BuildY"), compound.func_74762_e("BuildZ"));
        Block b = (Block)IRegistry.field_212618_g.func_212608_b(new ResourceLocation(compound.func_74779_i("Block")));
        if (b == null) {
            return null;
        }
        NBTTagCompound tile = null;
        if (compound.func_74764_b("Tile")) {
            tile = compound.func_74775_l("Tile");
        }
        return new BlockData(pos, b.func_176223_P(), tile);
    }

    public ItemStack getStack() {
        if (this.stack == null) {
            this.stack = new ItemStack((IItemProvider)this.state.func_177230_c(), 1);
        }
        return this.stack;
    }
}

