/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.EventHooks;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketAchievement;
import noppes.npcs.packets.client.PacketChat;
import noppes.npcs.quests.QuestInterface;

public class PlayerQuestData {
    public HashMap<Integer, QuestData> activeQuests = new HashMap();
    public HashMap<Integer, Long> finishedQuests = new HashMap();

    public void loadNBTData(NBTTagCompound mainCompound) {
        NBTTagList list2;
        if (mainCompound == null) {
            return;
        }
        NBTTagCompound compound = mainCompound.func_74775_l("QuestData");
        NBTTagList list = compound.func_150295_c("CompletedQuests", 10);
        if (list != null) {
            HashMap<Integer, Long> finishedQuests = new HashMap<Integer, Long>();
            for (int i = 0; i < list.size(); ++i) {
                NBTTagCompound nbttagcompound = list.func_150305_b(i);
                finishedQuests.put(nbttagcompound.func_74762_e("Quest"), nbttagcompound.func_74763_f("Date"));
            }
            this.finishedQuests = finishedQuests;
        }
        if ((list2 = compound.func_150295_c("ActiveQuests", 10)) != null) {
            HashMap<Integer, QuestData> activeQuests = new HashMap<Integer, QuestData>();
            for (int i = 0; i < list2.size(); ++i) {
                NBTTagCompound nbttagcompound = list2.func_150305_b(i);
                int id = nbttagcompound.func_74762_e("Quest");
                Quest quest = QuestController.instance.quests.get(id);
                if (quest == null) continue;
                QuestData data = new QuestData(quest);
                data.readAdditional(nbttagcompound);
                activeQuests.put(id, data);
            }
            this.activeQuests = activeQuests;
        }
    }

    public void saveNBTData(NBTTagCompound maincompound) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int quest : this.finishedQuests.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Quest", quest);
            nbttagcompound.func_74772_a("Date", this.finishedQuests.get(quest).longValue());
            list.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("CompletedQuests", (INBTBase)list);
        NBTTagList list2 = new NBTTagList();
        for (int quest : this.activeQuests.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Quest", quest);
            this.activeQuests.get(quest).writeAdditional(nbttagcompound);
            list2.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("ActiveQuests", (INBTBase)list2);
        maincompound.func_74782_a("QuestData", (INBTBase)compound);
    }

    public QuestData getQuestCompletion(EntityPlayer player, EntityNPCInterface npc) {
        for (QuestData data : this.activeQuests.values()) {
            Quest quest = data.quest;
            if (quest == null || quest.completion != EnumQuestCompletion.Npc || !quest.completerNpc.equals(npc.func_200200_C_()) || !quest.questInterface.isCompleted(player)) continue;
            return data;
        }
        return null;
    }

    public boolean checkQuestCompletion(EntityPlayer player, int type) {
        boolean bo = false;
        for (QuestData data : this.activeQuests.values()) {
            if (data.quest.type != type && type >= 0) continue;
            QuestInterface inter = data.quest.questInterface;
            if (inter.isCompleted(player)) {
                if (data.isCompleted) continue;
                if (!data.quest.complete(player, data)) {
                    Packets.send((EntityPlayerMP)player, new PacketAchievement((ITextComponent)new TextComponentTranslation("quest.completed", new Object[0]), (ITextComponent)new TextComponentTranslation(data.quest.title, new Object[0]), 2));
                    Packets.send((EntityPlayerMP)player, new PacketChat(new TextComponentTranslation("quest.completed", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)new TextComponentTranslation(data.quest.title, new Object[0]))));
                }
                data.isCompleted = true;
                bo = true;
                EventHooks.onQuestFinished(PlayerData.get((EntityPlayer)player).scriptData, data.quest);
                continue;
            }
            data.isCompleted = false;
        }
        return bo;
    }
}

