/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomTabs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.entity.EntityNPCInterface;

public class ItemNpcMovingPath
extends Item {
    public ItemNpcMovingPath() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CustomTabs.tab));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack;
        block5: {
            block4: {
                itemstack = player.func_184586_b(hand);
                if (world.field_72995_K) break block4;
                if (CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.TOOL_PATHER)) break block5;
            }
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        EntityNPCInterface npc = this.getNpc(itemstack, world);
        if (npc != null) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.MovingPath, npc);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        block6: {
            block5: {
                if (context.func_195991_k().field_72995_K) break block5;
                if (CustomNpcsPermissions.hasPermission(context.func_195999_j(), CustomNpcsPermissions.TOOL_PATHER)) break block6;
            }
            return EnumActionResult.FAIL;
        }
        ItemStack stack = context.func_195996_i();
        EntityNPCInterface npc = this.getNpc(stack, context.func_195991_k());
        if (npc == null) {
            return EnumActionResult.PASS;
        }
        List<int[]> list = npc.ais.getMovingPath();
        int[] pos = list.get(list.size() - 1);
        int x = context.func_195995_a().func_177958_n();
        int y = context.func_195995_a().func_177956_o();
        int z = context.func_195995_a().func_177952_p();
        list.add(new int[]{x, y, z});
        double d3 = x - pos[0];
        double d4 = y - pos[1];
        double d5 = z - pos[2];
        double distance = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
        context.func_195999_j().func_145747_a((ITextComponent)new TextComponentString("Added point x:" + x + " y:" + y + " z:" + z + " to npc " + npc.func_200200_C_()));
        if (distance > (double)CustomNpcs.NpcNavRange) {
            context.func_195999_j().func_145747_a((ITextComponent)new TextComponentString("Warning: point is too far away from previous point. Max block walk distance = " + CustomNpcs.NpcNavRange));
        }
        return EnumActionResult.SUCCESS;
    }

    private EntityNPCInterface getNpc(ItemStack item, World world) {
        if (world.field_72995_K || item.func_77978_p() == null) {
            return null;
        }
        Entity entity = world.func_73045_a(item.func_77978_p().func_74762_e("NPCID"));
        if (entity == null || !(entity instanceof EntityNPCInterface)) {
            return null;
        }
        return (EntityNPCInterface)entity;
    }
}

