/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IItemProvider;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomTabs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;

public class ItemSoulstoneEmpty
extends Item {
    public ItemSoulstoneEmpty() {
        super(new Item.Properties().func_200917_a(64).func_200916_a(CustomTabs.tab));
    }

    public boolean store(EntityLivingBase entity, ItemStack stack, EntityPlayer player) {
        if (!this.hasPermission(entity, player) || entity instanceof EntityPlayer) {
            return false;
        }
        ItemStack stone = new ItemStack((IItemProvider)CustomItems.soulstoneFull);
        NBTTagCompound compound = new NBTTagCompound();
        if (!entity.func_184198_c(compound)) {
            return false;
        }
        ServerCloneController.Instance.cleanTags(compound);
        stone.func_77983_a("Entity", (INBTBase)compound);
        String name = entity.func_70022_Q();
        if (name == null) {
            name = "generic";
        }
        stone.func_77983_a("Name", (INBTBase)new NBTTagString("entity." + name + ".name"));
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            stone.func_77983_a("DisplayName", (INBTBase)new NBTTagString(entity.func_200200_C_().func_150261_e()));
            if (npc.advanced.role == 6) {
                RoleCompanion role = (RoleCompanion)npc.roleInterface;
                stone.func_77983_a("ExtraText", (INBTBase)new NBTTagString("companion.stage,: ," + role.stage.name));
            }
        } else if (entity.func_145818_k_()) {
            stone.func_77983_a("DisplayName", (INBTBase)new NBTTagString(entity.func_200201_e().func_150261_e()));
        }
        NoppesUtilServer.GivePlayerItem((Entity)player, player, stone);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77979_a(1);
            if (stack.func_190916_E() <= 0) {
                player.field_71071_by.func_184437_d(stack);
            }
        }
        entity.field_70128_L = true;
        return true;
    }

    public boolean hasPermission(EntityLivingBase entity, EntityPlayer player) {
        if (NoppesUtilServer.isOp(player)) {
            return true;
        }
        if (CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.SOULSTONE_ALL)) {
            return true;
        }
        if (entity instanceof EntityNPCInterface) {
            RoleInterface role;
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.advanced.role == 6 && ((RoleCompanion)(role = (RoleCompanion)npc.roleInterface)).getOwner() == player) {
                return true;
            }
            if (npc.advanced.role == 2 && ((RoleFollower)(role = (RoleFollower)npc.roleInterface)).getOwner() == player) {
                return !((RoleFollower)role).refuseSoulStone;
            }
            return CustomNpcs.SoulStoneNPCs;
        }
        if (entity instanceof EntityAnimal) {
            return CustomNpcs.SoulStoneAnimals;
        }
        return false;
    }
}

