/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;

public class ItemSoulstoneFilled
extends Item {
    public ItemSoulstoneFilled() {
        super(new Item.Properties().func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null || !compound.func_150297_b("Entity", 10)) {
            list.add((ITextComponent)new TextComponentString(TextFormatting.RED + "Error"));
            return;
        }
        String name = I18n.func_135052_a((String)compound.func_74779_i("Name"), (Object[])new Object[0]);
        if (compound.func_74764_b("DisplayName")) {
            name = compound.func_74779_i("DisplayName") + " (" + name + ")";
        }
        list.add((ITextComponent)new TextComponentString(TextFormatting.BLUE + name));
        if (stack.func_77978_p().func_74764_b("ExtraText")) {
            String[] split;
            String text = "";
            for (String s : split = compound.func_74779_i("ExtraText").split(",")) {
                text = text + I18n.func_135052_a((String)s, (Object[])new Object[0]);
            }
            list.add((ITextComponent)new TextComponentString(text));
        }
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = context.func_195996_i();
        if (ItemSoulstoneFilled.Spawn(context.func_195999_j(), stack, context.func_195991_k(), context.func_195995_a()) == null) {
            return EnumActionResult.FAIL;
        }
        if (!context.func_195999_j().field_71075_bZ.field_75098_d) {
            stack.func_77979_a(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public static Entity Spawn(EntityPlayer player, ItemStack stack, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return null;
        }
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_150297_b("Entity", 10)) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p().func_74775_l("Entity");
        Entity entity = EntityType.func_200716_a((NBTTagCompound)compound, (World)world);
        if (entity == null) {
            return null;
        }
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)((float)(pos.func_177956_o() + 1) + 0.2f), (double)pos.func_177952_p() + 0.5);
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(pos);
            npc.func_70606_j(npc.func_110138_aP());
            npc.func_70107_b((float)pos.func_177958_n() + 0.5f, npc.getStartYPos(), (float)pos.func_177952_p() + 0.5f);
            if (npc.advanced.role == 6 && player != null) {
                PlayerData data = PlayerData.get(player);
                if (data.hasCompanion()) {
                    return null;
                }
                ((RoleCompanion)npc.roleInterface).setOwner(player);
                data.setCompanion(npc);
            }
            if (npc.advanced.role == 2 && player != null) {
                ((RoleFollower)npc.roleInterface).setOwner(player);
            }
        }
        if (!world.func_72838_d(entity)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("error.failedToSpawn", new Object[0]));
            return null;
        }
        return entity;
    }
}

