/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.network.NetworkEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.entity.EntityNPCInterface;

public abstract class PacketServerBasic {
    public EntityPlayerMP player;
    public EntityNPCInterface npc;

    public boolean requiresNpc() {
        return false;
    }

    public CustomNpcsPermissions.Permission getPermission() {
        return null;
    }

    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.wand;
    }

    public static void handle(PacketServerBasic msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            msg.player = ((NetworkEvent.Context)ctx.get()).getSender();
            msg.npc = NoppesUtilServer.getEditingNpc((EntityPlayer)msg.player);
            if (msg.requiresNpc() && msg.npc == null) {
                return;
            }
            if (msg.getPermission() != null && !CustomNpcsPermissions.hasPermission((EntityPlayer)msg.player, msg.getPermission())) {
                return;
            }
            if (!msg.toolAllowed(msg.player.field_71071_by.func_70448_g())) {
                msg.warn("tried to use custom npcs without a tool in hand, possibly a hacker");
                return;
            }
            msg.handle();
        });
        ctx.get().setPacketHandled(true);
    }

    private void warn(String warning) {
        this.player.func_184102_h().func_71236_h(this.player.func_200200_C_().func_150254_d() + ": " + warning + " - " + this);
    }

    protected abstract void handle();
}

