/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.RenderChatMessages;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketBasic;

public class PacketChatBubble
extends PacketBasic {
    private final int id;
    private final String message;
    private final boolean showMessage;

    public PacketChatBubble(int id, String message, boolean showMessage) {
        this.id = id;
        this.message = message;
        this.showMessage = showMessage;
    }

    public static void encode(PacketChatBubble msg, PacketBuffer buf) {
        buf.writeInt(msg.id);
        buf.func_180714_a(msg.message);
        buf.writeBoolean(msg.showMessage);
    }

    public static PacketChatBubble decode(PacketBuffer buf) {
        return new PacketChatBubble(buf.readInt(), buf.func_150789_c(Short.MAX_VALUE), buf.readBoolean());
    }

    @Override
    public void handle() {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.id);
        if (entity == null || !(entity instanceof EntityNPCInterface)) {
            return;
        }
        EntityNPCInterface npc = (EntityNPCInterface)entity;
        if (npc.messages == null) {
            npc.messages = new RenderChatMessages();
        }
        String text = NoppesStringUtils.formatText(this.message, new Object[]{this.player, npc});
        npc.messages.addMessage(text, npc);
        if (this.showMessage) {
            this.player.func_145747_a((ITextComponent)new TextComponentTranslation(npc.func_200200_C_().func_150261_e() + ": " + text, new Object[0]));
        }
    }
}

