/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.network.PacketBuffer;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.packets.PacketBasic;

public class PacketSyncRemove
extends PacketBasic {
    private final int id;
    private final int type;

    public PacketSyncRemove(int id, int type) {
        this.id = id;
        this.type = type;
    }

    public static void encode(PacketSyncRemove msg, PacketBuffer buf) {
        buf.writeInt(msg.id);
        buf.writeInt(msg.type);
    }

    public static PacketSyncRemove decode(PacketBuffer buf) {
        return new PacketSyncRemove(buf.readInt(), buf.readInt());
    }

    @Override
    public void handle() {
        QuestCategory category;
        if (this.type == 1) {
            FactionController.instance.factions.remove(this.id);
        } else if (this.type == 4) {
            Dialog dialog = DialogController.instance.dialogs.remove(this.id);
            if (dialog != null) {
                dialog.category.dialogs.remove(this.id);
            }
        } else if (this.type == 5) {
            DialogCategory category2 = DialogController.instance.categories.remove(this.id);
            if (category2 != null) {
                DialogController.instance.dialogs.keySet().removeAll(category2.dialogs.keySet());
            }
        } else if (this.type == 2) {
            Quest quest = QuestController.instance.quests.remove(this.id);
            if (quest != null) {
                quest.category.quests.remove(this.id);
            }
        } else if (this.type == 3 && (category = QuestController.instance.categories.remove(this.id)) != null) {
            QuestController.instance.quests.keySet().removeAll(category.quests.keySet());
        }
    }

    public void clientSync(boolean syncEnd) {
    }
}

