/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiClose;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleDialog;

public class SPacketDialogSelected
extends PacketServerBasic {
    private final int dialogId;
    private final int optionId;

    public SPacketDialogSelected(int dialogId, int optionId) {
        this.dialogId = dialogId;
        this.optionId = optionId;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return true;
    }

    @Override
    public boolean requiresNpc() {
        return true;
    }

    public static void encode(SPacketDialogSelected msg, PacketBuffer buf) {
        buf.writeInt(msg.dialogId);
        buf.writeInt(msg.optionId);
    }

    public static SPacketDialogSelected decode(PacketBuffer buf) {
        return new SPacketDialogSelected(buf.readInt(), buf.readInt());
    }

    @Override
    protected void handle() {
        PlayerData data = PlayerData.get((EntityPlayer)this.player);
        if (data.dialogId != this.dialogId) {
            return;
        }
        if (data.dialogId < 0 && this.npc.advanced.role == 7) {
            String text = ((RoleDialog)this.npc.roleInterface).optionsTexts.get(this.optionId);
            if (text != null && !text.isEmpty()) {
                Dialog d = new Dialog(null);
                d.text = text;
                NoppesUtilServer.openDialog((EntityPlayer)this.player, this.npc, d);
            }
            return;
        }
        Dialog dialog = DialogController.instance.dialogs.get(data.dialogId);
        if (dialog == null) {
            return;
        }
        if (!dialog.hasDialogs((EntityPlayer)this.player) && !dialog.hasOtherOptions()) {
            this.closeDialog(this.player, this.npc, true);
            return;
        }
        DialogOption option = dialog.options.get(this.optionId);
        if (option == null || EventHooks.onNPCDialogOption(this.npc, this.player, dialog, option) || option.optionType == 1 && (!option.isAvailable((EntityPlayer)this.player) || !option.hasDialog()) || option.optionType == 2 || option.optionType == 0) {
            this.closeDialog(this.player, this.npc, true);
            return;
        }
        if (option.optionType == 3) {
            this.closeDialog(this.player, this.npc, true);
            if (this.npc.roleInterface != null) {
                if (this.npc.advanced.role == 6) {
                    ((RoleCompanion)this.npc.roleInterface).interact((EntityPlayer)this.player, true);
                } else {
                    this.npc.roleInterface.interact((EntityPlayer)this.player);
                }
            }
        } else if (option.optionType == 1) {
            this.closeDialog(this.player, this.npc, false);
            NoppesUtilServer.openDialog((EntityPlayer)this.player, this.npc, option.getDialog());
        } else if (option.optionType == 4) {
            this.closeDialog(this.player, this.npc, true);
            NoppesUtilServer.runCommand((Entity)this.npc, this.npc.func_200200_C_().func_150261_e(), option.command, (EntityPlayer)this.player);
        } else {
            this.closeDialog(this.player, this.npc, true);
        }
    }

    public void closeDialog(EntityPlayerMP player, EntityNPCInterface npc, boolean notifyClient) {
        PlayerData data = PlayerData.get((EntityPlayer)player);
        Dialog dialog = DialogController.instance.dialogs.get(data.dialogId);
        EventHooks.onNPCDialogClose(npc, player, dialog);
        if (notifyClient) {
            Packets.send(player, new PacketGuiClose(new NBTTagCompound()));
        }
        data.dialogId = -1;
    }
}

