/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.util.ITeleporter;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomTeleporter;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketDimensionTeleport
extends PacketServerBasic {
    private ResourceLocation id;

    public SPacketDimensionTeleport(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.teleporter;
    }

    public static void encode(SPacketDimensionTeleport msg, PacketBuffer buf) {
        buf.func_192572_a(msg.id);
    }

    public static SPacketDimensionTeleport decode(PacketBuffer buf) {
        return new SPacketDimensionTeleport(buf.func_192575_l());
    }

    @Override
    protected void handle() {
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)this.id);
        WorldServer world = this.player.func_184102_h().func_71218_a(dimension);
        BlockPos coords = world.func_180504_m();
        if (coords == null) {
            coords = world.func_175694_M();
            if (!world.func_175623_d(coords)) {
                coords = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, coords);
            } else {
                while (world.func_175623_d(coords) && coords.func_177956_o() > 0) {
                    coords = coords.func_177977_b();
                }
                if (coords.func_177956_o() == 0) {
                    coords = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, coords);
                }
            }
        }
        SPacketDimensionTeleport.teleportPlayer(this.player, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), dimension);
    }

    public static void teleportPlayer(EntityPlayerMP player, double x, double y, double z, DimensionType dimension) {
        if (player.field_71093_bK != dimension) {
            MinecraftServer server = player.func_184102_h();
            WorldServer wor = server.func_71218_a(dimension);
            if (wor == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Broken transporter. Dimenion does not exist"));
                return;
            }
            player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
            player.changeDimension(dimension, (ITeleporter)new CustomTeleporter(wor));
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
            if (!wor.field_73010_i.contains(player)) {
                wor.func_72838_d((Entity)player);
            }
        } else {
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        }
        player.field_70170_p.func_72866_a((Entity)player, false);
    }
}

