/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import java.util.ArrayList;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiOpen;
import noppes.npcs.packets.client.PacketGuiScrollList;
import noppes.npcs.packets.client.PacketNpcRole;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.util.CustomNPCsScheduler;

public class SPacketGuiOpen
extends PacketServerBasic {
    private EnumGuiType type;
    private BlockPos pos;

    public SPacketGuiOpen(EnumGuiType type, BlockPos pos) {
        this.type = type;
        this.pos = pos;
    }

    public static void encode(SPacketGuiOpen msg, PacketBuffer buf) {
        buf.func_179249_a((Enum)msg.type);
        buf.func_179255_a(msg.pos);
    }

    public static SPacketGuiOpen decode(PacketBuffer buf) {
        return new SPacketGuiOpen((EnumGuiType)buf.func_179257_a(EnumGuiType.class), buf.func_179259_c());
    }

    @Override
    protected void handle() {
        SPacketGuiOpen.sendOpenGui((EntityPlayer)this.player, this.type, this.npc, this.pos);
    }

    public static void sendOpenGui(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc, BlockPos pos) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        NoppesUtilServer.setEditingNpc(player, npc);
        if (gui == EnumGuiType.PlayerFollower || gui == EnumGuiType.PlayerFollowerHire || gui == EnumGuiType.PlayerTrader || gui == EnumGuiType.PlayerTransporter) {
            if (npc.advanced.role == 0) {
                return;
            }
            NBTTagCompound comp = new NBTTagCompound();
            npc.roleInterface.write(comp);
            comp.func_74768_a("Role", npc.advanced.role);
            Packets.send((EntityPlayerMP)player, new PacketNpcRole(npc.func_145782_y(), comp));
        }
        CustomNPCsScheduler.runTack(() -> {
            ArrayList<String> list;
            if (!NoppesUtilServer.openContainerGui((EntityPlayerMP)player, gui, npc, pos)) {
                Packets.send((EntityPlayerMP)player, new PacketGuiOpen(gui, pos));
            }
            if ((list = SPacketGuiOpen.getScrollData(player, gui, npc)) == null || list.isEmpty()) {
                return;
            }
            Packets.send((EntityPlayerMP)player, new PacketGuiScrollList(new Vector<String>(list)));
        }, 200);
    }

    private static ArrayList<String> getScrollData(EntityPlayer player, EnumGuiType gui, EntityNPCInterface npc) {
        if (gui == EnumGuiType.PlayerTransporter) {
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            ArrayList<String> list = new ArrayList<String>();
            TransportLocation location = role.getLocation();
            String name = role.getLocation().name;
            for (TransportLocation loc : location.category.getDefaultLocations()) {
                if (list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            PlayerTransportData playerdata = PlayerData.get((EntityPlayer)player).transportData;
            for (int i : playerdata.transports) {
                TransportLocation loc = TransportController.getInstance().getTransport(i);
                if (loc == null || !location.category.locations.containsKey(loc.id) || list.contains(loc.name)) continue;
                list.add(loc.name);
            }
            list.remove(name);
            return list;
        }
        return null;
    }
}

