/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.constants.EnumMenuType;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiData;

public class SPacketMenuGet
extends PacketServerBasic {
    private EnumMenuType type;

    public SPacketMenuGet(EnumMenuType type) {
        this.type = type;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        if (this.type == EnumMenuType.MOVING_PATH) {
            return item.func_77973_b() == CustomItems.moving;
        }
        return item.func_77973_b() == CustomItems.wand;
    }

    @Override
    public boolean requiresNpc() {
        return true;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.NPC_GUI;
    }

    public static void encode(SPacketMenuGet msg, PacketBuffer buf) {
        buf.func_179249_a((Enum)msg.type);
    }

    public static SPacketMenuGet decode(PacketBuffer buf) {
        return new SPacketMenuGet((EnumMenuType)buf.func_179257_a(EnumMenuType.class));
    }

    @Override
    protected void handle() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.type == EnumMenuType.DISPLAY) {
            this.npc.display.write(data);
        }
        if (this.type == EnumMenuType.STATS) {
            this.npc.stats.write(data);
        }
        if (this.type == EnumMenuType.INVENTORY) {
            this.npc.inventory.write(data);
        }
        if (this.type == EnumMenuType.AI || this.type == EnumMenuType.MOVING_PATH) {
            this.npc.ais.write(data);
        }
        if (this.type == EnumMenuType.ADVANCED) {
            this.npc.advanced.write(data);
        }
        if (this.type == EnumMenuType.TRANSFORM) {
            this.npc.transform.writeOptions(data);
        }
        Packets.send(this.player, new PacketGuiData(data));
    }
}

