/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketPlayerMailRead
extends PacketServerBasic {
    private final long time;
    private final String username;

    public SPacketPlayerMailRead(long time, String username) {
        this.time = time;
        this.username = username;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return true;
    }

    public static void encode(SPacketPlayerMailRead msg, PacketBuffer buf) {
        buf.writeLong(msg.time);
        buf.func_180714_a(msg.username);
    }

    public static SPacketPlayerMailRead decode(PacketBuffer buf) {
        return new SPacketPlayerMailRead(buf.readLong(), buf.func_150789_c(Short.MAX_VALUE));
    }

    @Override
    protected void handle() {
        PlayerMailData data = PlayerData.get((EntityPlayer)this.player).mailData;
        for (PlayerMail mail : data.playermail) {
            if (mail.beenRead || mail.time != this.time || !mail.sender.equals(this.username)) continue;
            if (mail.hasQuest()) {
                PlayerQuestController.addActiveQuest(mail.getQuest(), (EntityPlayer)this.player);
            }
            mail.beenRead = true;
        }
    }
}

