/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketScriptSave
extends PacketServerBasic {
    private int type;
    private NBTTagCompound data;

    public SPacketScriptSave(int type, NBTTagCompound data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.scripter || item.func_77973_b() == CustomBlocks.scripted_door_item || item.func_77973_b() == CustomItems.scripted_item || item.func_77973_b() == CustomBlocks.scripted_item;
    }

    @Override
    public boolean requiresNpc() {
        return this.type == 0;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.TOOL_SCRIPTER;
    }

    public static void encode(SPacketScriptSave msg, PacketBuffer buf) {
        buf.writeInt(msg.type);
        buf.func_150786_a(msg.data);
    }

    public static SPacketScriptSave decode(PacketBuffer buf) {
        return new SPacketScriptSave(buf.readInt(), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        TileNpcEntity script;
        TileEntity tile;
        PlayerData pd;
        if (this.type == 0) {
            this.npc.script.read(this.data);
            this.npc.updateAI = true;
            this.npc.script.lastInited = -1L;
        }
        if (this.type == 1) {
            pd = PlayerData.get((EntityPlayer)this.player);
            tile = this.player.field_70170_p.func_175625_s(pd.scriptBlockPos);
            if (!(tile instanceof TileScripted)) {
                return;
            }
            script = (TileScripted)tile;
            ((TileScripted)script).setNBT(this.data);
            ((TileScripted)script).lastInited = -1L;
        }
        if (this.type == 2) {
            if (!this.player.func_184812_l_()) {
                return;
            }
            ItemScriptedWrapper wrapper = (ItemScriptedWrapper)NpcAPI.Instance().getIItemStack(this.player.func_184614_ca());
            wrapper.setMCNbt(this.data);
            wrapper.lastInited = -1L;
            wrapper.saveScriptData();
            wrapper.updateClient = true;
            this.player.func_71120_a(this.player.field_71069_bz);
        }
        if (this.type == 3) {
            ScriptController.Instance.setForgeScripts(this.data);
        }
        if (this.type == 4) {
            ScriptController.Instance.setPlayerScripts(this.data);
        }
        if (this.type == 5) {
            pd = PlayerData.get((EntityPlayer)this.player);
            tile = this.player.field_70170_p.func_175625_s(pd.scriptBlockPos);
            if (!(tile instanceof TileScriptedDoor)) {
                return;
            }
            script = (TileScriptedDoor)tile;
            ((TileScriptedDoor)script).setNBT(this.data);
            ((TileScriptedDoor)script).lastInited = -1L;
        }
    }
}

