/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketToolMobSpawner
extends PacketServerBasic {
    private boolean createSpawner;
    private boolean server;
    private BlockPos pos;
    private String name = "";
    private int tab = -1;
    private NBTTagCompound clone = new NBTTagCompound();

    public SPacketToolMobSpawner(boolean createSpawner, BlockPos pos, String name, int tab) {
        this.server = true;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
    }

    public SPacketToolMobSpawner(boolean createSpawner, BlockPos pos, NBTTagCompound clone) {
        this.server = false;
        this.createSpawner = createSpawner;
        this.pos = pos;
        this.clone = clone;
    }

    public SPacketToolMobSpawner(boolean createSpawner, boolean server, BlockPos pos, String name, int tab, NBTTagCompound clone) {
        this.createSpawner = createSpawner;
        this.server = server;
        this.pos = pos;
        this.name = name;
        this.tab = tab;
        this.clone = clone;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.cloner;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        if (this.createSpawner) {
            return CustomNpcsPermissions.SPAWNER_CREATE;
        }
        return CustomNpcsPermissions.SPAWNER_MOB;
    }

    public static void encode(SPacketToolMobSpawner msg, PacketBuffer buf) {
        buf.writeBoolean(msg.createSpawner);
        buf.writeBoolean(msg.server);
        buf.func_179255_a(msg.pos);
        buf.func_180714_a(msg.name);
        buf.writeInt(msg.tab);
        buf.func_150786_a(msg.clone);
    }

    public static SPacketToolMobSpawner decode(PacketBuffer buf) {
        return new SPacketToolMobSpawner(buf.readBoolean(), buf.readBoolean(), buf.func_179259_c(), buf.func_150789_c(Short.MAX_VALUE), buf.readInt(), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        if (this.server) {
            this.clone = ServerCloneController.Instance.getCloneData(this.player.func_195051_bN(), this.name, this.tab);
        }
        if (this.clone == null || this.clone.isEmpty()) {
            return;
        }
        if (this.createSpawner) {
            SPacketToolMobSpawner.createMobSpawner(this.pos, this.clone, (EntityPlayer)this.player);
        } else {
            Entity entity = SPacketToolMobSpawner.spawnClone(this.clone, (double)this.pos.func_177958_n() + 0.5, this.pos.func_177956_o() + 1, (double)this.pos.func_177952_p() + 0.5, this.player.field_70170_p);
            if (entity == null) {
                this.player.func_145747_a((ITextComponent)new TextComponentString("Failed to create an entity out of your clone"));
            }
        }
    }

    public static Entity spawnClone(NBTTagCompound compound, double x, double y, double z, World world) {
        ServerCloneController.Instance.cleanTags(compound);
        compound.func_74782_a("Pos", (INBTBase)NBTTags.nbtDoubleList(x, y, z));
        Entity entity = EntityType.func_200716_a((NBTTagCompound)compound, (World)world);
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            npc.ais.setStartPos(new BlockPos((Entity)npc));
        }
        world.func_72838_d(entity);
        return entity;
    }

    public static void createMobSpawner(BlockPos pos, NBTTagCompound comp, EntityPlayer player) {
        ServerCloneController.Instance.cleanTags(comp);
        if (comp.func_74779_i("id").equalsIgnoreCase("entityhorse")) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("Currently you cant create horse spawner, its a minecraft bug", new Object[0]));
            return;
        }
        player.field_70170_p.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner tile = (TileEntityMobSpawner)player.field_70170_p.func_175625_s(pos);
        MobSpawnerBaseLogic logic = tile.func_145881_a();
        if (!comp.func_150297_b("id", 8)) {
            comp.func_74778_a("id", "Pig");
        }
        comp.func_74783_a("StartPosNew", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
        logic.func_184993_a(new WeightedSpawnerEntity(1, comp));
    }
}

