/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.packets.PacketServerBasic;

public class SPacketToolMounter
extends PacketServerBasic {
    private int type;
    private String name;
    private int tab = -1;
    private NBTTagCompound compound = new NBTTagCompound();

    private SPacketToolMounter(int type, String name, int tab, NBTTagCompound compound) {
        this.type = type;
        this.name = name;
        this.tab = tab;
        this.compound = compound;
    }

    public SPacketToolMounter(int type, String name, int tab) {
        this.type = type;
        this.name = name;
        this.tab = tab;
    }

    public SPacketToolMounter(int type, NBTTagCompound compound) {
        this.type = type;
        this.compound = compound;
    }

    public SPacketToolMounter() {
        this.type = 3;
    }

    @Override
    public boolean toolAllowed(ItemStack item) {
        return item.func_77973_b() == CustomItems.mount;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.TOOL_MOUNTER;
    }

    public static void encode(SPacketToolMounter msg, PacketBuffer buf) {
        buf.writeInt(msg.type);
        buf.func_180714_a(msg.name);
        buf.writeInt(msg.tab);
        buf.func_150786_a(msg.compound);
    }

    public static SPacketToolMounter decode(PacketBuffer buf) {
        return new SPacketToolMounter(buf.readInt(), buf.func_150789_c(Short.MAX_VALUE), buf.readInt(), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        PlayerData data = PlayerData.get((EntityPlayer)this.player);
        if (data.mounted == null) {
            return;
        }
        if (this.type == 0) {
            Entity entity = EntityType.func_200716_a((NBTTagCompound)this.compound, (World)this.player.field_70170_p);
            entity.func_70107_b(data.mounted.field_70165_t, data.mounted.field_70163_u, data.mounted.field_70161_v);
            this.player.field_70170_p.func_72838_d(entity);
            entity.func_184205_a(data.mounted, true);
        } else if (this.type == 1) {
            Entity entity = EntityType.func_200716_a((NBTTagCompound)ServerCloneController.Instance.getCloneData(this.player.func_195051_bN(), this.name, this.tab), (World)this.player.field_70170_p);
            entity.func_70107_b(data.mounted.field_70165_t, data.mounted.field_70163_u, data.mounted.field_70161_v);
            this.player.field_70170_p.func_72838_d(entity);
            entity.func_184205_a(data.mounted, true);
        } else if (this.type == 2) {
            EntityType type = (EntityType)IRegistry.field_212629_r.func_212608_b(new ResourceLocation(this.name));
            Entity entity = type.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
            if (entity == null) {
                return;
            }
            entity.func_70107_b(data.mounted.field_70165_t, data.mounted.field_70163_u, data.mounted.field_70161_v);
            this.player.field_70170_p.func_72838_d(entity);
            entity.func_184205_a(data.mounted, true);
        } else {
            this.player.func_184205_a(data.mounted, true);
        }
    }
}

