/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.server;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.packets.PacketServerBasic;
import noppes.npcs.roles.RoleTransporter;

public class SPacketTransportSave
extends PacketServerBasic {
    private int category;
    private NBTTagCompound data;

    public SPacketTransportSave(int category, NBTTagCompound data) {
        this.data = data;
        this.category = category;
    }

    @Override
    public boolean requiresNpc() {
        return true;
    }

    @Override
    public CustomNpcsPermissions.Permission getPermission() {
        return CustomNpcsPermissions.NPC_ADVANCED;
    }

    public static void encode(SPacketTransportSave msg, PacketBuffer buf) {
        buf.writeInt(msg.category);
        buf.func_150786_a(msg.data);
    }

    public static SPacketTransportSave decode(PacketBuffer buf) {
        return new SPacketTransportSave(buf.readInt(), buf.func_150793_b());
    }

    @Override
    protected void handle() {
        TransportLocation location = TransportController.getInstance().saveLocation(this.category, this.data, this.player, this.npc);
        if (location != null) {
            if (this.npc.advanced.role != 4) {
                return;
            }
            RoleTransporter role = (RoleTransporter)this.npc.roleInterface;
            role.setTransport(location);
        }
    }
}

