/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobGuard
extends JobInterface {
    public List<String> targets = new ArrayList<String>();

    public JobGuard(EntityNPCInterface npc) {
        super(npc);
    }

    public boolean isEntityApplicable(Entity entity) {
        if (entity instanceof EntityPlayer || entity instanceof EntityNPCInterface) {
            return false;
        }
        return this.targets.contains("entity." + entity.func_70022_Q() + ".name");
    }

    @Override
    public NBTTagCompound write(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("GuardTargets", (INBTBase)NBTTags.nbtStringList(this.targets));
        return nbttagcompound;
    }

    @Override
    public void read(NBTTagCompound nbttagcompound) {
        String name;
        Class cl;
        EntityType ent;
        this.targets = NBTTags.getStringList(nbttagcompound.func_150295_c("GuardTargets", 10));
        if (nbttagcompound.func_74767_n("GuardAttackAnimals")) {
            for (ResourceLocation resource : IRegistry.field_212629_r.func_148742_b()) {
                ent = (EntityType)IRegistry.field_212629_r.func_212608_b(resource);
                cl = ent.func_201760_c();
                name = "entity." + ent.func_210760_d() + ".name";
                if (!EntityAnimal.class.isAssignableFrom(cl) || this.targets.contains(name)) continue;
                this.targets.add(name);
            }
        }
        if (nbttagcompound.func_74767_n("GuardAttackMobs")) {
            for (ResourceLocation resource : IRegistry.field_212629_r.func_148742_b()) {
                ent = (EntityType)IRegistry.field_212629_r.func_212608_b(resource);
                cl = ent.func_201760_c();
                name = "entity." + ent.func_210760_d() + ".name";
                if (!EntityMob.class.isAssignableFrom(cl) || EntityCreeper.class.isAssignableFrom(cl) || this.targets.contains(name)) continue;
                this.targets.add(name);
            }
        }
        if (nbttagcompound.func_74767_n("GuardAttackCreepers")) {
            for (ResourceLocation resource : IRegistry.field_212629_r.func_148742_b()) {
                ent = (EntityType)IRegistry.field_212629_r.func_212608_b(resource);
                cl = ent.func_201760_c();
                name = "entity." + ent.func_210760_d() + ".name";
                if (!EntityCreeper.class.isAssignableFrom(cl) || this.targets.contains(name)) continue;
                this.targets.add(name);
            }
        }
    }
}

