/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.blocks.tiles.TileBigSign;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.BankData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.controllers.PlayerMailData;
import noppes.npcs.controllers.PlayerQuestController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.entity.EntityNPCInterface;

public class PacketHandlerPlayer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        ByteBufInputStream dis = new ByteBufInputStream(event.packet.payload());
        try {
            this.player(dis, player, EnumPlayerPacket.values()[dis.readInt()]);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void player(ByteBufInputStream dis, EntityPlayerMP player, EnumPlayerPacket type) throws IOException {
        if (type == EnumPlayerPacket.FollowerHire) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.hireFollower(player, npc);
        } else if (type == EnumPlayerPacket.FollowerExtend) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.extendFollower(player, npc);
        } else if (type == EnumPlayerPacket.FollowerState) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.changeFollowerState(player, npc);
        } else if (type == EnumPlayerPacket.Transport) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.transport(player, npc, dis.readUTF());
        } else if (type == EnumPlayerPacket.BankUpgrade) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.bankUpgrade(player, npc);
        } else if (type == EnumPlayerPacket.BankUnlock) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.bankUnlock(player, npc);
        } else if (type == EnumPlayerPacket.BankSlotOpen) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            int slot = dis.readInt();
            int bankId = dis.readInt();
            BankData data = PlayerDataController.instance.getBankData((EntityPlayer)player, bankId).getBankOrDefault(bankId);
            data.openBankGui((EntityPlayer)player, npc, bankId, slot);
        } else if (type == EnumPlayerPacket.Dialog) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (npc == null) {
                return;
            }
            NoppesUtilPlayer.dialogSelected(dis.readInt(), dis.readInt(), player, npc);
        } else if (type == EnumPlayerPacket.CheckQuestCompletion) {
            PlayerQuestData playerdata = PlayerDataController.instance.getPlayerData((EntityPlayer)player).questData;
            playerdata.checkQuestCompletion((EntityPlayer)player, null);
        } else if (type == EnumPlayerPacket.QuestLog) {
            NoppesUtilPlayer.sendQuestLogData(player);
        } else if (type == EnumPlayerPacket.QuestCompletion) {
            NoppesUtilPlayer.questCompletion(player, dis.readInt());
        } else if (type == EnumPlayerPacket.FactionsGet) {
            PlayerFactionData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).factionData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.getPlayerGuiData());
        } else if (type == EnumPlayerPacket.MailGet) {
            PlayerMailData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailDelete) {
            long time = dis.readLong();
            String username = dis.readUTF();
            PlayerMailData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            Iterator<PlayerMail> it = data.playermail.iterator();
            while (it.hasNext()) {
                PlayerMail mail = it.next();
                if (mail.time != time || !mail.sender.equals(username)) continue;
                it.remove();
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, data.saveNBTData(new NBTTagCompound()));
        } else if (type == EnumPlayerPacket.MailSend) {
            String username = PlayerDataController.instance.hasPlayer(dis.readUTF());
            if (username.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 0);
                return;
            }
            PlayerMail mail = new PlayerMail();
            String s = player.getDisplayName();
            if (!s.equals(player.func_70005_c_())) {
                s = s + "(" + player.func_70005_c_() + ")";
            }
            mail.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            mail.sender = s;
            mail.items = ((ContainerMail)player.field_71070_bA).mail.items;
            if (mail.subject.isEmpty()) {
                NoppesUtilServer.sendGuiError((EntityPlayer)player, 1);
                return;
            }
            PlayerDataController.instance.addPlayerMessage(username, mail);
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74778_a("username", username);
            NoppesUtilServer.sendGuiClose(player, 1, comp);
        } else if (type == EnumPlayerPacket.MailboxOpenMail) {
            long time = dis.readLong();
            String username = dis.readUTF();
            player.func_71128_l();
            PlayerMailData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                ContainerMail.staticmail = mail;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 0, 0, 0);
                break;
            }
        } else if (type == EnumPlayerPacket.MailRead) {
            long time = dis.readLong();
            String username = dis.readUTF();
            PlayerMailData data = PlayerDataController.instance.getPlayerData((EntityPlayer)player).mailData;
            for (PlayerMail mail : data.playermail) {
                if (mail.time != time || !mail.sender.equals(username)) continue;
                mail.beenRead = true;
                if (!mail.hasQuest()) continue;
                PlayerQuestController.addActiveQuest(mail.getQuest(), (EntityPlayer)player);
            }
        } else if (type == EnumPlayerPacket.SignSave) {
            int z;
            int y;
            int x = dis.readInt();
            TileEntity tile = player.field_70170_p.func_147438_o(x, y = dis.readInt(), z = dis.readInt());
            if (tile == null || !(tile instanceof TileBigSign)) {
                return;
            }
            TileBigSign sign = (TileBigSign)tile;
            if (sign.canEdit) {
                sign.setText(dis.readUTF());
                sign.canEdit = false;
                player.field_70170_p.func_147471_g(x, y, z);
            }
        }
    }
}

