/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import foxz.utils.Market;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.Bank;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogCategory;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DialogOption;
import noppes.npcs.controllers.Faction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerMail;
import noppes.npcs.controllers.Quest;
import noppes.npcs.controllers.QuestCategory;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.SpawnData;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.roles.RoleTransporter;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        if (CustomNpcs.OpsOnly && !MinecraftServer.func_71276_C().func_71203_ab().func_72376_i().contains(player.func_70005_c_().toLowerCase())) {
            this.warn((EntityPlayer)player, "tried to use custom npcs without being an op");
            return;
        }
        ByteBufInputStream dis = new ByteBufInputStream(event.packet.payload());
        try {
            block21: {
                EntityNPCInterface npc;
                ItemStack item;
                EnumPacketServer type;
                block22: {
                    type = EnumPacketServer.values()[dis.readInt()];
                    item = player.field_71071_by.func_70448_g();
                    npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
                    if (type.needsNpc && npc == null) break block21;
                    if (!type.hasPermission()) break block22;
                    if (!CustomNpcsPermissions.hasPermission((EntityPlayer)player, type.permission)) break block21;
                }
                if (item == null) {
                    this.warn((EntityPlayer)player, "tried to use custom npcs without a tool in hand, probably a hacker");
                } else if (item.func_77973_b() == CustomItems.wand) {
                    this.wandPackets(type, event.packet.payload(), dis, player, npc);
                } else if (item.func_77973_b() == CustomItems.moving) {
                    this.movingPackets(type, event.packet.payload(), dis, player, npc);
                } else if (item.func_77973_b() == CustomItems.mount) {
                    this.mountPackets(type, event.packet.payload(), dis, player);
                } else if (item.func_77973_b() == CustomItems.cloner) {
                    this.clonePackets(type, event.packet.payload(), dis, player);
                } else if (item.func_77973_b() == CustomItems.teleporter) {
                    this.featherPackets(type, event.packet.payload(), dis, player);
                } else if (item.func_77973_b() == CustomItems.scripter) {
                    this.scriptPackets(type, event.packet.payload(), dis, player, npc);
                } else if (item.func_77973_b() == Item.func_150898_a((Block)CustomItems.waypoint) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.border) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.redstoneBlock)) {
                    this.blockPackets(type, event.packet.payload(), dis, player);
                }
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void scriptPackets(EnumPacketServer type, ByteBuf payload, ByteBufInputStream dis, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.ScriptDataSave) {
            npc.script.readFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            npc.script.hasInited = false;
        } else if (type == EnumPacketServer.ScriptDataGet) {
            NBTTagCompound compound = npc.script.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        }
    }

    private void featherPackets(EnumPacketServer type, ByteBuf payload, ByteBufInputStream dis, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.DimensionsGet) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            Integer[] arr$ = DimensionManager.getStaticDimensionIDs();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int id = arr$[i$];
                WorldProvider provider = DimensionManager.createProviderFor((int)id);
                map.put(provider.func_80007_l(), id);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, map);
        } else if (type == EnumPacketServer.DimensionTeleport) {
            int dimension = dis.readInt();
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
            ChunkCoordinates coords = world.func_73054_j();
            if (coords == null) {
                coords = world.func_72861_E();
                if (!world.func_147437_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) {
                    coords.field_71572_b = world.func_72825_h(coords.field_71574_a, coords.field_71573_c);
                } else {
                    while (world.func_147437_c(coords.field_71574_a, coords.field_71572_b - 1, coords.field_71573_c) && coords.field_71572_b > 0) {
                        --coords.field_71572_b;
                    }
                    if (coords.field_71572_b == 0) {
                        coords.field_71572_b = world.func_72825_h(coords.field_71574_a, coords.field_71573_c);
                    }
                }
            }
            NoppesUtilPlayer.teleportPlayer(player, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, dimension);
        }
    }

    private void movingPackets(EnumPacketServer type, ByteBuf payload, ByteBufInputStream dis, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.MovingPathGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MovingPathSave) {
            npc.ai.setMovingPath(NBTTags.getIntegerArraySet(CompressedStreamTools.func_74794_a((DataInput)dis).func_150295_c("MovingPathNew", 10)));
        }
    }

    private void blockPackets(EnumPacketServer type, ByteBuf payload, ByteBufInputStream dis, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SaveTileEntity) {
            NoppesUtilServer.saveTileEntity(player, dis);
        } else if (type == EnumPacketServer.GetTileEntity) {
            TileEntity tile = player.field_70170_p.func_147438_o(dis.readInt(), dis.readInt(), dis.readInt());
            NBTTagCompound compound = new NBTTagCompound();
            tile.func_145841_b(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.DialogCategoriesGet) {
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogsGetFromDialog) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog == null) {
                return;
            }
            NoppesUtilServer.sendDialogData(player, dialog.category);
        } else if (type == EnumPacketServer.DialogsGet) {
            NoppesUtilServer.sendDialogData(player, DialogController.instance.categories.get(dis.readInt()));
        } else if (type == EnumPacketServer.QuestsGetFromQuest) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest == null) {
                return;
            }
            NoppesUtilServer.sendQuestData(player, quest.category);
        } else if (type == EnumPacketServer.QuestCategoriesGet) {
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestsGet) {
            QuestCategory category = QuestController.instance.categories.get(dis.readInt());
            NoppesUtilServer.sendQuestData(player, category);
        } else if (type == EnumPacketServer.FactionsGet) {
            NoppesUtilServer.sendFactionDataAll(player);
        }
    }

    private void wandPackets(EnumPacketServer type, ByteBuf buffer, ByteBufInputStream dis, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.Delete) {
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
        } else if (type == EnumPacketServer.BanksGet) {
            NoppesUtilServer.sendBankDataAll(player);
        } else if (type == EnumPacketServer.BankGet) {
            Bank bank = BankController.getInstance().getBank(dis.readInt());
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPacketServer.BankSave) {
            Bank bank = new Bank();
            bank.readEntityFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            BankController.getInstance().saveBank(bank);
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPacketServer.BankRemove) {
            BankController.getInstance().removeBank(dis.readInt());
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, new Bank());
        } else if (type == EnumPacketServer.RemoteMainMenu) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)entity);
        } else if (type == EnumPacketServer.RemoteDelete) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
            NoppesUtilServer.sendNearbyNpcs(player);
        } else if (type == EnumPacketServer.RemoteNpcsGet) {
            NoppesUtilServer.sendNearbyNpcs(player);
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteFreeze) {
            CustomNpcs.FreezeNPCs = !CustomNpcs.FreezeNPCs;
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze Npcs" : "Freeze Npcs");
        } else if (type == EnumPacketServer.RemoteReset) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.reset();
        } else if (type == EnumPacketServer.RemoteTpToNpc) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            player.field_71135_a.func_147364_a(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v, 0.0f, 0.0f);
        } else if (type == EnumPacketServer.Gui) {
            EnumGuiType gui = EnumGuiType.values()[dis.readInt()];
            int i = dis.readInt();
            int j = dis.readInt();
            int k = dis.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, gui, npc, i, j, k);
        } else if (type == EnumPacketServer.RecipesGet) {
            NoppesUtilServer.sendRecipeData(player, dis.readInt());
        } else if (type == EnumPacketServer.RecipeGet) {
            RecipeCarpentry recipe = RecipeController.instance.getRecipe(dis.readInt());
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPacketServer.RecipeRemove) {
            RecipeCarpentry recipe = RecipeController.instance.removeRecipe(dis.readInt());
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, new RecipeCarpentry());
        } else if (type == EnumPacketServer.RecipeSave) {
            RecipeCarpentry recipe = RecipeController.instance.saveRecipe(dis);
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPacketServer.NaturalSpawnGetAll) {
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnGet) {
            SpawnData spawn = SpawnController.instance.getSpawnData(dis.readInt());
            if (spawn != null) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, spawn.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPacketServer.NaturalSpawnSave) {
            SpawnData data = new SpawnData();
            data.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            SpawnController.instance.saveSpawnData(data);
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnRemove) {
            SpawnController.instance.removeSpawnData(dis.readInt());
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, SpawnController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategorySave) {
            DialogCategory category = new DialogCategory();
            category.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            DialogController.instance.saveCategory(category);
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryRemove) {
            DialogController.instance.removeCategory(dis);
            Server.sendData(player, EnumPacketClient.SCROLL_DATA, DialogController.instance.getScroll());
        } else if (type == EnumPacketServer.DialogGet) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog != null) {
                NBTTagCompound compound = dialog.writeToNBT(new NBTTagCompound());
                Quest quest = QuestController.instance.quests.get(dialog.quest);
                if (quest != null) {
                    compound.func_74778_a("DialogQuestName", quest.title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.DialogCategoryGet) {
            DialogCategory category = DialogController.instance.categories.get(dis.readInt());
            if (category != null) {
                NBTTagCompound comp = category.writeNBT(new NBTTagCompound());
                comp.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, comp);
            }
        } else if (type == EnumPacketServer.DialogSave) {
            int category = dis.readInt();
            Dialog dialog = new Dialog();
            dialog.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            DialogController.instance.saveDialog(category, dialog);
            if (dialog.category != null) {
                NoppesUtilServer.sendDialogData(player, dialog.category);
            }
        } else if (type == EnumPacketServer.QuestOpenGui) {
            Quest quest = new Quest();
            int gui = dis.readInt();
            quest.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, quest);
            player.openGui((Object)CustomNpcs.instance, gui, player.field_70170_p, 0, 0, 0);
        } else if (type == EnumPacketServer.DialogRemove) {
            Dialog dialog = DialogController.instance.dialogs.get(dis.readInt());
            if (dialog != null && dialog.category != null) {
                DialogController.instance.removeDialog(dialog);
                NoppesUtilServer.sendDialogData(player, dialog.category);
            }
        } else if (type == EnumPacketServer.DialogNpcGet) {
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPacketServer.DialogNpcSet) {
            int dialog;
            int slot = dis.readInt();
            DialogOption option = NoppesUtilServer.setNpcDialog(slot, dialog = dis.readInt(), (EntityPlayer)player);
            if (option != null && option.hasDialog()) {
                NBTTagCompound compound = option.writeNBT();
                compound.func_74768_a("Position", slot);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.DialogNpcRemove) {
            npc.dialogs.remove(dis.readInt());
        } else if (type == EnumPacketServer.QuestGet) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest != null) {
                NBTTagCompound compound = new NBTTagCompound();
                if (quest.hasNewQuest()) {
                    compound.func_74778_a("NextQuestTitle", quest.getNextQuest().title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, quest.writeToNBT(compound));
            }
        } else if (type == EnumPacketServer.QuestCategoryGet) {
            QuestCategory category = QuestController.instance.categories.get(dis.readInt());
            if (category != null) {
                NBTTagCompound comp = category.writeNBT(new NBTTagCompound());
                comp.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, comp);
            }
        } else if (type == EnumPacketServer.QuestCategorySave) {
            QuestCategory category = new QuestCategory();
            category.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            QuestController.instance.saveCategory(category);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestCategoryRemove) {
            QuestController.instance.removeCategory(dis);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestSave) {
            Quest quest = QuestController.instance.saveQuest(dis);
            if (quest.category != null) {
                NoppesUtilServer.sendQuestData(player, quest.category);
            }
        } else if (type == EnumPacketServer.QuestDialogGetTitle) {
            Dialog quest = DialogController.instance.dialogs.get(dis.readInt());
            Dialog quest2 = DialogController.instance.dialogs.get(dis.readInt());
            Dialog quest3 = DialogController.instance.dialogs.get(dis.readInt());
            NBTTagCompound compound = new NBTTagCompound();
            if (quest != null) {
                compound.func_74778_a("1", quest.title);
            }
            if (quest2 != null) {
                compound.func_74778_a("2", quest2.title);
            }
            if (quest3 != null) {
                compound.func_74778_a("3", quest3.title);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.QuestRemove) {
            Quest quest = QuestController.instance.quests.get(dis.readInt());
            if (quest != null) {
                QuestController.instance.removeQuest(quest);
                NoppesUtilServer.sendQuestData(player, quest.category);
            }
        } else if (type == EnumPacketServer.TransportCategoriesGet) {
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportCategorySave) {
            TransportController.getInstance().saveCategory(dis);
        } else if (type == EnumPacketServer.TransportCategoryRemove) {
            TransportController.getInstance().removeCategory(dis.readInt());
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportRemove) {
            int id = dis.readInt();
            TransportLocation loc = TransportController.getInstance().removeLocation(id);
            if (loc != null) {
                NoppesUtilServer.sendTransportData(player, loc.category.id);
            }
        } else if (type == EnumPacketServer.TransportsGet) {
            NoppesUtilServer.sendTransportData(player, dis.readInt());
        } else if (type == EnumPacketServer.TransportSave) {
            int cat = dis.readInt();
            TransportLocation location = TransportController.getInstance().saveLocation(cat, dis, player, npc);
            if (location != null) {
                if (npc.advanced.role != EnumRoleType.Transporter) {
                    return;
                }
                RoleTransporter role = (RoleTransporter)npc.roleInterface;
                role.setTransport(location);
            }
        } else if (type == EnumPacketServer.TransportGetLocation) {
            if (npc.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            if (role.hasTransport()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, role.getLocation().writeNBT());
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, role.getLocation().category.title);
            }
        } else if (type == EnumPacketServer.FactionSet) {
            npc.setFaction(dis.readInt());
        } else if (type == EnumPacketServer.FactionSave) {
            Faction faction = new Faction();
            faction.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            FactionController.getInstance().saveFaction(faction);
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            faction.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.FactionRemove) {
            FactionController.getInstance().removeFaction(dis.readInt());
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            new Faction().writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.FactionGet) {
            NBTTagCompound compound = new NBTTagCompound();
            Faction faction = FactionController.getInstance().getFaction(dis.readInt());
            faction.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.PlayerDataGet) {
            int id = dis.readInt();
            if (EnumPlayerData.values().length <= id) {
                return;
            }
            String name = null;
            EnumPlayerData datatype = EnumPlayerData.values()[id];
            if (datatype != EnumPlayerData.Players) {
                name = dis.readUTF();
            }
            NoppesUtilServer.sendPlayerData(datatype, player, name);
        } else if (type == EnumPacketServer.PlayerDataRemove) {
            NoppesUtilServer.removePlayerData(dis, player);
        } else if (type == EnumPacketServer.MainmenuDisplayGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.display.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuDisplaySave) {
            npc.display.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            NBTTagCompound compound = npc.writeSpawnData();
            compound.func_74768_a("EntityId", npc.func_145782_y());
            Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, compound);
        } else if (type == EnumPacketServer.MainmenuStatsGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.stats.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuStatsSave) {
            npc.stats.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            NBTTagCompound compound = npc.writeSpawnData();
            compound.func_74768_a("EntityId", npc.func_145782_y());
            Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, compound);
        } else if (type == EnumPacketServer.MainmenuInvGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuInvSave) {
            npc.inventory.readEntityFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.MainmenuAIGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAISave) {
            npc.ai.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            NBTTagCompound compound = npc.writeSpawnData();
            compound.func_74768_a("EntityId", npc.func_145782_y());
            npc.func_70606_j(npc.func_110138_aP());
            Server.sendAssociatedData((Entity)npc, EnumPacketClient.UPDATE_NPC, compound);
        } else if (type == EnumPacketServer.MainmenuAdvancedGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAdvancedSave) {
            npc.advanced.readToNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            npc.updateTasks();
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.JobSave) {
            NBTTagCompound original = npc.jobInterface.writeToNBT(new NBTTagCompound());
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            Set names = compound.func_150296_c();
            for (String name : names) {
                original.func_74782_a(name, compound.func_74781_a(name));
            }
            npc.jobInterface.readFromNBT(original);
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.JobGet) {
            if (npc.jobInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.jobInterface.writeToNBT(compound);
            if (npc.advanced.job == EnumJobType.Spawner) {
                ((JobSpawner)npc.jobInterface).cleanCompound(compound);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            if (npc.advanced.job == EnumJobType.Spawner) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, ((JobSpawner)npc.jobInterface).getTitles());
            }
        } else if (type == EnumPacketServer.JobSpawnerAdd) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
            ((JobSpawner)npc.jobInterface).setJobCompound(dis.readInt(), CompressedStreamTools.func_74794_a((DataInput)dis));
            Server.sendData(player, EnumPacketClient.GUI_DATA, ((JobSpawner)npc.jobInterface).getTitles());
        } else if (type == EnumPacketServer.JobSpawnerRemove) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
            ((JobSpawner)npc.jobInterface).setJobCompound(dis.readInt(), null);
            Server.sendData(player, EnumPacketClient.GUI_DATA, ((JobSpawner)npc.jobInterface).getTitles());
        } else if (type == EnumPacketServer.RoleSave) {
            npc.roleInterface.readFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            NoppesUtilServer.updateNpc(npc);
        } else if (type == EnumPacketServer.RoleGet) {
            if (npc.roleInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("RoleData", true);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(compound));
        } else if (type == EnumPacketServer.MerchantUpdate) {
            Entity entity = player.field_70170_p.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityVillager)) {
                return;
            }
            MerchantRecipeList list = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ((EntityVillager)entity).func_70930_a(list);
        } else if (type == EnumPacketServer.ModelDataSave) {
            if (npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)npc).modelData.readFromNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            }
        } else if (type == EnumPacketServer.MailOpenSetup) {
            PlayerMail mail = new PlayerMail();
            mail.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
            ContainerMail.staticmail = mail;
            player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 1, 0, 0);
        } else if (type == EnumPacketServer.TransformSave) {
            boolean isValid = npc.transform.isValid();
            npc.transform.readOptions(CompressedStreamTools.func_74794_a((DataInput)dis));
            if (isValid != npc.transform.isValid()) {
                npc.updateTasks();
            }
        } else if (type == EnumPacketServer.TransformGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.transform.writeOptions(new NBTTagCompound()));
        } else if (type == EnumPacketServer.TransformLoad) {
            if (npc.transform.isValid()) {
                npc.transform.transform(dis.readBoolean());
            }
        } else if (type == EnumPacketServer.TraderMarketSave) {
            String market = dis.readUTF();
            boolean bo = dis.readBoolean();
            if (npc.roleInterface instanceof RoleTrader) {
                if (bo) {
                    Market.setMarket(npc, market);
                } else {
                    Market.save((RoleTrader)npc.roleInterface, market);
                }
            }
        } else {
            this.blockPackets(type, buffer, dis, player);
        }
    }

    private void mountPackets(EnumPacketServer type, ByteBuf buffer, ByteBufInputStream dis, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnRider) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)CompressedStreamTools.func_74794_a((DataInput)dis), (World)player.field_70170_p);
            player.field_70170_p.func_72838_d(entity);
            entity.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.PlayerRider) {
            player.func_70078_a(ServerEventsHandler.mounted);
        } else {
            this.warn((EntityPlayer)player, "tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void clonePackets(EnumPacketServer type, ByteBuf payload, ByteBufInputStream dis, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnMob) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)player.field_70170_p);
            if (entity instanceof EntityNPCInterface) {
                EntityNPCInterface npc = (EntityNPCInterface)entity;
                System.out.println(compound.func_74762_e("FactionID") + ":" + npc.getFaction().id);
                npc.startPos = new int[]{MathHelper.func_76128_c((double)npc.field_70165_t), MathHelper.func_76128_c((double)npc.field_70163_u), MathHelper.func_76128_c((double)npc.field_70161_v)};
            }
            player.field_70170_p.func_72838_d(entity);
        } else if (type == EnumPacketServer.MobSpawner) {
            NoppesUtilServer.createMobSpawner(dis, (EntityPlayer)player);
        } else {
            this.warn((EntityPlayer)player, "tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void warn(EntityPlayer player, String warning) {
        MinecraftServer.func_71276_C().func_71236_h(player.func_70005_c_() + ": " + warning);
    }
}

