/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.player.GuiDialogInteract;
import noppes.npcs.client.gui.player.GuiDialogInteractWheel;
import noppes.npcs.client.gui.player.GuiQuestCompletion;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.Quest;
import noppes.npcs.entity.EntityNPCInterface;
import org.lwjgl.Sys;

public class NoppesUtil {
    private static EntityNPCInterface lastNpc;

    public static void requestOpenGUI(EnumGuiType gui) {
        NoppesUtil.requestOpenGUI(gui, 0, 0, 0);
    }

    public static void requestOpenGUI(EnumGuiType gui, int i, int j, int k) {
        Client.sendData(EnumPacketServer.Gui, gui.ordinal(), i, j, k);
    }

    public static void spawnParticle(ByteBufInputStream dis) {
        try {
            double posX = dis.readDouble();
            double posY = dis.readDouble();
            double posZ = dis.readDouble();
            float height = dis.readFloat();
            float width = dis.readFloat();
            float yOffset = dis.readFloat();
            String particle = dis.readUTF();
            WorldClient worldObj = Minecraft.func_71410_x().field_71441_e;
            Random rand = worldObj.field_73012_v;
            if (particle.equals("heal")) {
                for (int k = 0; k < 6; ++k) {
                    worldObj.func_72869_a("instantSpell", posX + (rand.nextDouble() - 0.5) * (double)width, posY + rand.nextDouble() * (double)height - (double)yOffset, posZ + (rand.nextDouble() - 0.5) * (double)width, 0.0, 0.0, 0.0);
                    worldObj.func_72869_a("spell", posX + (rand.nextDouble() - 0.5) * (double)width, posY + rand.nextDouble() * (double)height - (double)yOffset, posZ + (rand.nextDouble() - 0.5) * (double)width, 0.0, 0.0, 0.0);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static EntityNPCInterface getLastNpc() {
        return lastNpc;
    }

    public static void setLastNpc(EntityNPCInterface npc) {
        lastNpc = npc;
    }

    public static void openGUI(EntityPlayer player, Object guiscreen) {
        CustomNpcs.proxy.openGui(player, guiscreen);
    }

    public static void openFolder(File dir) {
        String s = dir.getAbsolutePath();
        if (Util.func_110647_a() == Util.EnumOS.MACOS) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", s});
                return;
            }
            catch (IOException ioexception1) {}
        } else if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
            String s1 = String.format("cmd.exe /C start \"Open file\" \"%s\"", s);
            try {
                Runtime.getRuntime().exec(s1);
                return;
            }
            catch (IOException ioexception) {
                // empty catch block
            }
        }
        boolean flag = false;
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, dir.toURI());
        }
        catch (Throwable throwable) {
            flag = true;
        }
        if (flag) {
            Sys.openURL((String)("file://" + s));
        }
    }

    public static void setScrollList(ByteBufInputStream dis) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null || !(gui instanceof IScrollData)) {
            return;
        }
        Vector<String> data = new Vector<String>();
        try {
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                data.add(dis.readUTF());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ((IScrollData)gui).setData(data, null);
    }

    public static void setScrollData(ByteBufInputStream dis) {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui == null) {
            return;
        }
        Vector<String> list = new Vector<String>();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        try {
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                int id = dis.readInt();
                String name = dis.readUTF();
                data.put(name, id);
                list.add(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
            gui = ((GuiNPCInterface)gui).getSubGui();
        }
        if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
            gui = ((GuiContainerNPCInterface)gui).getSubGui();
        }
        if (gui instanceof IScrollData) {
            ((IScrollData)gui).setData(list, data);
        }
    }

    public static void guiQuestCompletion(EntityPlayer player, NBTTagCompound read) {
        Quest quest = new Quest();
        quest.readNBT(read);
        if (!quest.completeText.equals("")) {
            NoppesUtil.openGUI(player, new GuiQuestCompletion(quest));
        } else {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestCompletion, quest.id);
        }
    }

    public static void openDialog(ByteBufInputStream dis, EntityNPCInterface npc, EntityPlayer player) throws IOException {
        if (DialogController.instance == null) {
            DialogController.instance = new DialogController();
        }
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        Dialog dialog = new Dialog();
        dialog.readNBT(compound);
        if (CustomNpcs.DialogType == 0) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof GuiDialogInteract)) {
                CustomNpcs.proxy.openGui(player, (Object)new GuiDialogInteract(npc, dialog));
            } else {
                GuiDialogInteract dia = (GuiDialogInteract)gui;
                dia.appendDialog(dialog);
            }
        } else {
            CustomNpcs.proxy.openGui(player, (Object)new GuiDialogInteractWheel(npc, dialog));
        }
    }

    public static void bankData(ByteBufInputStream dis) throws IOException {
        BankController controller = BankController.getInstance();
        controller.loadBanks(dis);
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui != null) {
            gui.func_73866_w_();
        }
    }

    public static void saveRedstoneBlock(EntityPlayer player, ByteBufInputStream dis) throws IOException {
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        int x = compound.func_74762_e("x");
        int y = compound.func_74762_e("y");
        int z = compound.func_74762_e("z");
        TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
        tile.func_145839_a(compound);
        CustomNpcs.proxy.openGui(x, y, z, EnumGuiType.RedstoneBlock, player);
    }

    public static void saveWayPointBlock(EntityPlayer player, ByteBufInputStream dis) throws IOException {
        NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
        int x = compound.func_74762_e("x");
        int y = compound.func_74762_e("y");
        int z = compound.func_74762_e("z");
        TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
        tile.func_145839_a(compound);
        CustomNpcs.proxy.openGui(x, y, z, EnumGuiType.Waypoint, player);
    }
}

