/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.QuestAchievement;
import noppes.npcs.client.RenderChatMessages;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.GuiNpcMobSpawnerAdd;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.entity.EntityNPCInterface;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBufInputStream buf = new ByteBufInputStream(event.packet.payload());
        try {
            this.client(buf, (EntityPlayer)player, EnumPacketClient.values()[buf.readInt()], event.packet.payload());
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void client(ByteBufInputStream dis, EntityPlayer player, EnumPacketClient type, ByteBuf buf) throws IOException {
        if (type == EnumPacketClient.CHATBUBBLE) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.messages == null) {
                npc.messages = new RenderChatMessages();
            }
            String text = NoppesStringUtils.formatText(dis.readUTF(), player.getDisplayName());
            npc.messages.addMessage(text);
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(npc.func_70005_c_() + ": " + text, new Object[0]));
        } else if (type == EnumPacketClient.CHAT) {
            String message = "";
            try {
                while (true) {
                    String str;
                    if ((str = dis.readUTF()) == null || str.isEmpty()) {
                        continue;
                    }
                    message = message + StatCollector.func_74838_a((String)str);
                }
            }
            catch (EOFException e) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
            }
        } else if (type == EnumPacketClient.MESSAGE) {
            String description = StatCollector.func_74838_a((String)dis.readUTF());
            String message = dis.readUTF();
            QuestAchievement ach = new QuestAchievement(message, description);
            Minecraft.func_71410_x().field_71458_u.func_146256_a((Achievement)ach);
            ObfuscationReflectionHelper.setPrivateValue(GuiAchievement.class, (Object)Minecraft.func_71410_x().field_71458_u, (Object)ach.func_75989_e(), (int)4);
        } else if (type == EnumPacketClient.SYNCRECIPES_ADD) {
            NBTTagList list = CompressedStreamTools.func_74794_a((DataInput)dis).func_150295_c("recipes", 10);
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                RecipeCarpentry recipe = new RecipeCarpentry();
                recipe.readNBT(list.func_150305_b(i));
                RecipeController.syncRecipes.put(recipe.id, recipe);
            }
        } else if (type == EnumPacketClient.SYNCRECIPES_WORKBENCH) {
            RecipeController.reloadGlobalRecipes(RecipeController.syncRecipes);
            RecipeController.syncRecipes = new HashMap();
        } else if (type == EnumPacketClient.SYNCRECIPES_CARPENTRYBENCH) {
            RecipeController.instance.anvilRecipes = RecipeController.syncRecipes;
            RecipeController.syncRecipes = new HashMap();
        } else if (type == EnumPacketClient.DIALOG) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.openDialog(dis, (EntityNPCInterface)entity, player);
        } else if (type == EnumPacketClient.QUEST_COMPLETION) {
            NoppesUtil.guiQuestCompletion(player, CompressedStreamTools.func_74794_a((DataInput)dis));
        } else if (type == EnumPacketClient.EDIT_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.PLAY_MUSIC) {
            MusicController.Instance.playMusic(dis.readUTF(), (Entity)player);
        } else if (type == EnumPacketClient.PLAY_SOUND) {
            MusicController.Instance.playSound(dis.readUTF(), dis.readFloat(), dis.readFloat(), dis.readFloat());
        } else if (type == EnumPacketClient.UPDATE_NPC) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).readSpawnData(compound);
        } else if (type == EnumPacketClient.ROLE) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).advanced.setRole(compound.func_74762_e("Role"));
            ((EntityNPCInterface)entity).roleInterface.readFromNBT(compound);
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.GUI) {
            EnumGuiType gui = EnumGuiType.values()[dis.readInt()];
            CustomNpcs.proxy.openGui(NoppesUtil.getLastNpc(), gui, dis.readInt(), dis.readInt(), dis.readInt());
        } else if (type == EnumPacketClient.PARTICLE) {
            NoppesUtil.spawnParticle(dis);
        } else if (type == EnumPacketClient.DELETE_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(dis.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).delete();
        } else if (type == EnumPacketClient.SCROLL_LIST) {
            NoppesUtil.setScrollList(dis);
        } else if (type == EnumPacketClient.SCROLL_DATA) {
            NoppesUtil.setScrollData(dis);
        } else if (type == EnumPacketClient.SCROLL_SELECTED) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IScrollData)) {
                return;
            }
            String selected = dis.readUTF();
            ((IScrollData)gui).setSelected(selected);
        } else if (type == EnumPacketClient.GUI_REDSTONE) {
            NoppesUtil.saveRedstoneBlock(player, dis);
        } else if (type == EnumPacketClient.GUI_WAYPOINT) {
            NoppesUtil.saveWayPointBlock(player, dis);
        } else if (type == EnumPacketClient.CLONE) {
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            NoppesUtil.openGUI(player, (Object)new GuiNpcMobSpawnerAdd(compound));
        } else if (type == EnumPacketClient.GUI_DATA) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
                gui = ((GuiNPCInterface)gui).getSubGui();
            } else if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
                gui = ((GuiContainerNPCInterface)gui).getSubGui();
            }
            if (gui instanceof IGuiData) {
                ((IGuiData)gui).setGuiData(CompressedStreamTools.func_74794_a((DataInput)dis));
            }
        } else if (type == EnumPacketClient.GUI_ERROR) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IGuiError)) {
                return;
            }
            int i = dis.readInt();
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            ((IGuiError)gui).setError(i, compound);
        } else if (type == EnumPacketClient.GUI_CLOSE) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof IGuiClose) {
                int i = dis.readInt();
                NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
                ((IGuiClose)gui).setClose(i, compound);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a(null);
            mc.func_71381_h();
        } else if (type == EnumPacketClient.VILLAGER_LIST) {
            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buf));
            ServerEventsHandler.Merchant.func_70930_a(merchantrecipelist);
        }
    }
}

