/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import io.netty.buffer.ByteBufInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.constants.EnumOptionType;
import noppes.npcs.controllers.Dialog;
import noppes.npcs.controllers.DialogCategory;
import noppes.npcs.controllers.DialogOption;

public class DialogController {
    public HashMap<Integer, DialogCategory> categories = new HashMap();
    public HashMap<Integer, Dialog> dialogs = new HashMap();
    public static DialogController instance;
    private static final String lock = "lock";
    private int lastUsedCatID = 0;
    private int lastUsedDialogID = 0;

    public DialogController() {
        instance = this;
        this.loadCategories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCategories() {
        boolean loadDefault = false;
        String string = lock;
        synchronized (lock) {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            try {
                File file = new File(saveDir, "dialog.dat");
                if (file.exists()) {
                    this.loadCategories(file);
                } else {
                    loadDefault = true;
                }
            }
            catch (Exception e) {
                try {
                    File file = new File(saveDir, "dialog.dat_old");
                    if (file.exists()) {
                        this.loadCategories(file);
                    }
                }
                catch (Exception ee) {
                    e.printStackTrace();
                }
            }
            if (loadDefault) {
                this.loadDefaultDialogs();
            }
            return;
        }
    }

    private void loadCategories(File file) throws Exception {
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        this.lastUsedCatID = nbttagcompound1.func_74762_e("lastID");
        this.lastUsedDialogID = nbttagcompound1.func_74762_e("lastDialogID");
        NBTTagList list = nbttagcompound1.func_150295_c("Data", 10);
        HashMap<Integer, DialogCategory> categories = new HashMap<Integer, DialogCategory>();
        HashMap<Integer, Dialog> dialogs = new HashMap<Integer, Dialog>();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                DialogCategory category = new DialogCategory();
                category.readNBT(list.func_150305_b(i));
                categories.put(category.id, category);
                Iterator<Map.Entry<Integer, Dialog>> ita = category.dialogs.entrySet().iterator();
                while (ita.hasNext()) {
                    Map.Entry<Integer, Dialog> entry = ita.next();
                    if (dialogs.containsKey(entry.getValue().id)) {
                        ita.remove();
                        continue;
                    }
                    dialogs.put(entry.getValue().id, entry.getValue());
                }
            }
        }
        this.categories = categories;
        this.dialogs = dialogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCategories() {
        String string = lock;
        synchronized (lock) {
            try {
                File saveDir = CustomNpcs.getWorldSaveDirectory();
                NBTTagList list = new NBTTagList();
                for (DialogCategory category : this.categories.values()) {
                    NBTTagCompound nbtfactions = new NBTTagCompound();
                    category.writeNBT(nbtfactions);
                    list.func_74742_a((NBTBase)nbtfactions);
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("lastID", this.lastUsedCatID);
                nbttagcompound.func_74768_a("lastDialogID", this.lastUsedDialogID);
                nbttagcompound.func_74782_a("Data", (NBTBase)list);
                File file = new File(saveDir, "dialog.dat_new");
                File file1 = new File(saveDir, "dialog.dat_old");
                File file2 = new File(saveDir, "dialog.dat");
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)new FileOutputStream(file));
                if (file1.exists()) {
                    file1.delete();
                }
                file2.renameTo(file1);
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void loadDefaultDialogs() {
        if (this.categories.isEmpty() && this.categories.isEmpty()) {
            DialogCategory cat = new DialogCategory();
            cat.id = 1;
            cat.title = "Villager";
            Dialog dia1 = new Dialog();
            dia1.id = 1;
            dia1.category = cat;
            dia1.title = "Start";
            dia1.text = "Hello {player}, \n\nWelcome to our village. I hope you enjoy your stay";
            Dialog dia2 = new Dialog();
            dia2.id = 2;
            dia2.category = cat;
            dia2.title = "Ask about village";
            dia2.text = "This village has been around for ages. Enjoy your stay here.";
            Dialog dia3 = new Dialog();
            dia3.id = 3;
            dia3.category = cat;
            dia3.title = "Who are you";
            dia3.text = "I'm a villager here. I have lived in this village my whole life.";
            cat.dialogs.put(dia1.id, dia1);
            cat.dialogs.put(dia2.id, dia2);
            cat.dialogs.put(dia3.id, dia3);
            DialogOption option = new DialogOption();
            option.title = "Tell me something about this village";
            option.dialogId = 2;
            option.optionType = EnumOptionType.DialogOption;
            DialogOption option2 = new DialogOption();
            option2.title = "Who are you?";
            option2.dialogId = 3;
            option2.optionType = EnumOptionType.DialogOption;
            DialogOption option3 = new DialogOption();
            option3.title = "Goodbye";
            option3.optionType = EnumOptionType.QuitOption;
            dia1.options.put(0, option2);
            dia1.options.put(1, option);
            dia1.options.put(2, option3);
            DialogOption option4 = new DialogOption();
            option4.title = "Back";
            option4.dialogId = 1;
            dia2.options.put(1, option4);
            dia3.options.put(1, option4);
            this.categories.put(cat.id, cat);
            this.dialogs.put(dia1.id, dia1);
            this.dialogs.put(dia2.id, dia2);
            this.dialogs.put(dia3.id, dia3);
            this.lastUsedCatID = 3;
            this.saveCategories();
        }
    }

    public void removeDialog(Dialog dialog) {
        DialogCategory category = dialog.category;
        category.dialogs.remove(dialog.id);
        this.dialogs.remove(dialog.id);
        this.saveCategories();
    }

    public void saveCategory(DialogCategory category) throws IOException {
        if (category.id < 0) {
            if (this.lastUsedCatID == 0) {
                for (int catid : this.categories.keySet()) {
                    if (catid <= this.lastUsedCatID) continue;
                    this.lastUsedCatID = catid;
                }
            }
            ++this.lastUsedCatID;
            category.id = this.lastUsedCatID;
        }
        if (this.categories.containsKey(category.id)) {
            DialogCategory currentCategory = this.categories.get(category.id);
            if (!currentCategory.title.equals(category.title)) {
                while (this.containsCategoryName(category.title)) {
                    category.title = category.title + "_";
                }
            }
            category.dialogs = currentCategory.dialogs;
        } else {
            while (this.containsCategoryName(category.title)) {
                category.title = category.title + "_";
            }
        }
        this.categories.put(category.id, category);
        this.saveCategories();
    }

    public void removeCategory(ByteBufInputStream dis) throws IOException {
        int category = dis.readInt();
        DialogCategory cat = this.categories.get(category);
        if (cat == null) {
            return;
        }
        for (int dia : cat.dialogs.keySet()) {
            this.dialogs.remove(dia);
        }
        this.categories.remove(category);
        this.saveCategories();
    }

    private boolean containsCategoryName(String name) {
        name = name.toLowerCase();
        for (DialogCategory cat : this.categories.values()) {
            if (!cat.title.toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean containsDialogName(DialogCategory category, String name) {
        name = name.toLowerCase();
        for (Dialog dia : category.dialogs.values()) {
            if (!dia.title.toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void saveDialog(int categoryId, Dialog dialog) throws IOException {
        DialogCategory category = this.categories.get(categoryId);
        if (category == null) {
            return;
        }
        dialog.category = category;
        if (dialog.id < 0) {
            if (this.lastUsedDialogID == 0) {
                for (int catid : this.dialogs.keySet()) {
                    if (catid <= this.lastUsedDialogID) continue;
                    this.lastUsedDialogID = catid;
                }
            }
            ++this.lastUsedDialogID;
            dialog.id = this.lastUsedDialogID;
            while (this.containsDialogName(dialog.category, dialog.title)) {
                dialog.title = dialog.title + "_";
            }
        }
        this.dialogs.put(dialog.id, dialog);
        dialog.category.dialogs.put(dialog.id, dialog);
        this.saveCategories();
    }

    public boolean hasDialog(int dialogId) {
        return this.dialogs.containsKey(dialogId);
    }

    public Map<String, Integer> getScroll() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DialogCategory category : this.categories.values()) {
            map.put(category.title, category.id);
        }
        return map;
    }
}

