/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.scripted.ScriptItemStack;

public class ScriptLivingBase {
    protected EntityLivingBase entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();

    public ScriptLivingBase(EntityLivingBase entity) {
        this.entity = entity;
    }

    public float getHealth() {
        return this.entity.func_110143_aJ();
    }

    public void setHealth(float health) {
        this.entity.func_70606_j(health);
    }

    public float getMaxHealth() {
        return this.entity.func_110138_aP();
    }

    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    public double getX() {
        return this.entity.field_70165_t;
    }

    public void setX(double x) {
        this.entity.field_70165_t = x;
    }

    public double getY() {
        return this.entity.field_70163_u;
    }

    public void setY(double y) {
        this.entity.field_70163_u = y;
    }

    public double getZ() {
        return this.entity.field_70161_v;
    }

    public void setZ(double z) {
        this.entity.field_70161_v = z;
    }

    public int getBlockX() {
        return MathHelper.func_76128_c((double)this.entity.field_70165_t);
    }

    public int getBlockY() {
        return MathHelper.func_76128_c((double)this.entity.field_70163_u);
    }

    public int getBlockZ() {
        return MathHelper.func_76128_c((double)this.entity.field_70161_v);
    }

    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    public boolean isAttacking() {
        return this.entity.func_70643_av() != null;
    }

    public void setAttackTarget(ScriptLivingBase living) {
        if (living == null) {
            this.entity.func_70604_c(null);
        } else {
            this.entity.func_70604_c(living.entity);
        }
    }

    public ScriptLivingBase getAttackTarget() {
        return ScriptController.Instance.getScriptForEntity(this.entity.func_70643_av());
    }

    public ScriptLivingBase[] getSurroundingEntities(int range) {
        List entities = this.entity.field_70170_p.func_72872_a(EntityLivingBase.class, this.entity.field_70121_D.func_72314_b((double)range, (double)range, (double)range));
        ArrayList<ScriptLivingBase> list = new ArrayList<ScriptLivingBase>();
        for (EntityLivingBase living : entities) {
            if (living == this.entity) continue;
            list.add(ScriptController.Instance.getScriptForEntity(living));
        }
        return list.toArray(new ScriptLivingBase[list.size()]);
    }

    public Object getTempData(String key) {
        return this.tempData.get(key);
    }

    public void setTempData(String key, Object value) {
        this.tempData.put(key, value);
    }

    public boolean hasTempData(String key) {
        return this.tempData.containsKey(key);
    }

    public void removeTempData(String key) {
        this.tempData.remove(key);
    }

    public void clearTempData() {
        this.tempData.clear();
    }

    public Object getStoredData(String key) {
        NBTTagCompound compound = this.getStoredCompound();
        if (!compound.func_74764_b(key)) {
            return null;
        }
        NBTBase base = compound.func_74781_a(key);
        if (base instanceof NBTBase.NBTPrimitive) {
            return ((NBTBase.NBTPrimitive)base).func_150286_g();
        }
        return ((NBTTagString)base).func_150285_a_();
    }

    public void setStoredData(String key, Object value) {
        NBTTagCompound compound = this.getStoredCompound();
        if (value instanceof Number) {
            compound.func_74780_a(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            compound.func_74778_a(key, (String)value);
        }
        this.saveStoredCompound(compound);
    }

    public boolean hasStoredData(String key) {
        return this.getStoredCompound().func_74764_b(key);
    }

    public void removeStoredData(String key) {
        NBTTagCompound compound = this.getStoredCompound();
        compound.func_82580_o(key);
        this.saveStoredCompound(compound);
    }

    public void clearStoredData() {
        this.entity.getEntityData().func_82580_o("CNPCStoredData");
    }

    private NBTTagCompound getStoredCompound() {
        NBTTagCompound compound = this.entity.getEntityData().func_74775_l("CNPCStoredData");
        if (compound == null) {
            compound = new NBTTagCompound();
            this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
        }
        return compound;
    }

    private void saveStoredCompound(NBTTagCompound compound) {
        this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
    }

    public boolean inWater() {
        return this.entity.func_70055_a(Material.field_151586_h);
    }

    public boolean inLava() {
        return this.entity.func_70055_a(Material.field_151587_i);
    }

    public boolean inFire() {
        return this.entity.func_70055_a(Material.field_151581_o);
    }

    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    public void setBurning(int ticks) {
        this.entity.func_70015_d(ticks);
    }

    public void extinguish() {
        this.entity.func_70066_B();
    }

    public int getType() {
        return 0;
    }

    public String getTypeName() {
        return EntityList.func_75621_b((Entity)this.entity);
    }

    public boolean canSeeEntity(ScriptLivingBase entity) {
        return entity.entity.func_70685_l((Entity)entity.entity);
    }

    public void despawn() {
        this.entity.field_70128_L = true;
    }

    public int getAge() {
        return this.entity.field_70173_aa;
    }

    public EntityLivingBase getMinecraftEntity() {
        return this.entity;
    }

    public void swingHand() {
        this.entity.func_71038_i();
    }

    public void dropItem(ScriptItemStack item) {
        this.entity.func_70099_a(item.item, 0.0f);
    }

    public void addPotionEffect(int effect, int duration, int strength, boolean hideParticles) {
        if (effect < 0 || effect >= Potion.field_76425_a.length || Potion.field_76425_a[effect] == null) {
            return;
        }
        if (strength < 0) {
            strength = 0;
        } else if (strength > 255) {
            strength = 255;
        }
        if (duration < 0) {
            duration = 0;
        } else if (duration > 1000000) {
            duration = 1000000;
        }
        if (!Potion.field_76425_a[effect].func_76403_b()) {
            duration *= 20;
        }
        if (duration == 0) {
            this.entity.func_82170_o(effect);
        } else {
            this.entity.func_70690_d(new PotionEffect(effect, duration, strength));
        }
    }

    public void clearPotionEffects() {
        this.entity.func_70674_bp();
    }
}

